/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpadiagrameditor.ui.tests.internal.feature;

import java.util.Date;
import org.easymock.EasyMock;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.BasicInternalEList;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.ICustomContext;
import org.eclipse.graphiti.features.context.IRemoveContext;
import org.eclipse.graphiti.features.custom.ICustomFeature;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;
import org.eclipse.jpt.jpa.core.JpaProject;
import org.eclipse.jpt.jpa.core.context.PersistentAttribute;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.feature.RemoveAttributeFeature;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.provider.IJPAEditorFeatureProvider;
import org.eclipse.jpt.jpadiagrameditor.ui.tests.internal.JPACreateFactory;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class RemoveAttributeFeatureTest {
    private IJPAEditorFeatureProvider featureProvider;
    private IRemoveContext context;
    final String TEST_PROJECT = "Test" + new Date().getTime();
    private JpaProject jpaProject = null;
    private JPACreateFactory factory = null;
    private IFile entity;

    @Before
    public void setUp() throws Exception {
        this.factory = JPACreateFactory.instance();
        this.jpaProject = this.factory.createJPAProject(String.valueOf(this.TEST_PROJECT) + "_" + System.currentTimeMillis());
        Assert.assertNotNull((Object)this.jpaProject);
        this.entity = this.factory.createEntity(this.jpaProject, "org.eclipse.Ent");
        Thread.sleep(2000L);
        this.factory.addAttributes(this.entity, "att", "java.lang.String", "", "att", false);
    }

    @Test
    public void testRemoveAttributeFeature() {
        GraphicsAlgorithm algorithm = (GraphicsAlgorithm)EasyMock.createNiceMock(GraphicsAlgorithm.class);
        EasyMock.replay((Object[])new Object[]{algorithm});
        EList list = (EList)EasyMock.createMock(EList.class);
        Shape shape = (Shape)EasyMock.createNiceMock(Shape.class);
        EasyMock.expect((Object)shape.getGraphicsAlgorithm()).andReturn((Object)algorithm);
        EasyMock.expect((Object)shape.getAnchors()).andReturn((Object)list);
        EasyMock.replay((Object[])new Object[]{shape});
        ContainerShape pictogramElement = (ContainerShape)EasyMock.createMock(ContainerShape.class);
        Resource res = (Resource)EasyMock.createMock(Resource.class);
        EasyMock.expect((Object)pictogramElement.eResource()).andStubReturn((Object)res);
        ResourceSet rs = (ResourceSet)EasyMock.createMock(ResourceSet.class);
        EasyMock.expect((Object)res.getResourceSet()).andStubReturn((Object)rs);
        BasicInternalEList ead = new BasicInternalEList(Adapter.class);
        EasyMock.expect((Object)rs.eAdapters()).andStubReturn((Object)ead);
        EasyMock.replay((Object[])new Object[]{pictogramElement, res, rs});
        this.featureProvider = (IJPAEditorFeatureProvider)EasyMock.createMock(IJPAEditorFeatureProvider.class);
        EasyMock.expect((Object)this.featureProvider.getBusinessObjectForPictogramElement((PictogramElement)pictogramElement)).andReturn((Object)JPACreateFactory.getPersistentAttribute(this.entity, "att"));
        EasyMock.expect((Object)this.featureProvider.decreaseAttribsNum((Shape)pictogramElement)).andReturn((Object)0);
        EasyMock.expect((Object)this.featureProvider.getKeyForBusinessObject(EasyMock.isA(Object.class))).andReturn((Object)"");
        EasyMock.expect((Object)this.featureProvider.remove("")).andReturn(null);
        EasyMock.expect((Object)this.featureProvider.getRelationRelatedToAttribute((PersistentAttribute)EasyMock.isA(PersistentAttribute.class), this.entity.getName())).andReturn(null);
        EasyMock.replay((Object[])new Object[]{this.featureProvider});
        this.context = (IRemoveContext)EasyMock.createMock(IRemoveContext.class);
        EasyMock.expect((Object)this.context.getPictogramElement()).andReturn((Object)pictogramElement);
        EasyMock.replay((Object[])new Object[]{this.context});
        ICustomFeature graphicalRemove = (ICustomFeature)EasyMock.createMock(ICustomFeature.class);
        graphicalRemove.execute((ICustomContext)EasyMock.isA(ICustomContext.class));
        EasyMock.replay((Object[])new Object[]{graphicalRemove});
        RemoveAttributeFeature feature = new RemoveAttributeFeature((IFeatureProvider)this.featureProvider, graphicalRemove);
        feature.preRemove(this.context);
    }
}

