/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.ui.internal.handlers;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jpt.common.core.resource.xml.JptXmlResource;
import org.eclipse.jpt.common.ui.internal.utility.SynchronousUiCommandContext;
import org.eclipse.jpt.common.utility.command.Command;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.jpa.core.JpaProject;
import org.eclipse.jpt.jpa.core.JpaProjectManager;
import org.eclipse.jpt.jpa.core.context.persistence.Persistence;
import org.eclipse.jpt.jpa.core.context.persistence.PersistenceUnit;
import org.eclipse.jpt.jpa.core.context.persistence.PersistenceXml;
import org.eclipse.jpt.jpa.ui.JptJpaUiMessages;
import org.eclipse.jpt.jpa.ui.internal.plugin.JptJpaUiPlugin;
import org.eclipse.ui.handlers.HandlerUtil;

public class SynchronizeClassesHandler
extends AbstractHandler {
    private IFile persistenceXmlFile;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IStructuredSelection selection = (IStructuredSelection)HandlerUtil.getCurrentSelectionChecked((ExecutionEvent)event);
        this.persistenceXmlFile = this.buildPersistenceXmlFile(selection.getFirstElement());
        try {
            SyncRunnable runnable = new SyncRunnable(this.persistenceXmlFile);
            this.buildProgressMonitorDialog().run(true, true, (IRunnableWithProgress)runnable);
        }
        catch (InvocationTargetException ex) {
            JptJpaUiPlugin.instance().logError(ex);
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            JptJpaUiPlugin.instance().logError(ex);
        }
        return null;
    }

    private IFile buildPersistenceXmlFile(Object selection) {
        if (selection instanceof IFile) {
            return (IFile)selection;
        }
        if (selection instanceof PersistenceXml) {
            return (IFile)((PersistenceXml)selection).getResource();
        }
        return null;
    }

    private ProgressMonitorDialog buildProgressMonitorDialog() {
        return new ProgressMonitorDialog(null);
    }

    static class SyncCommand
    implements Command {
        private final PersistenceUnit persistenceUnit;
        private final IProgressMonitor monitor;

        SyncCommand(PersistenceUnit persistenceUnit, IProgressMonitor monitor) {
            this.persistenceUnit = persistenceUnit;
            this.monitor = monitor;
        }

        public void execute() {
            this.persistenceUnit.synchronizeClasses(this.monitor);
        }

        public String toString() {
            return ObjectTools.toString((Object)this, (Object)this.persistenceUnit);
        }
    }

    static class SyncRunnable
    implements IRunnableWithProgress {
        private IFile persistenceXmlFile;

        SyncRunnable(IFile persistenceXmlFile) {
            this.persistenceXmlFile = persistenceXmlFile;
        }

        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
            try {
                this.run_(monitor);
            }
            catch (CoreException ex) {
                throw new InvocationTargetException(ex);
            }
        }

        private void run_(IProgressMonitor monitor) throws CoreException {
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            ISchedulingRule rule = workspace.getRuleFactory().modifyRule((IResource)this.persistenceXmlFile.getProject());
            workspace.run((IWorkspaceRunnable)new SyncWorkspaceRunnable(this.persistenceXmlFile), rule, 1, monitor);
        }
    }

    static class SyncWorkspaceRunnable
    implements IWorkspaceRunnable {
        private IFile persistenceXmlFile;

        SyncWorkspaceRunnable(IFile persistenceXmlFile) {
            this.persistenceXmlFile = persistenceXmlFile;
        }

        public void run(IProgressMonitor monitor) throws CoreException {
            PersistenceUnit persistenceUnit;
            if (monitor.isCanceled()) {
                return;
            }
            SubMonitor sm = SubMonitor.convert((IProgressMonitor)monitor, (String)JptJpaUiMessages.SYNCHRONIZING_CLASSES_TASK_NAME, (int)20);
            JpaProject jpaProject = this.getJpaProject();
            if (jpaProject == null) {
                return;
            }
            JptXmlResource resource = jpaProject.getPersistenceXmlResource();
            if (resource == null) {
                return;
            }
            if (sm.isCanceled()) {
                return;
            }
            sm.worked(1);
            PersistenceXml persistenceXml = jpaProject.getContextRoot().getPersistenceXml();
            if (persistenceXml == null) {
                return;
            }
            Persistence persistence = persistenceXml.getRoot();
            if (persistence == null) {
                return;
            }
            PersistenceUnit persistenceUnit2 = persistenceUnit = persistence.getPersistenceUnitsSize() == 0 ? persistence.addPersistenceUnit() : persistence.getPersistenceUnit(0);
            if (sm.isCanceled()) {
                return;
            }
            sm.worked(1);
            SyncCommand syncCommand = new SyncCommand(persistenceUnit, (IProgressMonitor)sm.newChild(17));
            JpaProjectManager mgr = this.getJpaProjectManager();
            try {
                if (mgr != null) {
                    mgr.execute((Command)syncCommand, SynchronousUiCommandContext.instance());
                }
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
                throw new RuntimeException(ex);
            }
            resource.save();
            sm.worked(1);
        }

        private JpaProjectManager getJpaProjectManager() {
            return (JpaProjectManager)this.getWorkspace().getAdapter(JpaProjectManager.class);
        }

        private IProject getProject() {
            return this.persistenceXmlFile.getProject();
        }

        private JpaProject getJpaProject() {
            return (JpaProject)this.getProject().getAdapter(JpaProject.class);
        }

        private IWorkspace getWorkspace() {
            return this.persistenceXmlFile.getWorkspace();
        }
    }
}

