/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.Node;

final class CheckGlobalThis
implements NodeTraversal.Callback {
    static final DiagnosticType GLOBAL_THIS = DiagnosticType.warning("JSC_USED_GLOBAL_THIS", "dangerous use of the global 'this' object");
    private final AbstractCompiler compiler;
    private Node assignLhsChild = null;

    CheckGlobalThis(AbstractCompiler compiler) {
        this.compiler = compiler;
    }

    @Override
    public boolean shouldTraverse(NodeTraversal t, Node n, Node parent) {
        if (n.isFunction()) {
            JSDocInfo maybeLends;
            if (n.isArrowFunction()) {
                return true;
            }
            JSDocInfo jsDoc = NodeUtil.getBestJSDocInfo(n);
            if (jsDoc != null && (jsDoc.isConstructor() || jsDoc.isInterface() || jsDoc.hasThisType() || jsDoc.isOverride())) {
                return false;
            }
            int pType = parent.getType();
            if (pType != 125 && pType != 132 && pType != 38 && pType != 86 && pType != 154) {
                return false;
            }
            Node grandparent = parent.getParent();
            if (NodeUtil.isObjectLitKey(parent) && (maybeLends = grandparent.getJSDocInfo()) != null && maybeLends.getLendsName() != null && maybeLends.getLendsName().endsWith(".prototype")) {
                return false;
            }
        }
        if (parent != null && parent.isAssign()) {
            Node lhs = parent.getFirstChild();
            if (n == lhs) {
                if (this.assignLhsChild == null) {
                    this.assignLhsChild = lhs;
                }
            } else if (NodeUtil.isGet(lhs)) {
                if (lhs.isGetProp() && lhs.getLastChild().getString().equals("prototype")) {
                    return false;
                }
                Node llhs = lhs.getFirstChild();
                if (llhs.isGetProp() && llhs.getLastChild().getString().equals("prototype")) {
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        if (n.isThis() && this.shouldReportThis(n)) {
            this.compiler.report(t.makeError(n, GLOBAL_THIS, new String[0]));
        }
        if (n == this.assignLhsChild) {
            this.assignLhsChild = null;
        }
    }

    private boolean shouldReportThis(Node n) {
        Node parent = n.getParent();
        if (this.assignLhsChild != null) {
            return true;
        }
        return parent != null && NodeUtil.isGet(parent);
    }
}

