/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.jaxws.dom.runtime.tests.dom.persistence.defaults;

import junit.framework.TestCase;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jst.ws.jaxws.dom.runtime.IPropertyDefaults;
import org.eclipse.jst.ws.jaxws.dom.runtime.api.DomFactory;
import org.eclipse.jst.ws.jaxws.dom.runtime.api.DomPackage;
import org.eclipse.jst.ws.jaxws.dom.runtime.api.IWebService;
import org.eclipse.jst.ws.jaxws.dom.runtime.persistence.defaults.PropertyDefaultsAdapterFactory;
import org.eclipse.jst.ws.jaxws.dom.runtime.persistence.defaults.WsPropertyDefaultsAdapter;

public class WsPropertyDefaultsAdapterTest
extends TestCase {
    private IWebService webService;
    private IPropertyDefaults defaults;

    public void setUp() {
        this.webService = DomFactory.eINSTANCE.createIWebService();
        this.webService.eSet((EStructuralFeature)DomPackage.Literals.IJAVA_WEB_SERVICE_ELEMENT__IMPLEMENTATION, (Object)"com.sap.test.MyWs");
        this.defaults = (IPropertyDefaults)PropertyDefaultsAdapterFactory.INSTANCE.adapt((Notifier)this.webService, IPropertyDefaults.class);
    }

    public void testNameDefaultValue() {
        this.webService.setName("Test");
        WsPropertyDefaultsAdapterTest.assertEquals((Object)"MyWsService", (Object)this.defaults.getDefault((EStructuralFeature)DomPackage.Literals.IJAVA_WEB_SERVICE_ELEMENT__NAME));
    }

    public void testPortNameDefaultValue() {
        this.webService.setPortName("TestPortName");
        WsPropertyDefaultsAdapterTest.assertEquals((Object)"MyWsPort", (Object)this.defaults.getDefault((EStructuralFeature)DomPackage.Literals.IWEB_SERVICE__PORT_NAME));
    }

    public void testTargetNamespaceDefaultValue() {
        this.webService.setTargetNamespace("test");
        WsPropertyDefaultsAdapterTest.assertEquals((Object)"http://sap.com/test/", (Object)this.defaults.getDefault((EStructuralFeature)DomPackage.Literals.IWEB_SERVICE__TARGET_NAMESPACE));
    }

    public void testAdaptedOnce() {
        IPropertyDefaults adapter = (IPropertyDefaults)PropertyDefaultsAdapterFactory.INSTANCE.adapt((Notifier)this.webService, IPropertyDefaults.class);
        WsPropertyDefaultsAdapterTest.assertTrue((boolean)(adapter instanceof WsPropertyDefaultsAdapter));
        WsPropertyDefaultsAdapterTest.assertEquals((int)1, (int)this.webService.eAdapters().size());
        WsPropertyDefaultsAdapterTest.assertEquals((Object)this.defaults, (Object)adapter);
    }
}

