/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.chromium.internal.v8native;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import org.eclipse.wst.jsdt.chromium.Breakpoint;
import org.eclipse.wst.jsdt.chromium.CallFrame;
import org.eclipse.wst.jsdt.chromium.DebugContext;
import org.eclipse.wst.jsdt.chromium.JavascriptVm;
import org.eclipse.wst.jsdt.chromium.JsObject;
import org.eclipse.wst.jsdt.chromium.JsScope;
import org.eclipse.wst.jsdt.chromium.JsVariable;
import org.eclipse.wst.jsdt.chromium.internal.browserfixture.AbstractAttachedTest;
import org.eclipse.wst.jsdt.chromium.internal.transport.FakeConnection;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class DebugContextImplTest
extends AbstractAttachedTest<FakeConnection> {
    @Test(timeout=5000L)
    @Ignore
    public void checkContextIsInvalidatedOnContinue() throws Exception {
        final Breakpoint[] bp = new Breakpoint[1];
        final String[] failure = new String[1];
        final CountDownLatch latch = new CountDownLatch(1);
        Breakpoint.Target.ScriptName target = new Breakpoint.Target.ScriptName("file:///C:/1.js");
        this.javascriptVm.setBreakpoint((Breakpoint.Target)target, 18, 3, true, null, new JavascriptVm.BreakpointCallback(){

            public void failure(String errorMessage) {
                failure[0] = errorMessage == null ? "" : errorMessage;
                latch.countDown();
            }

            public void success(Breakpoint breakpoint) {
                bp[0] = breakpoint;
                latch.countDown();
            }
        }, null);
        latch.await();
        Assert.assertNull((String)("Failed to set a breakpoint: " + failure[0]), (Object)failure[0]);
        Assert.assertNotNull((String)"Breakpoint not set", (Object)bp[0]);
        latch = this.expectSuspend();
        this.messageResponder.hitBreakpoints(Collections.singleton(bp[0].getId()));
        latch.await();
        List variableScopes = ((CallFrame)this.suspendContext.getCallFrames().get(0)).getVariableScopes();
        Collection<? extends JsVariable> variables = DebugContextImplTest.getScopeVariables((JsScope)variableScopes.get(0));
        this.suspendContext.continueVm(DebugContext.StepAction.CONTINUE, 1, null);
        JsObject jsObject = variables.iterator().next().getValue().asObject();
        try {
            jsObject.getProperties();
            Assert.fail();
        }
        catch (RuntimeException runtimeException) {}
    }

    @Test(timeout=5000L)
    @Ignore
    public void checkContextIsValidOffHand() throws Exception {
        final Breakpoint[] bp = new Breakpoint[1];
        final String[] failure = new String[1];
        final CountDownLatch latch = new CountDownLatch(1);
        Breakpoint.Target.ScriptName target = new Breakpoint.Target.ScriptName("file:///C:/1.js");
        this.javascriptVm.setBreakpoint((Breakpoint.Target)target, 18, 3, true, null, new JavascriptVm.BreakpointCallback(){

            public void failure(String errorMessage) {
                failure[0] = errorMessage == null ? "" : errorMessage;
                latch.countDown();
            }

            public void success(Breakpoint breakpoint) {
                bp[0] = breakpoint;
                latch.countDown();
            }
        }, null);
        latch.await();
        Assert.assertNull((String)("Failed to set a breakpoint: " + failure[0]), (Object)failure[0]);
        Assert.assertNotNull((String)"Breakpoint not set", (Object)bp[0]);
        latch = this.expectSuspend();
        this.messageResponder.hitBreakpoints(Collections.singleton(bp[0].getId()));
        latch.await();
        List variableScopes = ((CallFrame)this.suspendContext.getCallFrames().get(0)).getVariableScopes();
        Collection<? extends JsVariable> variables = DebugContextImplTest.getScopeVariables((JsScope)variableScopes.get(0));
        JsObject jsObject = variables.iterator().next().getValue().asObject();
        jsObject.getProperties();
    }

    @Override
    protected FakeConnection createConnection() {
        return new FakeConnection(this.messageResponder);
    }

    private static Collection<? extends JsVariable> getScopeVariables(JsScope scope) {
        return (Collection)scope.accept((JsScope.Visitor)new JsScope.Visitor<Collection<? extends JsVariable>>(){

            public Collection<? extends JsVariable> visitDeclarative(JsScope.Declarative declarativeScope) {
                return declarativeScope.getVariables();
            }

            public Collection<? extends JsVariable> visitObject(JsScope.ObjectBased objectScope) {
                return objectScope.getScopeObject().getProperties();
            }
        });
    }
}

