/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.jsf.ui.converter.jsfhtml;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.jst.pagedesigner.converter.AbstractTagConverter;
import org.eclipse.jst.pagedesigner.converter.ConvertPosition;
import org.eclipse.jst.pagedesigner.converter.JSFConverterUtil;
import org.eclipse.jst.pagedesigner.jsf.core.dom.JSFDOMUtil;
import org.eclipse.jst.pagedesigner.utils.DOMUtil;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class PanelGridTagConverter
extends AbstractTagConverter {
    public PanelGridTagConverter(Element host) {
        super(host);
    }

    protected Element doConvertRefresh() {
        Element trEle;
        Element theadEle;
        Element facet;
        Element panelGridEle = this.getHostElement();
        Element tableEle = this.createElement("table");
        JSFConverterUtil.copyAllAttributes((Element)panelGridEle, (Element)tableEle, null);
        JSFConverterUtil.copyAttribute((Element)panelGridEle, (String)"styleClass", (Element)tableEle, (String)"class");
        tableEle.removeAttribute("styleClass");
        int columns = DOMUtil.getIntAttributeIgnoreCase((Element)panelGridEle, (String)"columns", (int)1);
        if (columns < 1) {
            columns = 1;
        }
        if ((facet = JSFDOMUtil.findFacet(panelGridEle, "header")) != null) {
            theadEle = this.createElement("thead");
            tableEle.appendChild(theadEle);
            trEle = this.createElement("tr");
            theadEle.appendChild(trEle);
            Element thEle = this.createElement("th");
            trEle.appendChild(thEle);
            String headerClass = panelGridEle.getAttribute("headerClass");
            if (headerClass != null && headerClass.length() > 0) {
                thEle.setAttribute("class", headerClass);
            }
            thEle.setAttribute("colspan", String.valueOf(columns));
            this.addChild(facet, new ConvertPosition((Node)thEle, 0));
        }
        if ((facet = JSFDOMUtil.findFacet(panelGridEle, "footer")) != null) {
            theadEle = this.createElement("tfoot");
            tableEle.appendChild(theadEle);
            trEle = this.createElement("tr");
            theadEle.appendChild(trEle);
            Element tdEle = this.createElement("td");
            trEle.appendChild(tdEle);
            String footerClass = panelGridEle.getAttribute("footerClass");
            if (footerClass != null && footerClass.length() > 0) {
                tdEle.setAttribute("class", footerClass);
            }
            tdEle.setAttribute("colspan", String.valueOf(columns));
            this.addChild(facet, new ConvertPosition((Node)tdEle, 0));
        }
        ArrayList<String> rowclasses = new ArrayList<String>();
        String rowclassesattr = panelGridEle.getAttribute("rowClasses");
        if (rowclassesattr != null) {
            StringTokenizer tokenizer = new StringTokenizer(rowclassesattr, ", ");
            while (tokenizer.hasMoreTokens()) {
                rowclasses.add(tokenizer.nextToken());
            }
        }
        ArrayList<String> columnclasses = new ArrayList<String>();
        String columnclassattr = panelGridEle.getAttribute("columnClasses");
        if (columnclassattr != null) {
            StringTokenizer tokenizer = new StringTokenizer(columnclassattr, ", ");
            while (tokenizer.hasMoreTokens()) {
                columnclasses.add(tokenizer.nextToken());
            }
        }
        Element tbody = this.createElement("tbody");
        tableEle.appendChild(tbody);
        List uipanelChildren = JSFDOMUtil.getUIComponentChildren(panelGridEle);
        Element currentTr = null;
        int nextRow = 0;
        int i = 0;
        while (i < uipanelChildren.size()) {
            int columnIndex = i % columns;
            if (columnIndex == 0) {
                currentTr = this.createElement("tr");
                if (!rowclasses.isEmpty()) {
                    currentTr.setAttribute("class", (String)rowclasses.get(nextRow));
                    nextRow = (nextRow + 1) % rowclasses.size();
                }
                tbody.appendChild(currentTr);
            }
            Element uichild = (Element)uipanelChildren.get(i);
            Element td = this.createElement("td");
            if (columnIndex < columnclasses.size()) {
                td.setAttribute("class", (String)columnclasses.get(columnIndex));
            }
            currentTr.appendChild(td);
            this.addChild(uichild, new ConvertPosition((Node)td, 0));
            ++i;
        }
        return tableEle;
    }

    public boolean isMultiLevel() {
        return true;
    }

    public boolean isWidget() {
        return false;
    }

    public boolean needBorderDecorator() {
        return true;
    }

    public boolean needTableDecorator() {
        return true;
    }
}

