/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.facesconfig.tests.write;

import java.util.List;
import org.eclipse.jst.jsf.facesconfig.emf.DynamicElement;
import org.eclipse.jst.jsf.facesconfig.emf.FacesConfigFactory;
import org.eclipse.jst.jsf.facesconfig.emf.FacesConfigPackage;
import org.eclipse.jst.jsf.facesconfig.emf.FactoryExtensionType;
import org.eclipse.jst.jsf.facesconfig.emf.FactoryType;
import org.eclipse.jst.jsf.facesconfig.tests.util.CommonStructuresUtil;
import org.eclipse.jst.jsf.facesconfig.tests.util.FacesConfigModelUtil;
import org.eclipse.jst.jsf.facesconfig.tests.write.WriteFactoryTestCase;
import org.eclipse.jst.jsf.facesconfig.util.FacesConfigArtifactEdit;

public class WriteFactoryTestCase_1_2
extends WriteFactoryTestCase {
    private static final String EXTENDED_FACTORY_ID = "extended-factory-id";
    private static final String FACTORY_EXTENSION = CommonStructuresUtil.createPreficedString("factory", "extension");
    private static final String FACTORY_EXTENSION_ID = CommonStructuresUtil.createPreficedString(FACTORY_EXTENSION, "id");
    private static final String FACTORY_EXTENSION_TAG = CommonStructuresUtil.createPreficedString(FACTORY_EXTENSION, "tag");

    public WriteFactoryTestCase_1_2(String name) {
        super(name);
    }

    public void testFactoryExtension() {
        FacesConfigArtifactEdit edit = null;
        try {
            edit = this.getArtifactEditForWrite();
            WriteFactoryTestCase_1_2.assertNotNull((Object)edit.getFacesConfig());
            FacesConfigPackage facesConfigPackage = FacesConfigPackage.eINSTANCE;
            FacesConfigFactory facesConfigFactory = facesConfigPackage.getFacesConfigFactory();
            FactoryType factory = facesConfigFactory.createFactoryType();
            factory.setId(EXTENDED_FACTORY_ID);
            FactoryExtensionType extensionType = facesConfigFactory.createFactoryExtensionType();
            extensionType.setId(FACTORY_EXTENSION_ID);
            extensionType.getChildNodes().add((Object)this.createDynamicElement(FACTORY_EXTENSION_TAG));
            factory.getFactoryExtension().add((Object)extensionType);
            edit.getFacesConfig().getFactory().add((Object)factory);
            edit.save(null);
        }
        finally {
            if (edit != null) {
                edit.dispose();
                WriteFactoryTestCase_1_2.assertTrue((boolean)edit.isDisposed());
                edit = null;
            }
        }
        try {
            edit = this.getArtifactEditForRead();
            WriteFactoryTestCase_1_2.assertNotNull((Object)edit.getFacesConfig());
            FactoryType factory = (FactoryType)FacesConfigModelUtil.findEObjectElementById((List)edit.getFacesConfig().getFactory(), EXTENDED_FACTORY_ID);
            WriteFactoryTestCase_1_2.assertNotNull((Object)factory);
            WriteFactoryTestCase_1_2.assertEquals((int)1, (int)factory.getFactoryExtension().size());
            FactoryExtensionType extensionType = (FactoryExtensionType)factory.getFactoryExtension().get(0);
            WriteFactoryTestCase_1_2.assertEquals((String)FACTORY_EXTENSION_ID, (String)extensionType.getId());
            WriteFactoryTestCase_1_2.assertEquals((int)1, (int)extensionType.getChildNodes().size());
            DynamicElement element = (DynamicElement)extensionType.getChildNodes().get(0);
            WriteFactoryTestCase_1_2.assertEquals((String)FACTORY_EXTENSION_TAG, (String)element.getName());
        }
        finally {
            if (edit != null) {
                edit.dispose();
            }
        }
    }
}

