/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.json.ui.internal.contentassist;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.json.jsonpath.IJSONPath;
import org.eclipse.json.jsonpath.JSONPath;
import org.eclipse.json.schema.IJSONSchemaDocument;
import org.eclipse.json.schema.IJSONSchemaProperty;
import org.eclipse.json.schema.JSONSchemaType;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wst.json.core.JSONCorePlugin;
import org.eclipse.wst.json.core.document.IJSONNode;
import org.eclipse.wst.json.core.document.IJSONObject;
import org.eclipse.wst.json.core.document.IJSONPair;
import org.eclipse.wst.json.ui.contentassist.AbstractJSONCompletionProposalComputer;
import org.eclipse.wst.json.ui.contentassist.ContentAssistHelper;
import org.eclipse.wst.json.ui.contentassist.ContentAssistRequest;
import org.eclipse.wst.json.ui.contentassist.ICompletionProposalCollector;
import org.eclipse.wst.json.ui.contentassist.JSONKeyCompletionProposal;
import org.eclipse.wst.json.ui.internal.Logger;
import org.eclipse.wst.json.ui.internal.contentassist.CompletionProposalCollectorsRegistryReader;
import org.eclipse.wst.json.ui.internal.editor.JSONEditorPluginImageHelper;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.ui.contentassist.CompletionProposalInvocationContext;

public class JSONCompletionProposalComputer
extends AbstractJSONCompletionProposalComputer {
    public void sessionStarted() {
    }

    @Override
    protected void addObjectKeyProposals(ContentAssistRequest contentAssistRequest, CompletionProposalInvocationContext context) {
        this.collectProposalsFromSchema(contentAssistRequest, context);
        this.collectProposalsFromExtensionPoint(contentAssistRequest, context);
    }

    private void collectProposalsFromExtensionPoint(ContentAssistRequest contentAssistRequest, CompletionProposalInvocationContext context) {
        CompletionProposalCollectorsRegistryReader.getInstance().addProposals(contentAssistRequest, context, ICompletionProposalCollector.TargetType.key);
    }

    private void collectProposalsFromSchema(ContentAssistRequest contentAssistRequest, CompletionProposalInvocationContext context) {
        try {
            IJSONNode node = contentAssistRequest.getNode();
            IJSONSchemaDocument schemaDocument = JSONCorePlugin.getDefault().getSchemaDocument(node);
            if (schemaDocument != null) {
                String matchString = contentAssistRequest.getMatchString();
                if (matchString == null) {
                    matchString = "";
                }
                if (matchString.length() > 0 && matchString.startsWith("\"")) {
                    matchString = matchString.substring(1);
                }
                IJSONPath path = node.getPath();
                if (node instanceof IJSONPair) {
                    IJSONSchemaProperty thisProperty = schemaDocument.getProperty(path);
                    ITextRegion region = contentAssistRequest.getRegion();
                    boolean isValue = this.isPairValue(context, node);
                    if (thisProperty != null && isValue) {
                        if (thisProperty.getFirstType() == JSONSchemaType.Boolean) {
                            if (JSONCompletionProposalComputer.beginsWith("false", matchString.trim())) {
                                this.addStringProposal(contentAssistRequest, "false", false);
                            }
                            if (JSONCompletionProposalComputer.beginsWith("true", matchString.trim())) {
                                this.addStringProposal(contentAssistRequest, "true", false);
                            }
                            return;
                        }
                        if (thisProperty.getFirstType() == JSONSchemaType.String) {
                            boolean showProperty;
                            if (thisProperty.getEnumList() != null && thisProperty.getEnumList().size() > 0) {
                                for (String prop : thisProperty.getEnumList()) {
                                    boolean showProperty2 = JSONCompletionProposalComputer.beginsWith(prop, matchString.trim());
                                    if (!showProperty2) continue;
                                    this.addStringProposal(contentAssistRequest, prop, region.getType() != "JSON_VALUE_STRING");
                                }
                            } else if (thisProperty.getDefaultValue() != null && (showProperty = JSONCompletionProposalComputer.beginsWith(thisProperty.getDefaultValue(), matchString.trim()))) {
                                this.addStringProposal(contentAssistRequest, thisProperty.getDefaultValue(), region.getType() != "JSON_VALUE_STRING");
                            }
                            return;
                        }
                    }
                }
                if (!(node instanceof IJSONObject && node.getOwnerPairNode() != null || path.getSegments().length <= 0)) {
                    String[] segments = new String[path.getSegments().length - 1];
                    System.arraycopy(path.getSegments(), 0, segments, 0, path.getSegments().length - 1);
                    path = new JSONPath(segments);
                }
                IJSONSchemaProperty parentProperty = schemaDocument.getProperty(path);
                HashSet<String> existing = new HashSet<String>();
                boolean addComma = false;
                if (node instanceof IJSONObject) {
                    this.addExisting(existing, node);
                    addComma = this.addComma(context, node);
                } else if (node instanceof IJSONPair && node.getParentNode() instanceof IJSONObject) {
                    this.addExisting(existing, node.getParentNode());
                }
                if (parentProperty != null) {
                    IJSONSchemaProperty[] iJSONSchemaPropertyArray = parentProperty.getPropertyValues();
                    int n = iJSONSchemaPropertyArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        boolean showProperty;
                        IJSONSchemaProperty property = iJSONSchemaPropertyArray[n2];
                        boolean bl = showProperty = !existing.contains(property.getName()) && JSONCompletionProposalComputer.beginsWith(property.getName(), matchString.trim());
                        if (showProperty) {
                            String replacementString;
                            if (node instanceof IJSONPair) {
                                replacementString = property.getName();
                            } else {
                                replacementString = ContentAssistHelper.getRequiredName(node, property);
                                if (addComma) {
                                    replacementString = String.valueOf(replacementString) + ",";
                                }
                            }
                            String additionalProposalInfo = property.getDescription();
                            Image icon = JSONEditorPluginImageHelper.getInstance().getImage(property.getFirstType());
                            String displayString = property.getName();
                            JSONKeyCompletionProposal proposal = new JSONKeyCompletionProposal(replacementString, contentAssistRequest.getReplacementBeginPosition(), contentAssistRequest.getReplacementLength(), replacementString.length() - 2, icon, displayString, null, additionalProposalInfo, 400);
                            contentAssistRequest.addProposal((ICompletionProposal)proposal);
                        }
                        ++n2;
                    }
                }
            }
        }
        catch (IOException e) {
            Logger.logException(e);
        }
    }

    private boolean addComma(CompletionProposalInvocationContext context, IJSONNode node) {
        IJSONNode child = node.getFirstChild();
        int documentPosition = context.getInvocationOffset();
        while (child != null) {
            if (documentPosition <= child.getStartOffset()) break;
            child = child.getNextSibling();
        }
        return child != null;
    }

    private void addExisting(Set<String> existing, IJSONNode node) {
        IJSONNode child = node.getFirstChild();
        while (child != null) {
            String name;
            if (child instanceof IJSONPair && (name = ((IJSONPair)child).getName()) != null && !name.isEmpty()) {
                existing.add(name);
            }
            child = child.getNextSibling();
        }
    }

    private void addStringProposal(ContentAssistRequest contentAssistRequest, String replacementString, boolean addQuote) {
        String matchString;
        String additionalProposalInfo = null;
        Image icon = null;
        String displayString = replacementString;
        if (addQuote) {
            replacementString = "\"" + replacementString + "\"";
        }
        if ((matchString = contentAssistRequest.getMatchString()) != null) {
            matchString = matchString.replaceAll("\"", "");
        }
        JSONKeyCompletionProposal proposal = new JSONKeyCompletionProposal(replacementString, contentAssistRequest.getReplacementBeginPosition(), contentAssistRequest.getReplacementLength(), replacementString.length() - 2, icon, displayString, null, additionalProposalInfo, 400);
        contentAssistRequest.addProposal((ICompletionProposal)proposal);
    }

    public String getErrorMessage() {
        return null;
    }

    public void sessionEnded() {
    }
}

