/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.core.tagmatcher;

import org.eclipse.jst.jsf.common.sets.AxiomaticSet;
import org.eclipse.jst.jsf.core.tagmatcher.InvalidExpressionException;
import org.w3c.dom.Node;

public abstract class TagMatchingAlgorithm {
    private boolean _isInvalid;
    private boolean _isInitialized;
    protected final String _expression;

    protected TagMatchingAlgorithm(String expression) {
        this._expression = expression;
    }

    public final void initialize() {
        if (this._isInvalid) {
            throw new IllegalStateException("Expression: " + this._expression + " has already been determined to be invalid");
        }
        if (!this._isInitialized) {
            try {
                this.doInitialize();
            }
            catch (Exception e) {
                this._isInvalid = true;
                throw new InvalidExpressionException(e);
            }
            this._isInitialized = true;
        }
    }

    public final AxiomaticSet evaluate(Node applyTo) {
        this.initialize();
        return this.doEvaluate(applyTo);
    }

    protected abstract AxiomaticSet doEvaluate(Node var1);

    protected abstract void doInitialize() throws Exception;
}

