/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.jaxws.core.annotations.validation;

import com.sun.mirror.declaration.AnnotationMirror;
import com.sun.mirror.declaration.AnnotationTypeDeclaration;
import com.sun.mirror.declaration.ClassDeclaration;
import com.sun.mirror.declaration.Declaration;
import java.util.Collection;
import java.util.Set;
import javax.jws.WebService;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.apt.core.env.EclipseAnnotationProcessorEnvironment;
import org.eclipse.jst.ws.annotations.core.processor.AbstractAnnotationProcessor;
import org.eclipse.jst.ws.annotations.core.utils.AnnotationUtils;
import org.eclipse.jst.ws.internal.jaxws.core.JAXWSCoreMessages;
import org.eclipse.jst.ws.internal.jaxws.core.JAXWSCorePlugin;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;

public class WebServiceEJBModuleRule
extends AbstractAnnotationProcessor {
    private static final String STATELESS = "javax.ejb.Stateless";
    private static final String SINGLETON = "javax.ejb.Singleton";
    private static final String EJB_FACET = "jst.ejb";
    private static final String EJB_FACET_VERSION = "3.0";

    public void process() {
        if (this.environment instanceof EclipseAnnotationProcessorEnvironment) {
            EclipseAnnotationProcessorEnvironment eclipseEnvironment = (EclipseAnnotationProcessorEnvironment)this.environment;
            IProject project = eclipseEnvironment.getJavaProject().getProject();
            try {
                IProjectFacetVersion facetVersion;
                IFacetedProject facetedProject;
                if (this.isFacetedProject(project) && (facetedProject = ProjectFacetsManager.create((IProject)project)).hasProjectFacet(ProjectFacetsManager.getProjectFacet((String)EJB_FACET)) && (facetVersion = facetedProject.getProjectFacetVersion(ProjectFacetsManager.getProjectFacet((String)EJB_FACET))).getVersionString().equals(EJB_FACET_VERSION)) {
                    AnnotationTypeDeclaration webServiceDeclaration = (AnnotationTypeDeclaration)eclipseEnvironment.getTypeDeclaration(WebService.class.getName());
                    Collection annotatedTypes = eclipseEnvironment.getDeclarationsAnnotatedWith(webServiceDeclaration);
                    for (Declaration declaration : annotatedTypes) {
                        if (!(declaration instanceof ClassDeclaration) || this.getStatelessOrSingletonAnnotation(declaration) != null) continue;
                        AnnotationMirror webService = AnnotationUtils.getAnnotation((Declaration)declaration, WebService.class);
                        this.printError(webService.getPosition(), JAXWSCoreMessages.WEBSERVICE_ONLY_ON_STATELESS_OR_SINGLETON_SESSION_BEANS);
                    }
                }
            }
            catch (CoreException ce) {
                JAXWSCorePlugin.log(ce.getStatus());
            }
        }
    }

    private AnnotationMirror getStatelessOrSingletonAnnotation(Declaration declaration) {
        Collection aannotationMirrors = declaration.getAnnotationMirrors();
        for (AnnotationMirror annotationMirror : aannotationMirrors) {
            AnnotationTypeDeclaration annotationTypeDeclaration = annotationMirror.getAnnotationType().getDeclaration();
            if (annotationTypeDeclaration == null || !annotationTypeDeclaration.getQualifiedName().equals(STATELESS) && !annotationTypeDeclaration.getQualifiedName().equals(SINGLETON)) continue;
            return annotationMirror;
        }
        return null;
    }

    private boolean isFacetedProject(IProject project) throws CoreException {
        Set facetedProjects = ProjectFacetsManager.getFacetedProjects();
        for (IFacetedProject facetedProject : facetedProjects) {
            if (!facetedProject.getProject().equals((Object)project)) continue;
            return true;
        }
        return false;
    }
}

