/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsl.jaxp.debug.invoker.test;

import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.eclipse.wst.xsl.jaxp.debug.invoker.TransformDefinition;
import org.eclipse.wst.xsl.jaxp.debug.invoker.TypedValue;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TransformDefinitonTest {
    TransformDefinition tdef = null;

    @Before
    public void setUp() throws Exception {
        this.tdef = new TransformDefinition();
    }

    @After
    public void tearDown() throws Exception {
        this.tdef = null;
    }

    private TypedValue setupParameters() {
        TypedValue param = new TypedValue("param", "string", "test");
        this.tdef.addParameter(param);
        return param;
    }

    @Test
    public void testDefaultResolver() throws Exception {
        String resolver = this.tdef.getResolverClass();
        Assert.assertEquals((String)"Did not find default resolver", (Object)"org.apache.xml.resolver.tools.CatalogResolver", (Object)resolver);
    }

    @Test
    public void testChangeResolverFromDefault() throws Exception {
        String resolver = "org.eclipse.wst.xml.catalog.URIResolver";
        this.tdef.setResolverClass(resolver);
        Assert.assertEquals((String)"Problem setting a new resolver", (Object)resolver, (Object)this.tdef.getResolverClass());
    }

    @Test
    public void testAddParameters() throws Exception {
        this.setupParameters();
        Assert.assertNotNull((String)"Missing paramerters", (Object)this.tdef.getParameters());
    }

    @Test
    public void testGetParameters() throws Exception {
        this.setupParameters();
        Set parmSet = this.tdef.getParameters();
        Assert.assertEquals((String)"Incorrect size returned.", (long)1L, (long)parmSet.size());
    }

    @Test
    public void testGetParametersAsMap() throws Exception {
        this.setupParameters();
        Map parmMap = this.tdef.getParametersAsMap();
        Assert.assertNotNull((String)"Missing parmater MAP.", (Object)parmMap);
    }

    @Test
    public void testStyleSheetSource() throws Exception {
        String stylesheet = "http://www.example.org/stylesheet.xsl";
        this.tdef.setStylesheetURL(stylesheet);
        Assert.assertNotNull((String)"Missing stylesheet.", (Object)this.tdef.getStylesheetURL());
        Assert.assertEquals((String)"Incorrect stylesheet.", (Object)stylesheet, (Object)this.tdef.getStylesheetURL());
    }

    @Test
    public void testRemoveParameter() throws Exception {
        TypedValue param = this.setupParameters();
        Assert.assertTrue((this.tdef.getParameters().size() > 0 ? 1 : 0) != 0);
        this.tdef.removeParameter(param);
        Assert.assertTrue((String)"Found parameters when there should be zero.", (this.tdef.getParameters().size() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testSetOutputProperty() throws Exception {
        this.tdef.setOutputProperty("output", "test");
        String value = this.tdef.getOutputProperties().getProperty("output");
        Assert.assertEquals((String)"Incorrect value", (Object)"test", (Object)value);
    }

    @Test
    public void testNoOutputProperties() throws Exception {
        Assert.assertEquals((String)"Found output properties when there should be none.", (long)0L, (long)this.tdef.getOutputProperties().size());
    }

    @Test
    public void testRemoveOutputProperty() throws Exception {
        this.tdef.setOutputProperty("output", "test");
        Properties properties = this.tdef.getOutputProperties();
        Assert.assertEquals((long)1L, (long)properties.size());
        this.tdef.removeOutputProperty("output");
    }
}

