/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.chromium.internal.v8native.value;

import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.wst.jsdt.chromium.JsValue;
import org.eclipse.wst.jsdt.chromium.internal.v8native.value.FakeValueLoader;
import org.eclipse.wst.jsdt.chromium.internal.v8native.value.JsObjectBase;
import org.eclipse.wst.jsdt.chromium.internal.v8native.value.LoadableString;
import org.eclipse.wst.jsdt.chromium.internal.v8native.value.ValueLoader;
import org.junit.Assert;
import org.junit.Test;

public class ValueLoaderTest {
    @Test
    public void dropCaches() {
        String sizeWithDroppedCaches = this.rereadSizeProperty(true);
        Assert.assertEquals((Object)"40", (Object)sizeWithDroppedCaches);
        String sizeWithoutDroppedCaches = this.rereadSizeProperty(false);
        Assert.assertEquals((Object)"20", (Object)sizeWithoutDroppedCaches);
    }

    private String rereadSizeProperty(boolean dropCaches) {
        FakeValueLoader valueLoader = new FakeValueLoader();
        StructObjectData addressData = new StructObjectData(1L, JsValue.Type.TYPE_OBJECT, "Address", null);
        addressData.properties.put("name", new StructValueData(2L, JsValue.Type.TYPE_STRING, null, (LoadableString)new LoadableString.Immutable("Leningrad")));
        addressData.properties.put("size", new StructValueData(3L, JsValue.Type.TYPE_NUMBER, null, (LoadableString)new LoadableString.Immutable("20")));
        valueLoader.addValueDataRecursive(addressData);
        JsObjectBase.Impl object = new JsObjectBase.Impl((ValueLoader)valueLoader, FakeValueLoader.createMirrorFromData(addressData, false));
        String sizeBefore = object.getProperty("size").getValue().getValueString();
        Assert.assertEquals((Object)"20", (Object)sizeBefore);
        if (dropCaches) {
            object.getRemoteValueMapping().clearCaches();
        }
        StructValueData newSizeValue = new StructValueData(4L, JsValue.Type.TYPE_NUMBER, null, (LoadableString)new LoadableString.Immutable("40"));
        addressData.properties.put("size", newSizeValue);
        valueLoader.addValueDataRecursive(newSizeValue);
        String sizeAfter = object.getProperty("size").getValue().getValueString();
        return sizeAfter;
    }

    private static class StructObjectData
    extends StructValueData
    implements FakeValueLoader.ObjectData {
        final LinkedHashMap<String, StructValueData> properties = new LinkedHashMap();

        StructObjectData() {
        }

        StructObjectData(Long ref, JsValue.Type type, String className, LoadableString string) {
            super(ref, type, className, string);
        }

        public Map<String, StructValueData> getProperties() {
            return this.properties;
        }

        @Override
        public StructObjectData asObjectData() {
            return this;
        }
    }

    private static class StructValueData
    implements FakeValueLoader.ValueData {
        Long ref;
        JsValue.Type type;
        String className;
        LoadableString string;

        StructValueData() {
        }

        StructValueData(Long ref, JsValue.Type type, String className, LoadableString string) {
            this.ref = ref;
            this.type = type;
            this.className = className;
            this.string = string;
        }

        @Override
        public Long getRef() {
            return this.ref;
        }

        @Override
        public JsValue.Type getType() {
            return this.type;
        }

        @Override
        public String getClassName() {
            return this.className;
        }

        @Override
        public LoadableString getString() {
            return this.string;
        }

        @Override
        public FakeValueLoader.ObjectData asObjectData() {
            return null;
        }
    }
}

