/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.jaxws.dom.runtime.tests.dom.persistence.serializer;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jst.ws.jaxws.dom.runtime.api.DomFactory;
import org.eclipse.jst.ws.jaxws.dom.runtime.api.IServiceEndpointInterface;
import org.eclipse.jst.ws.jaxws.dom.runtime.api.IWebService;
import org.eclipse.jst.ws.jaxws.dom.runtime.persistence.IAnnotationSerializer;
import org.eclipse.jst.ws.jaxws.dom.runtime.persistence.JaxWsWorkspaceResource;
import org.eclipse.jst.ws.jaxws.dom.runtime.persistence.serializer.SerializerAdapterFactory;
import org.eclipse.jst.ws.jaxws.testutils.jmock.Mock;
import org.eclipse.jst.ws.jaxws.testutils.jmock.MockObjectTestCase;

public class SerializerAdapterFactoryTest
extends MockObjectTestCase {
    private JaxWsWorkspaceResource resource;
    private SerializerAdapterFactory factory;

    public void setUp() {
        Mock javaModelMock = this.mock(IJavaModel.class);
        this.resource = new JaxWsWorkspaceResource((IJavaModel)javaModelMock.proxy());
        this.factory = this.resource.getSerializerFactory();
    }

    public void testIsFactoryForType() {
        SerializerAdapterFactoryTest.assertTrue((boolean)this.factory.isFactoryForType(IAnnotationSerializer.class));
        SerializerAdapterFactoryTest.assertFalse((boolean)this.factory.isFactoryForType(Notification.class));
    }

    public void testAdaptWebService() {
        IWebService webService = DomFactory.eINSTANCE.createIWebService();
        Adapter adapter1 = this.factory.adapt((Notifier)webService, IAnnotationSerializer.class);
        SerializerAdapterFactoryTest.assertEquals((int)1, (int)webService.eAdapters().size());
        Adapter adapter2 = this.factory.adapt((Notifier)webService, IAnnotationSerializer.class);
        SerializerAdapterFactoryTest.assertEquals((int)1, (int)webService.eAdapters().size());
        SerializerAdapterFactoryTest.assertTrue((adapter1 == adapter2 ? 1 : 0) != 0);
    }

    public void testAdaptSei() {
        IServiceEndpointInterface sei = DomFactory.eINSTANCE.createIServiceEndpointInterface();
        Adapter adapter1 = this.factory.adapt((Notifier)sei, IAnnotationSerializer.class);
        SerializerAdapterFactoryTest.assertEquals((int)1, (int)sei.eAdapters().size());
        Adapter adapter2 = this.factory.adapt((Notifier)sei, IAnnotationSerializer.class);
        SerializerAdapterFactoryTest.assertEquals((int)1, (int)sei.eAdapters().size());
        SerializerAdapterFactoryTest.assertTrue((adapter1 == adapter2 ? 1 : 0) != 0);
    }
}

