/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.refactor.rename;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.RenameParticipant;
import org.eclipse.wst.xsd.ui.internal.refactor.RefactoringMessages;
import org.eclipse.wst.xsd.ui.internal.refactor.TextChangeManager;
import org.eclipse.xsd.XSDNamedComponent;
import org.eclipse.xsd.XSDSchema;

public class ResourceRenameParticipant
extends RenameParticipant {
    private TextChangeManager changeManager;
    private static String XSD_CONTENT_TYPE_ID = "org.eclipse.wst.xsd.core.xsdsource";
    private static String WSDL_CONTENT_TYPE_ID = "org.eclipse.wst.wsdl.wsdlsource";

    protected boolean initialize(Object element) {
        if (element instanceof IFile) {
            IContentDescription description;
            block5: {
                IFile aFile = (IFile)element;
                try {
                    description = aFile.getContentDescription();
                    if (description != null) break block5;
                    return false;
                }
                catch (CoreException coreException) {
                    return false;
                }
            }
            IContentType contentType = description.getContentType();
            if (contentType != null && (XSD_CONTENT_TYPE_ID.equals(contentType.getId()) || WSDL_CONTENT_TYPE_ID.equals(contentType.getId()))) {
                return true;
            }
        }
        return false;
    }

    public String getName() {
        return RefactoringMessages.getString("ResourceRenameParticipant.compositeChangeName");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public RefactoringStatus checkConditions(IProgressMonitor pm, CheckConditionsContext context) throws OperationCanceledException {
        RefactoringStatus result = new RefactoringStatus();
        try {
            try {
                pm.beginTask("", 9);
                this.changeManager = this.createChangeManager((IProgressMonitor)new SubProgressMonitor(pm, 1), result);
            }
            catch (CoreException e) {
                result.addFatalError(e.toString());
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            pm.done();
            throw throwable;
        }
        {
            Object var5_7 = null;
        }
        pm.done();
        return result;
    }

    public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        block3: {
            CompositeChange compositeChange;
            try {
                String changeName = RefactoringMessages.getString("RenameResourceChange.rename_resource_reference_change");
                TextChange[] changes = this.changeManager.getAllChanges();
                if (changes.length <= 0) break block3;
                compositeChange = new CompositeChange(changeName, (Change[])changes);
                Object var4_5 = null;
            }
            catch (Throwable throwable) {
                Object var4_7 = null;
                pm.done();
                throw throwable;
            }
            pm.done();
            return compositeChange;
        }
        Object var4_6 = null;
        pm.done();
        return null;
    }

    private TextChangeManager createChangeManager(IProgressMonitor pm, RefactoringStatus status) throws CoreException {
        TextChangeManager manager = new TextChangeManager(false);
        if (this.getArguments().getUpdateReferences()) {
            this.addOccurrences(manager, pm, status);
        }
        return manager;
    }

    void addOccurrences(TextChangeManager manager, IProgressMonitor pm, RefactoringStatus status) throws CoreException {
    }

    public class ReferenceLocationFinder {
        protected XSDNamedComponent component;
        protected String name;
        protected XSDSchema referencingSchema;
        protected List results = new ArrayList();

        public ReferenceLocationFinder(XSDNamedComponent component, String name, XSDSchema referencingSchema) {
            this.component = component;
            this.name = name;
            this.referencingSchema = referencingSchema;
        }

        public void run() {
        }

        public final List getResults() {
            return this.results;
        }
    }
}

