/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.jaxws.utils;

import org.eclipse.jdt.core.IType;
import org.eclipse.jst.ws.jaxws.utils.ContractChecker;

public class JaxWsUtils {
    private static final String BEAN_SUFFIX = "Bean";
    private static final String PORT_SUFFIX = "Port";
    private static final String SERVICE_SUFFIX = "Service";

    private JaxWsUtils() {
    }

    public static String composeJaxWsTargetNamespaceByPackage(String packageName) {
        if (packageName == null) {
            throw new NullPointerException("Package name cannot be null");
        }
        String[] pkgFragments = packageName.split("\\.");
        if (pkgFragments.length > 1) {
            String frag0 = pkgFragments[0];
            pkgFragments[0] = pkgFragments[1];
            pkgFragments[1] = frag0;
        }
        StringBuilder result = new StringBuilder("http://");
        int i = 0;
        while (i < pkgFragments.length) {
            result.append(pkgFragments[i]);
            result.append(i == 0 && pkgFragments.length > 1 ? "." : "/");
            ++i;
        }
        return result.toString();
    }

    public static String composeJaxWsTargetNamespaceByFQName(String fqName) {
        ContractChecker.nullCheckParam(fqName, "fqName");
        return JaxWsUtils.composeJaxWsTargetNamespaceByPackage(JaxWsUtils.extractPackage(fqName));
    }

    public static String getPorttypeName(IType endpointType, String seiName) {
        if (endpointType == null) {
            throw new NullPointerException("endpointType could not be null!");
        }
        if (seiName != null && seiName.length() > 0) {
            return seiName;
        }
        return JaxWsUtils.removeBeanSuffixIfRequired(endpointType.getElementName());
    }

    public static String getServiceName(IType endpointType) {
        if (endpointType == null) {
            throw new NullPointerException("endpointType could not be null!");
        }
        return String.valueOf(JaxWsUtils.removeBeanSuffixIfRequired(endpointType.getElementName())) + SERVICE_SUFFIX;
    }

    private static String removeBeanSuffixIfRequired(String endpointName) {
        assert (endpointName != null && endpointName.length() > 0);
        if (endpointName.equals(BEAN_SUFFIX)) {
            return endpointName;
        }
        if (endpointName.endsWith(BEAN_SUFFIX)) {
            return endpointName.substring(0, endpointName.lastIndexOf(BEAN_SUFFIX));
        }
        return endpointName;
    }

    public static String getPortName(IType endpointType) {
        return JaxWsUtils.getDefaultPortName(endpointType.getElementName());
    }

    public static String getDefaultServiceName(String fqName) {
        if (fqName == null) {
            throw new NullPointerException("endpointType could not be null!");
        }
        return String.valueOf(JaxWsUtils.extractShortName(fqName)) + SERVICE_SUFFIX;
    }

    public static String getDefaultPorttypeName(String fqName) {
        if (fqName == null) {
            throw new NullPointerException("fqName could not be null!");
        }
        return JaxWsUtils.extractShortName(fqName);
    }

    public static String getDefaultPortName(String fqName) {
        if (fqName == null) {
            throw new NullPointerException("fqName could not be null!");
        }
        return String.valueOf(JaxWsUtils.extractShortName(fqName)) + PORT_SUFFIX;
    }

    private static String extractShortName(String fqName) {
        int pos = fqName.lastIndexOf(46);
        if (pos == -1) {
            return fqName;
        }
        return fqName.substring(pos + 1);
    }

    private static String extractPackage(String fqName) {
        int pos = fqName.lastIndexOf(46);
        if (pos == -1) {
            return fqName;
        }
        return fqName.substring(0, pos);
    }
}

