/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.validation.caret;

import org.eclipse.gef.EditPart;
import org.eclipse.jst.pagedesigner.dom.EditModelQuery;
import org.eclipse.jst.pagedesigner.validation.caret.ActionData;
import org.eclipse.jst.pagedesigner.validation.caret.DefaultPositionRule;
import org.eclipse.jst.pagedesigner.validation.caret.IMovementRule;
import org.eclipse.jst.pagedesigner.validation.caret.Target;
import org.eclipse.jst.pagedesigner.viewer.DesignPosition;
import org.eclipse.jst.pagedesigner.viewer.DesignRefPosition;
import org.eclipse.jst.pagedesigner.viewer.EditPartPositionHelper;
import org.w3c.dom.Text;

public class WhitespacePositionMoveRule
extends DefaultPositionRule
implements IMovementRule {
    public WhitespacePositionMoveRule(ActionData actionData) {
        super(actionData);
    }

    public boolean allowsMoveIn(Target target) {
        return !EditModelQuery.isTransparentText(target.getNode());
    }

    public boolean allowsMoveOut(Target target) {
        return true;
    }

    public boolean canReference(Target target, boolean atRight) {
        boolean result = super.canReference(target, atRight);
        if (EditModelQuery.isText(target.getNode())) {
            if (((Text)target.getNode()).getData().length() == 0) {
                result = false;
            } else if (EditModelQuery.isTransparentText(target.getNode())) {
                DesignRefPosition position = new DesignRefPosition(target.getPart(), atRight);
                if (EditPartPositionHelper.getConcretePart(position, atRight) != null) {
                    result = true;
                } else {
                    EditPart part = EditPartPositionHelper.getNextConcretPart((DesignPosition)position, atRight);
                    EditPart oppPart = EditPartPositionHelper.getNextConcretPart((DesignPosition)position, !atRight);
                    if (part == null && oppPart == null) {
                        result = true;
                    }
                    result = false;
                }
            }
        }
        return result;
    }

    public boolean hasEditableArea(Target target) {
        if (EditModelQuery.isTransparentText(target.getNode())) {
            return false;
        }
        return super.hasEditableArea(target);
    }

    public boolean isEditable(Target target) {
        if (EditModelQuery.isTransparentText(target.getNode())) {
            return false;
        }
        return super.isEditable(target);
    }
}

