/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.chromium.debug.core.sourcemap;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Random;
import junit.framework.Assert;
import org.eclipse.wst.jsdt.chromium.debug.core.model.StringMappingData;
import org.eclipse.wst.jsdt.chromium.debug.core.model.VmResourceId;
import org.eclipse.wst.jsdt.chromium.debug.core.sourcemap.PositionMapBuilderImpl;
import org.eclipse.wst.jsdt.chromium.debug.core.sourcemap.SourcePosition;
import org.eclipse.wst.jsdt.chromium.debug.core.sourcemap.SourcePositionMap;
import org.eclipse.wst.jsdt.chromium.debug.core.sourcemap.SourcePositionMapBuilder;
import org.eclipse.wst.jsdt.chromium.debug.core.sourcemap.TextSectionMapping;
import org.eclipse.wst.jsdt.chromium.debug.core.sourcemap.TextSectionMappingImpl;
import org.junit.Test;

public class PositionMapBuilderImplTest {
    @Test
    public void basicTest() throws SourcePositionMapBuilder.CannotAddException {
        PositionMapBuilderImpl builder = new PositionMapBuilderImpl();
        int[] nArray = new int[10];
        nArray[2] = 1;
        nArray[4] = 2;
        nArray[6] = 3;
        nArray[8] = 4;
        int[] nArray2 = new int[10];
        nArray2[3] = 10;
        nArray2[5] = 20;
        nArray2[7] = 30;
        nArray2[9] = 40;
        builder.addMapping(new SourcePositionMapBuilder.ResourceSection(new VmResourceId("source1.js", null), 0, 0, 5, 0), new SourcePositionMapBuilder.ResourceSection(new VmResourceId("compiled.js", null), 0, 0, 1, 0), (TextSectionMapping)new TextSectionMappingImpl(new StringMappingData(nArray, 5, 0), new StringMappingData(nArray2, 0, 50)));
        int[] nArray3 = new int[10];
        nArray3[2] = 1;
        nArray3[4] = 2;
        nArray3[6] = 3;
        nArray3[8] = 4;
        int[] nArray4 = new int[10];
        nArray4[0] = 1;
        nArray4[2] = 1;
        nArray4[3] = 10;
        nArray4[4] = 1;
        nArray4[5] = 20;
        nArray4[6] = 1;
        nArray4[7] = 30;
        nArray4[8] = 1;
        nArray4[9] = 40;
        builder.addMapping(new SourcePositionMapBuilder.ResourceSection(new VmResourceId("source2.js", null), 0, 0, 5, 0), new SourcePositionMapBuilder.ResourceSection(new VmResourceId("compiled.js", null), 1, 0, 2, 0), (TextSectionMapping)new TextSectionMappingImpl(new StringMappingData(nArray3, 5, 0), new StringMappingData(nArray4, 1, 50)));
        int[] nArray5 = new int[10];
        nArray5[2] = 1;
        nArray5[4] = 2;
        nArray5[6] = 3;
        nArray5[8] = 4;
        int[] nArray6 = new int[10];
        nArray6[0] = 2;
        nArray6[2] = 2;
        nArray6[3] = 10;
        nArray6[4] = 2;
        nArray6[5] = 20;
        nArray6[6] = 2;
        nArray6[7] = 30;
        nArray6[8] = 2;
        nArray6[9] = 40;
        builder.addMapping(new SourcePositionMapBuilder.ResourceSection(new VmResourceId("source3.js", null), 0, 0, 5, 0), new SourcePositionMapBuilder.ResourceSection(new VmResourceId("compiled.js", null), 2, 0, 3, 0), (TextSectionMapping)new TextSectionMappingImpl(new StringMappingData(nArray5, 5, 0), new StringMappingData(nArray6, 2, 50)));
        SourcePositionMap map = builder.getSourcePositionMap();
        PositionMapBuilderImplTest.checkTwoWay(map, "other.js", 17, 4, "other.js", 17, 4, SourcePositionMap.TranslateDirection.VM_TO_USER);
        PositionMapBuilderImplTest.checkTwoWay(map, "compiled.js", 2, 11, "source3.js", 1, 1, SourcePositionMap.TranslateDirection.VM_TO_USER);
        PositionMapBuilderImplTest.checkTwoWay(map, "compiled.js", 0, 0, "source1.js", 0, 0, SourcePositionMap.TranslateDirection.VM_TO_USER);
        PositionMapBuilderImplTest.checkTwoWay(map, "compiled.js", 0, 1, "source1.js", 0, 1, SourcePositionMap.TranslateDirection.VM_TO_USER);
        PositionMapBuilderImplTest.checkTwoWay(map, "compiled.js", 1, 0, "source2.js", 0, 0, SourcePositionMap.TranslateDirection.VM_TO_USER);
        PositionMapBuilderImplTest.checkTwoWay(map, "compiled.js", 1, 3, "source2.js", 0, 3, SourcePositionMap.TranslateDirection.VM_TO_USER);
        PositionMapBuilderImplTest.checkTwoWay(map, "compiled.js", 2, 0, "source3.js", 0, 0, SourcePositionMap.TranslateDirection.VM_TO_USER);
        PositionMapBuilderImplTest.checkTwoWay(map, "compiled.js", 2, 3, "source3.js", 0, 3, SourcePositionMap.TranslateDirection.VM_TO_USER);
        PositionMapBuilderImplTest.checkTwoWay(map, "compiled.js", 3, 0, "compiled.js", 3, 0, SourcePositionMap.TranslateDirection.VM_TO_USER);
        PositionMapBuilderImplTest.checkTwoWay(map, "compiled.js", 3, 3, "compiled.js", 3, 3, SourcePositionMap.TranslateDirection.VM_TO_USER);
    }

    private static SourcePosition checkOneWay(SourcePositionMap map, String fromFile, int fromLine, int fromColumn, String toFile, int toLine, int toColumn, SourcePositionMap.TranslateDirection direction) {
        SourcePosition result = map.translatePosition(new VmResourceId(fromFile, null), fromLine, fromColumn, direction);
        Assert.assertEquals((Object)new SourcePosition(new VmResourceId(toFile, null), toLine, toColumn), (Object)result);
        return result;
    }

    private static void checkTwoWay(SourcePositionMap map, String fromFile, int fromLine, int fromColumn, String toFile, int toLine, int toColumn, SourcePositionMap.TranslateDirection direction) {
        PositionMapBuilderImplTest.checkOneWay(map, fromFile, fromLine, fromColumn, toFile, toLine, toColumn, direction);
        SourcePosition result = map.translatePosition(new VmResourceId(toFile, null), toLine, toColumn, direction.opposite());
        Assert.assertEquals((Object)new SourcePosition(new VmResourceId(fromFile, null), fromLine, fromColumn), (Object)result);
    }

    @Test
    public void testAddMappingOverlaps() throws SourcePositionMapBuilder.CannotAddException {
        new OverlappingMapTestFramework().run();
    }

    @Test
    public void testAddAndDeleteMapping() throws SourcePositionMapBuilder.CannotAddException {
        new AddAndDeleteMapTestFramework().run();
    }

    private static void assertThrowsAddException(RunnableWithCannotAddException runnable) {
        try {
            runnable.run();
            Assert.fail((String)"Exception expected");
        }
        catch (SourcePositionMapBuilder.CannotAddException cannotAddException) {}
    }

    private static class AddAndDeleteMapTestFramework
    extends MultiRangeMapTestFrameworkBase {
        private AddAndDeleteMapTestFramework() {
        }

        @Override
        protected void runOneShuffle(Random random) throws SourcePositionMapBuilder.CannotAddException {
            PositionMapBuilderImpl builder = new PositionMapBuilderImpl();
            ArrayList<SourcePositionMapBuilder.MappingHandle> goodRangeHandles = this.addGoodRanges((SourcePositionMapBuilder)builder, random);
            Collections.shuffle(goodRangeHandles, random);
            for (SourcePositionMapBuilder.MappingHandle handle : goodRangeHandles) {
                handle.delete();
            }
        }
    }

    private static abstract class MultiRangeMapTestFrameworkBase {
        static final VmResourceId COMPILED_JS_ID = new VmResourceId("compiled.js", null);
        static SourcePositionMapBuilder.ResourceSection[] GOOD_SECTIONS = new SourcePositionMapBuilder.ResourceSection[]{new SourcePositionMapBuilder.ResourceSection(COMPILED_JS_ID, 1, 0, 2, 0), new SourcePositionMapBuilder.ResourceSection(COMPILED_JS_ID, 3, 0, 3, 0), new SourcePositionMapBuilder.ResourceSection(COMPILED_JS_ID, 5, 0, 5, 0), new SourcePositionMapBuilder.ResourceSection(COMPILED_JS_ID, 5, 0, 5, 0), new SourcePositionMapBuilder.ResourceSection(COMPILED_JS_ID, 5, 0, 8, 0), new SourcePositionMapBuilder.ResourceSection(COMPILED_JS_ID, 8, 0, 8, 0)};
        private static final int SHUFFLE_TRIES = 10;

        private MultiRangeMapTestFrameworkBase() {
        }

        void run() throws SourcePositionMapBuilder.CannotAddException {
            Random random = new Random(0L);
            int i = 0;
            while (i < 10) {
                this.runOneShuffle(random);
                ++i;
            }
        }

        protected abstract void runOneShuffle(Random var1) throws SourcePositionMapBuilder.CannotAddException;

        protected ArrayList<SourcePositionMapBuilder.MappingHandle> addGoodRanges(SourcePositionMapBuilder builder, Random random) throws SourcePositionMapBuilder.CannotAddException {
            ArrayList<SourcePositionMapBuilder.ResourceSection> vmSections = new ArrayList<SourcePositionMapBuilder.ResourceSection>(Arrays.asList(GOOD_SECTIONS));
            Collections.shuffle(vmSections, random);
            ArrayList<SourcePositionMapBuilder.MappingHandle> result = new ArrayList<SourcePositionMapBuilder.MappingHandle>(vmSections.size());
            int index = 0;
            for (SourcePositionMapBuilder.ResourceSection section : vmSections) {
                MultiRangeMapTestFrameworkBase.addSection(builder, section, index);
                ++index;
            }
            return result;
        }

        protected static SourcePositionMapBuilder.MappingHandle addSection(SourcePositionMapBuilder builder, SourcePositionMapBuilder.ResourceSection vmSection, int index) throws SourcePositionMapBuilder.CannotAddException {
            SourcePositionMapBuilder.ResourceSection originalSection = new SourcePositionMapBuilder.ResourceSection(new VmResourceId("source" + index + ".js", null), 0, 0, 5, 0);
            TextSectionMappingImpl textMapping = new TextSectionMappingImpl(new StringMappingData(new int[]{vmSection.getStart().getLine(), vmSection.getStart().getColumn()}, vmSection.getEnd().getLine(), vmSection.getEnd().getColumn()), new StringMappingData(new int[2], 5, 0));
            return builder.addMapping(originalSection, vmSection, (TextSectionMapping)textMapping);
        }
    }

    private static class OverlappingMapTestFramework
    extends MultiRangeMapTestFrameworkBase {
        private static SourcePositionMapBuilder.ResourceSection[] CONFLICT_SECTIONS = new SourcePositionMapBuilder.ResourceSection[]{new SourcePositionMapBuilder.ResourceSection(COMPILED_JS_ID, 1, 0, 2, 0), new SourcePositionMapBuilder.ResourceSection(COMPILED_JS_ID, 0, 1, 1, 1), new SourcePositionMapBuilder.ResourceSection(COMPILED_JS_ID, 1, 1, 2, 1), new SourcePositionMapBuilder.ResourceSection(COMPILED_JS_ID, 1, 1, 1, 2), new SourcePositionMapBuilder.ResourceSection(COMPILED_JS_ID, 2, 0, 4, 0), new SourcePositionMapBuilder.ResourceSection(COMPILED_JS_ID, 4, 0, 6, 0), new SourcePositionMapBuilder.ResourceSection(COMPILED_JS_ID, 6, 0, 7, 0), new SourcePositionMapBuilder.ResourceSection(COMPILED_JS_ID, 7, 0, 9, 0)};

        private OverlappingMapTestFramework() {
        }

        @Override
        protected void runOneShuffle(Random random) throws SourcePositionMapBuilder.CannotAddException {
            PositionMapBuilderImpl builder = new PositionMapBuilderImpl();
            ArrayList<SourcePositionMapBuilder.MappingHandle> goodRangeHandles = this.addGoodRanges((SourcePositionMapBuilder)builder, random);
            int conflict_section_index = goodRangeHandles.size();
            SourcePositionMapBuilder.ResourceSection[] resourceSectionArray = CONFLICT_SECTIONS;
            int n = CONFLICT_SECTIONS.length;
            int n2 = 0;
            while (n2 < n) {
                SourcePositionMapBuilder.ResourceSection section = resourceSectionArray[n2];
                PositionMapBuilderImplTest.assertThrowsAddException(new RunnableWithCannotAddException((SourcePositionMapBuilder)builder, section, conflict_section_index){
                    private final /* synthetic */ SourcePositionMapBuilder val$builder;
                    private final /* synthetic */ SourcePositionMapBuilder.ResourceSection val$section;
                    private final /* synthetic */ int val$conflict_section_index;
                    {
                        this.val$builder = sourcePositionMapBuilder;
                        this.val$section = resourceSection;
                        this.val$conflict_section_index = n;
                    }

                    @Override
                    public void run() throws SourcePositionMapBuilder.CannotAddException {
                        OverlappingMapTestFramework.addSection(this.val$builder, this.val$section, this.val$conflict_section_index);
                    }
                });
                ++n2;
            }
        }
    }

    private static interface RunnableWithCannotAddException {
        public void run() throws SourcePositionMapBuilder.CannotAddException;
    }
}

