/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.db.tests.internal.platforms;

import org.eclipse.datatools.connectivity.sqm.core.rte.ICatalogObject;
import org.eclipse.jpt.jpa.db.Catalog;
import org.eclipse.jpt.jpa.db.Column;
import org.eclipse.jpt.jpa.db.ConnectionListener;
import org.eclipse.jpt.jpa.db.ForeignKey;
import org.eclipse.jpt.jpa.db.Schema;
import org.eclipse.jpt.jpa.db.Table;
import org.eclipse.jpt.jpa.db.tests.internal.platforms.DTPPlatformTests;

public class SybaseTests
extends DTPPlatformTests {
    private static final String CR = System.getProperty("line.separator");

    public SybaseTests(String name) {
        super(name);
    }

    @Override
    protected String getPlatformPropertiesFileName() {
        return "sybase.properties";
    }

    @Override
    protected String getDriverName() {
        return "Sybase JDBC Driver for Sybase ASE 15.x";
    }

    @Override
    protected String getDriverDefinitionID() {
        return "DriverDefn.Sybase JDBC Driver for Sybase ASE 15.x";
    }

    @Override
    protected String getDriverDefinitionType() {
        return "org.eclipse.datatools.connectivity.db.sybase.ase.genericDriverTemplate_15";
    }

    @Override
    protected String getDatabaseVendor() {
        return "Sybase_ASE";
    }

    @Override
    protected String getDatabaseVersion() {
        return "15.x";
    }

    @Override
    protected String getDriverClass() {
        return "com.sybase.jdbc3.jdbc.SybDriver";
    }

    @Override
    protected String getProfileName() {
        return "Sybase_15";
    }

    @Override
    protected String getProfileDescription() {
        return "Sybase ASE 15 jConnect JDBC Profile [Test]";
    }

    @Override
    protected boolean supportsCatalogs() {
        return true;
    }

    @Override
    protected boolean executeOfflineTests() {
        return false;
    }

    public void testCatalog() throws Exception {
        this.connectionProfile.connect();
        DTPPlatformTests.TestConnectionListener listener = new DTPPlatformTests.TestConnectionListener();
        this.connectionProfile.addConnectionListener((ConnectionListener)listener);
        this.getJDBCConnection().setCatalog("master");
        this.executeUpdateIgnoreErrors("drop database test1");
        this.executeUpdateIgnoreErrors("drop database test2");
        this.executeUpdate("create database test1");
        ((ICatalogObject)this.getDTPDatabase()).refresh();
        Catalog catalog1 = this.getDatabase().getCatalogNamed("test1");
        SybaseTests.assertNotNull((Object)catalog1);
        Schema schema1 = catalog1.getSchemaNamed("dbo");
        SybaseTests.assertNotNull((Object)schema1);
        SybaseTests.assertSame((Object)schema1, (Object)catalog1.getDefaultSchema());
        this.executeUpdate("create database test2");
        Catalog catalog2 = this.getDatabase().getCatalogNamed("test2");
        SybaseTests.assertNull((Object)catalog2);
        ((ICatalogObject)this.getDTPDatabase()).refresh();
        SybaseTests.assertSame((Object)this.getDatabase(), (Object)listener.changedDatabase);
        catalog2 = this.getDatabase().getCatalogNamed("test2");
        SybaseTests.assertNotNull((Object)catalog2);
        Schema schema2 = catalog2.getDefaultSchema();
        SybaseTests.assertNotNull((Object)schema2);
        SybaseTests.assertNotSame((Object)catalog1, (Object)this.getDatabase().getCatalogNamed("test1"));
        SybaseTests.assertNotSame((Object)schema1, (Object)this.getDatabase().getCatalogNamed("test1").getDefaultSchema());
        this.executeUpdate("drop database test2");
        this.executeUpdate("drop database test1");
        this.connectionProfile.removeConnectionListener((ConnectionListener)listener);
        this.connectionProfile.disconnect();
    }

    public void testTable() throws Exception {
        this.connectionProfile.connect();
        DTPPlatformTests.TestConnectionListener listener = new DTPPlatformTests.TestConnectionListener();
        this.connectionProfile.addConnectionListener((ConnectionListener)listener);
        this.getJDBCConnection().setCatalog("master");
        this.executeUpdateIgnoreErrors("drop database table_test");
        this.executeUpdate("create database table_test");
        this.getJDBCConnection().setCatalog("table_test");
        this.executeUpdate(this.buildBarDDL());
        this.executeUpdate(this.buildFooDDL());
        this.executeUpdate(this.buildBazDDL());
        this.executeUpdate(this.buildFooBazDDL());
        ((ICatalogObject)this.getDTPDatabase()).refresh();
        Schema schema = this.getDatabase().getCatalogNamed("table_test").getDefaultSchema();
        Table fooTable = schema.getTableNamed("foo");
        SybaseTests.assertEquals((int)3, (int)fooTable.getColumnsSize());
        SybaseTests.assertEquals((int)1, (int)fooTable.getPrimaryKeyColumnsSize());
        SybaseTests.assertEquals((int)1, (int)fooTable.getForeignKeysSize());
        Column pkColumn = fooTable.getPrimaryKeyColumn();
        SybaseTests.assertEquals((String)"id", (String)pkColumn.getName());
        Column idColumn = fooTable.getColumnNamed("id");
        SybaseTests.assertSame((Object)fooTable, (Object)idColumn.getTable());
        SybaseTests.assertSame((Object)pkColumn, (Object)idColumn);
        SybaseTests.assertTrue((boolean)idColumn.isPartOfPrimaryKey());
        SybaseTests.assertFalse((boolean)idColumn.isPartOfForeignKey());
        SybaseTests.assertTrue((boolean)idColumn.isPartOfUniqueConstraint());
        SybaseTests.assertFalse((boolean)idColumn.isNullable());
        SybaseTests.assertEquals((String)"INT", (String)idColumn.getDataTypeName());
        SybaseTests.assertTrue((boolean)idColumn.isNumeric());
        SybaseTests.assertEquals((int)0, (int)idColumn.getPrecision());
        SybaseTests.assertEquals((int)0, (int)idColumn.getScale());
        SybaseTests.assertEquals((int)-1, (int)idColumn.getLength());
        SybaseTests.assertFalse((boolean)idColumn.isLOB());
        SybaseTests.assertEquals((String)"int", (String)idColumn.getJavaTypeDeclaration());
        Column nameColumn = fooTable.getColumnNamed("name");
        SybaseTests.assertFalse((boolean)nameColumn.isPartOfPrimaryKey());
        SybaseTests.assertFalse((boolean)nameColumn.isPartOfForeignKey());
        SybaseTests.assertTrue((boolean)nameColumn.isPartOfUniqueConstraint());
        SybaseTests.assertFalse((boolean)nameColumn.isNullable());
        SybaseTests.assertEquals((String)"VARCHAR", (String)nameColumn.getDataTypeName());
        SybaseTests.assertFalse((boolean)nameColumn.isNumeric());
        SybaseTests.assertEquals((int)-1, (int)nameColumn.getPrecision());
        SybaseTests.assertEquals((int)-1, (int)nameColumn.getScale());
        SybaseTests.assertEquals((int)20, (int)nameColumn.getLength());
        SybaseTests.assertFalse((boolean)nameColumn.isLOB());
        SybaseTests.assertEquals((String)"java.lang.String", (String)nameColumn.getJavaTypeDeclaration());
        Column barColumn = fooTable.getColumnNamed("bar_id");
        SybaseTests.assertEquals((String)"INT", (String)barColumn.getDataTypeName());
        SybaseTests.assertTrue((boolean)barColumn.isPartOfForeignKey());
        SybaseTests.assertFalse((boolean)barColumn.isPartOfPrimaryKey());
        ForeignKey barFK = (ForeignKey)fooTable.getForeignKeys().iterator().next();
        SybaseTests.assertEquals((int)1, (int)barFK.getColumnPairsSize());
        SybaseTests.assertEquals((String)"bar", (String)barFK.getAttributeName());
        SybaseTests.assertNull((Object)barFK.getJoinColumnAnnotationIdentifier("bar"));
        SybaseTests.assertEquals((String)"bar_id", (String)barFK.getJoinColumnAnnotationIdentifier("primaryBar"));
        SybaseTests.assertSame((Object)fooTable, (Object)barFK.getBaseTable());
        SybaseTests.assertFalse((boolean)fooTable.isPossibleJoinTable());
        SybaseTests.assertSame((Object)schema, (Object)fooTable.getSchema());
        Table barTable = schema.getTableNamed("bar");
        SybaseTests.assertEquals((int)2, (int)barTable.getColumnsSize());
        SybaseTests.assertEquals((int)1, (int)barTable.getPrimaryKeyColumnsSize());
        SybaseTests.assertEquals((int)0, (int)barTable.getForeignKeysSize());
        SybaseTests.assertEquals((String)"id", (String)barTable.getPrimaryKeyColumn().getName());
        SybaseTests.assertFalse((boolean)barTable.isPossibleJoinTable());
        Column chunkColumn = barTable.getColumnNamed("chunk");
        SybaseTests.assertEquals((String)"IMAGE", (String)chunkColumn.getDataTypeName());
        SybaseTests.assertFalse((boolean)chunkColumn.isNumeric());
        SybaseTests.assertTrue((boolean)chunkColumn.isLOB());
        SybaseTests.assertEquals((String)"byte[]", (String)chunkColumn.getJavaTypeDeclaration());
        SybaseTests.assertSame((Object)barTable, (Object)barFK.getReferencedTable());
        Table bazTable = schema.getTableNamed("baz");
        SybaseTests.assertEquals((int)4, (int)bazTable.getColumnsSize());
        SybaseTests.assertEquals((int)1, (int)bazTable.getPrimaryKeyColumnsSize());
        SybaseTests.assertEquals((int)0, (int)bazTable.getForeignKeysSize());
        Column nicknameColumn = bazTable.getColumnNamed("nickname");
        SybaseTests.assertTrue((boolean)nicknameColumn.isNullable());
        Column songColumn = bazTable.getColumnNamed("song");
        SybaseTests.assertFalse((boolean)songColumn.isNullable());
        Column salaryColumn = bazTable.getColumnNamed("salary");
        SybaseTests.assertFalse((boolean)salaryColumn.isPartOfUniqueConstraint());
        SybaseTests.assertEquals((String)"DECIMAL", (String)salaryColumn.getDataTypeName());
        SybaseTests.assertTrue((boolean)salaryColumn.isNumeric());
        SybaseTests.assertEquals((int)10, (int)salaryColumn.getPrecision());
        SybaseTests.assertEquals((int)2, (int)salaryColumn.getScale());
        SybaseTests.assertEquals((int)-1, (int)salaryColumn.getLength());
        SybaseTests.assertFalse((boolean)salaryColumn.isLOB());
        Table foo_bazTable = schema.getTableNamed("foo_baz");
        SybaseTests.assertEquals((int)2, (int)foo_bazTable.getColumnsSize());
        SybaseTests.assertEquals((int)0, (int)foo_bazTable.getPrimaryKeyColumnsSize());
        SybaseTests.assertEquals((int)2, (int)foo_bazTable.getForeignKeysSize());
        SybaseTests.assertTrue((boolean)foo_bazTable.isPossibleJoinTable());
        SybaseTests.assertTrue((boolean)foo_bazTable.joinTableNameIsDefault());
        SybaseTests.assertTrue((boolean)foo_bazTable.getColumnNamed("foo_id").isPartOfForeignKey());
        this.executeUpdate("drop table foo_baz");
        this.executeUpdate("drop table baz");
        this.executeUpdate("drop table foo");
        this.executeUpdate("drop table bar");
        this.getJDBCConnection().setCatalog("master");
        this.executeUpdate("drop database table_test");
        this.connectionProfile.removeConnectionListener((ConnectionListener)listener);
        this.connectionProfile.disconnect();
    }

    private String buildBarDDL() {
        StringBuilder sb = new StringBuilder(200);
        sb.append("create table bar (").append(CR);
        sb.append("    id integer primary key,").append(CR);
        sb.append("    chunk image").append(CR);
        sb.append(")").append(CR);
        return sb.toString();
    }

    private String buildFooDDL() {
        StringBuilder sb = new StringBuilder(200);
        sb.append("create table foo (").append(CR);
        sb.append("    id integer primary key,").append(CR);
        sb.append("    name varchar(20) unique,").append(CR);
        sb.append("    bar_id integer references bar(id)").append(CR);
        sb.append(")").append(CR);
        return sb.toString();
    }

    private String buildBazDDL() {
        StringBuilder sb = new StringBuilder(200);
        sb.append("create table baz (").append(CR);
        sb.append("    id integer primary key,").append(CR);
        sb.append("    nickname varchar(20) null,").append(CR);
        sb.append("    song varchar(20) not null,").append(CR);
        sb.append("    salary decimal(10, 2)").append(CR);
        sb.append(")").append(CR);
        return sb.toString();
    }

    private String buildFooBazDDL() {
        StringBuilder sb = new StringBuilder(200);
        sb.append("create table foo_baz (").append(CR);
        sb.append("    foo_id integer references foo(id),").append(CR);
        sb.append("    baz_id integer references baz(id)").append(CR);
        sb.append(")").append(CR);
        return sb.toString();
    }

    public void testTableLookup() throws Exception {
        this.connectionProfile.connect();
        DTPPlatformTests.TestConnectionListener listener = new DTPPlatformTests.TestConnectionListener();
        this.connectionProfile.addConnectionListener((ConnectionListener)listener);
        this.getJDBCConnection().setCatalog("master");
        this.executeUpdateIgnoreErrors("drop database table_lookup_test");
        this.executeUpdate("create database table_lookup_test");
        this.getJDBCConnection().setCatalog("table_lookup_test");
        this.executeUpdate("create table test1 (id integer, name varchar(20))");
        this.executeUpdate("create table TEST2 (id integer, name varchar(20))");
        this.executeUpdate("create table [Test3] (id integer, name varchar(20))");
        ((ICatalogObject)this.getDTPDatabase()).refresh();
        Schema schema = this.getDatabase().getCatalogNamed("table_lookup_test").getDefaultSchema();
        SybaseTests.assertNotNull((Object)schema.getTableNamed("test1"));
        SybaseTests.assertNotNull((Object)schema.getTableForIdentifier("test1"));
        SybaseTests.assertNotNull((Object)schema.getTableNamed("TEST2"));
        SybaseTests.assertNotNull((Object)schema.getTableForIdentifier("TEST2"));
        SybaseTests.assertNotNull((Object)schema.getTableForIdentifier("[Test3]"));
        this.executeUpdate("drop table [Test3]");
        this.executeUpdate("drop table TEST2");
        this.executeUpdate("drop table test1");
        this.getJDBCConnection().setCatalog("master");
        this.executeUpdate("drop database table_lookup_test");
        this.connectionProfile.removeConnectionListener((ConnectionListener)listener);
        this.connectionProfile.disconnect();
    }

    public void testColumnLookup() throws Exception {
        this.connectionProfile.connect();
        DTPPlatformTests.TestConnectionListener listener = new DTPPlatformTests.TestConnectionListener();
        this.connectionProfile.addConnectionListener((ConnectionListener)listener);
        this.getJDBCConnection().setCatalog("master");
        this.executeUpdateIgnoreErrors("drop database column_lookup_test");
        this.executeUpdate("create database column_lookup_test");
        this.getJDBCConnection().setCatalog("column_lookup_test");
        this.executeUpdate("create table test (id integer, name varchar(20))");
        ((ICatalogObject)this.getDTPDatabase()).refresh();
        Table table = this.getDatabase().getCatalogNamed("column_lookup_test").getDefaultSchema().getTableNamed("test");
        SybaseTests.assertNotNull((Object)table.getColumnNamed("id"));
        SybaseTests.assertNotNull((Object)table.getColumnNamed("name"));
        this.executeUpdate("drop table test");
        this.executeUpdate("create table test (ID integer, NAME varchar(20))");
        ((ICatalogObject)this.getDTPDatabase()).refresh();
        table = this.getDatabase().getCatalogNamed("column_lookup_test").getDefaultSchema().getTableNamed("test");
        SybaseTests.assertNotNull((Object)table.getColumnForIdentifier("ID"));
        SybaseTests.assertNotNull((Object)table.getColumnForIdentifier("NAME"));
        this.executeUpdate("drop table test");
        this.executeUpdate("create table test (Id integer, Name varchar(20))");
        ((ICatalogObject)this.getDTPDatabase()).refresh();
        table = this.getDatabase().getCatalogNamed("column_lookup_test").getDefaultSchema().getTableNamed("test");
        SybaseTests.assertNotNull((Object)table.getColumnForIdentifier("Id"));
        SybaseTests.assertNotNull((Object)table.getColumnForIdentifier("Name"));
        this.executeUpdate("drop table test");
        this.executeUpdate("create table test ([Id] integer, [Name] varchar(20))");
        ((ICatalogObject)this.getDTPDatabase()).refresh();
        table = this.getDatabase().getCatalogNamed("column_lookup_test").getDefaultSchema().getTableNamed("test");
        SybaseTests.assertNotNull((Object)table.getColumnForIdentifier("[Id]"));
        SybaseTests.assertNotNull((Object)table.getColumnForIdentifier("[Name]"));
        this.executeUpdate("drop table test");
        this.getJDBCConnection().setCatalog("master");
        this.executeUpdate("drop database column_lookup_test");
        this.connectionProfile.removeConnectionListener((ConnectionListener)listener);
        this.connectionProfile.disconnect();
    }

    public void testCrossSchemaReference() throws Exception {
        this.connectionProfile.connect();
        DTPPlatformTests.TestConnectionListener listener = new DTPPlatformTests.TestConnectionListener();
        this.connectionProfile.addConnectionListener((ConnectionListener)listener);
        this.getJDBCConnection().setCatalog("master");
        this.executeUpdateIgnoreErrors("drop database xref_test2");
        this.executeUpdateIgnoreErrors("drop database xref_test1");
        this.getJDBCConnection().setCatalog("master");
        this.executeUpdate("create database xref_test1");
        this.getJDBCConnection().setCatalog("xref_test1");
        this.executeUpdate("create table org (id integer primary key, name varchar(20))");
        this.getJDBCConnection().setCatalog("master");
        this.executeUpdate("create database xref_test2");
        this.getJDBCConnection().setCatalog("xref_test2");
        this.executeUpdate("create table emp (id integer primary key, name varchar(20), org_id integer references xref_test1..org(id))");
        ((ICatalogObject)this.getDTPDatabase()).refresh();
        Catalog catalog1 = this.getDatabase().getCatalogNamed("xref_test1");
        SybaseTests.assertNotNull((Object)catalog1);
        Schema schema1 = catalog1.getSchemaNamed("dbo");
        SybaseTests.assertNotNull((Object)schema1);
        Table orgTable = schema1.getTableNamed("org");
        SybaseTests.assertNotNull((Object)orgTable);
        Catalog catalog2 = this.getDatabase().getCatalogNamed("xref_test2");
        SybaseTests.assertNotNull((Object)catalog2);
        Schema schema2 = catalog2.getSchemaNamed("dbo");
        SybaseTests.assertNotNull((Object)schema2);
        Table empTable = schema2.getTableNamed("emp");
        SybaseTests.assertNotNull((Object)empTable);
        SybaseTests.assertEquals((int)1, (int)empTable.getForeignKeysSize());
        ForeignKey fk = (ForeignKey)empTable.getForeignKeys().iterator().next();
        Table refTable = fk.getReferencedTable();
        SybaseTests.assertNotNull((Object)refTable);
        SybaseTests.assertEquals((String)"org", (String)refTable.getName());
        SybaseTests.assertEquals((int)1, (int)fk.getColumnPairsSize());
        ForeignKey.ColumnPair cp = (ForeignKey.ColumnPair)fk.getColumnPairs().iterator().next();
        Column baseColumn = cp.getBaseColumn();
        SybaseTests.assertEquals((String)"org_id", (String)baseColumn.getName());
        Column refColumn = cp.getReferencedColumn();
        SybaseTests.assertEquals((String)"id", (String)refColumn.getName());
        this.getJDBCConnection().setCatalog("xref_test2");
        this.executeUpdate("drop table emp");
        this.getJDBCConnection().setCatalog("xref_test1");
        this.executeUpdate("drop table org");
        this.getJDBCConnection().setCatalog("master");
        this.executeUpdate("drop database xref_test2");
        this.executeUpdate("drop database xref_test1");
        this.connectionProfile.removeConnectionListener((ConnectionListener)listener);
        this.connectionProfile.disconnect();
    }
}

