/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.tests.model;

import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import junit.framework.Test;
import org.eclipse.wst.jsdt.core.IJavaScriptProject;
import org.eclipse.wst.jsdt.core.JavaScriptCore;
import org.eclipse.wst.jsdt.core.NamingConventions;
import org.eclipse.wst.jsdt.core.compiler.CharOperation;
import org.eclipse.wst.jsdt.core.tests.model.AbstractJavaModelTests;

public class NamingConventionTests
extends AbstractJavaModelTests {
    IJavaScriptProject project;

    public NamingConventionTests(String name) {
        super(name);
    }

    public static Test suite() {
        return NamingConventionTests.buildModelTestSuite(NamingConventionTests.class);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.project = this.createJavaProject("P", new String[]{"src"});
    }

    @Override
    public void tearDown() throws Exception {
        this.deleteProject("P");
        super.tearDown();
    }

    private String toString(char[][] suggestions) {
        if (suggestions == null) {
            return "";
        }
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < suggestions.length) {
            if (i != 0) {
                buffer.append('\n');
            }
            buffer.append(suggestions[i]);
            ++i;
        }
        return buffer.toString();
    }

    public void testSuggestFieldName001() {
        char[][] suggestions = NamingConventions.suggestFieldNames((IJavaScriptProject)this.project, (char[])"a.b.c".toCharArray(), (char[])"OneName".toCharArray(), (int)0, (int)0, (char[][])CharOperation.NO_CHAR_CHAR);
        NamingConventionTests.assertEquals((String)"name\noneName", (String)this.toString(suggestions));
    }

    public void testSuggestFieldName002() {
        char[][] suggestions = NamingConventions.suggestFieldNames((IJavaScriptProject)this.project, (char[])"a.b.c".toCharArray(), (char[])"OneClass".toCharArray(), (int)0, (int)0, (char[][])CharOperation.NO_CHAR_CHAR);
        NamingConventionTests.assertEquals((String)"class1\noneClass", (String)this.toString(suggestions));
    }

    public void testSuggestFieldName003() {
        Hashtable options = JavaScriptCore.getOptions();
        Object fieldPrefixPreviousValue = options.get("org.eclipse.wst.jsdt.core.codeComplete.fieldPrefixes");
        options.put("org.eclipse.wst.jsdt.core.codeComplete.fieldPrefixes", "f");
        JavaScriptCore.setOptions((Hashtable)options);
        char[][] suggestions = NamingConventions.suggestFieldNames((IJavaScriptProject)this.project, (char[])"a.b.c".toCharArray(), (char[])"OneName".toCharArray(), (int)0, (int)0, (char[][])CharOperation.NO_CHAR_CHAR);
        options.put("org.eclipse.wst.jsdt.core.codeComplete.fieldPrefixes", fieldPrefixPreviousValue);
        JavaScriptCore.setOptions((Hashtable)options);
        NamingConventionTests.assertEquals((String)"fName\nfOneName\nname\noneName", (String)this.toString(suggestions));
    }

    public void testSuggestFieldName004() {
        Hashtable options = JavaScriptCore.getOptions();
        Object fieldPrefixPreviousValue = options.get("org.eclipse.wst.jsdt.core.codeComplete.fieldPrefixes");
        options.put("org.eclipse.wst.jsdt.core.codeComplete.fieldPrefixes", "_");
        JavaScriptCore.setOptions((Hashtable)options);
        char[][] suggestions = NamingConventions.suggestFieldNames((IJavaScriptProject)this.project, (char[])"a.b.c".toCharArray(), (char[])"OneName".toCharArray(), (int)0, (int)0, (char[][])CharOperation.NO_CHAR_CHAR);
        options.put("org.eclipse.wst.jsdt.core.codeComplete.fieldPrefixes", fieldPrefixPreviousValue);
        JavaScriptCore.setOptions((Hashtable)options);
        NamingConventionTests.assertEquals((String)"_name\n_oneName\nname\noneName", (String)this.toString(suggestions));
    }

    public void testSuggestFieldName005() {
        Hashtable options = JavaScriptCore.getOptions();
        Object fieldPrefixPreviousValue = options.get("org.eclipse.wst.jsdt.core.codeComplete.fieldPrefixes");
        options.put("org.eclipse.wst.jsdt.core.codeComplete.fieldPrefixes", "f");
        Object staticFieldPrefixPreviousValue = options.get("org.eclipse.wst.jsdt.core.codeComplete.fieldPrefixes");
        options.put("org.eclipse.wst.jsdt.core.codeComplete.staticFieldPrefixes", "fg");
        JavaScriptCore.setOptions((Hashtable)options);
        char[][] suggestions = NamingConventions.suggestFieldNames((IJavaScriptProject)this.project, (char[])"a.b.c".toCharArray(), (char[])"OneName".toCharArray(), (int)0, (int)8, (char[][])CharOperation.NO_CHAR_CHAR);
        options.put("org.eclipse.wst.jsdt.core.codeComplete.fieldPrefixes", fieldPrefixPreviousValue);
        options.put("org.eclipse.wst.jsdt.core.codeComplete.staticFieldPrefixes", staticFieldPrefixPreviousValue);
        JavaScriptCore.setOptions((Hashtable)options);
        NamingConventionTests.assertEquals((String)"fgName\nfgOneName\nname\noneName", (String)this.toString(suggestions));
    }

    public void testSuggestFieldName006() {
        Hashtable options = JavaScriptCore.getOptions();
        Object fieldPrefixPreviousValue = options.get("org.eclipse.wst.jsdt.core.codeComplete.fieldPrefixes");
        options.put("org.eclipse.wst.jsdt.core.codeComplete.fieldPrefixes", "pre");
        Object fieldSuffixPreviousValue = options.get("org.eclipse.wst.jsdt.core.codeComplete.fieldSuffixes");
        options.put("org.eclipse.wst.jsdt.core.codeComplete.fieldSuffixes", "suf");
        JavaScriptCore.setOptions((Hashtable)options);
        char[][] suggestions = NamingConventions.suggestFieldNames((IJavaScriptProject)this.project, (char[])"a.b.c".toCharArray(), (char[])"OneName".toCharArray(), (int)0, (int)0, (char[][])CharOperation.NO_CHAR_CHAR);
        options.put("org.eclipse.wst.jsdt.core.codeComplete.fieldPrefixes", fieldPrefixPreviousValue);
        options.put("org.eclipse.wst.jsdt.core.codeComplete.fieldSuffixes", fieldSuffixPreviousValue);
        JavaScriptCore.setOptions((Hashtable)options);
        NamingConventionTests.assertEquals((String)"preNamesuf\npreOneNamesuf\npreName\npreOneName\nnamesuf\noneNamesuf\nname\noneName", (String)this.toString(suggestions));
    }

    public void testSuggestFieldName007() {
        Hashtable options = JavaScriptCore.getOptions();
        Object fieldPrefixPreviousValue = options.get("org.eclipse.wst.jsdt.core.codeComplete.fieldPrefixes");
        options.put("org.eclipse.wst.jsdt.core.codeComplete.fieldPrefixes", "pre");
        Object fieldSuffixPreviousValue = options.get("org.eclipse.wst.jsdt.core.codeComplete.fieldSuffixes");
        options.put("org.eclipse.wst.jsdt.core.codeComplete.fieldSuffixes", "suf");
        JavaScriptCore.setOptions((Hashtable)options);
        char[][] suggestions = NamingConventions.suggestFieldNames((IJavaScriptProject)this.project, (char[])"a.b.c".toCharArray(), (char[])"int".toCharArray(), (int)0, (int)0, (char[][])CharOperation.NO_CHAR_CHAR);
        options.put("org.eclipse.wst.jsdt.core.codeComplete.fieldPrefixes", fieldPrefixPreviousValue);
        options.put("org.eclipse.wst.jsdt.core.codeComplete.fieldSuffixes", fieldSuffixPreviousValue);
        JavaScriptCore.setOptions((Hashtable)options);
        NamingConventionTests.assertEquals((String)"preIsuf\npreI\nisuf\ni", (String)this.toString(suggestions));
    }

    public void testSuggestFieldName008() {
        char[][] suggestions = NamingConventions.suggestFieldNames((IJavaScriptProject)this.project, (char[])"a.b.c".toCharArray(), (char[])"OneName".toCharArray(), (int)0, (int)0, (char[][])new char[][]{"name".toCharArray()});
        NamingConventionTests.assertEquals((String)"name2\noneName", (String)this.toString(suggestions));
    }

    public void testSuggestFieldName009() {
        Hashtable options = JavaScriptCore.getOptions();
        Object fieldPrefixPreviousValue = options.get("org.eclipse.wst.jsdt.core.codeComplete.fieldPrefixes");
        options.put("org.eclipse.wst.jsdt.core.codeComplete.fieldPrefixes", "pre");
        Object fieldSuffixPreviousValue = options.get("org.eclipse.wst.jsdt.core.codeComplete.fieldSuffixes");
        options.put("org.eclipse.wst.jsdt.core.codeComplete.fieldSuffixes", "suf");
        JavaScriptCore.setOptions((Hashtable)options);
        char[][] suggestions = NamingConventions.suggestFieldNames((IJavaScriptProject)this.project, (char[])"a.b.c".toCharArray(), (char[])"OneName".toCharArray(), (int)0, (int)0, (char[][])new char[][]{"preNamesuf".toCharArray()});
        options.put("org.eclipse.wst.jsdt.core.codeComplete.fieldPrefixes", fieldPrefixPreviousValue);
        options.put("org.eclipse.wst.jsdt.core.codeComplete.fieldSuffixes", fieldSuffixPreviousValue);
        JavaScriptCore.setOptions((Hashtable)options);
        NamingConventionTests.assertEquals((String)"preName2suf\npreOneNamesuf\npreName\npreOneName\nnamesuf\noneNamesuf\nname\noneName", (String)this.toString(suggestions));
    }

    public void testSuggestFieldName010() {
        Hashtable options = JavaScriptCore.getOptions();
        Object fieldPrefixPreviousValue = options.get("org.eclipse.wst.jsdt.core.codeComplete.fieldPrefixes");
        options.put("org.eclipse.wst.jsdt.core.codeComplete.fieldPrefixes", "pre");
        Object fieldSuffixPreviousValue = options.get("org.eclipse.wst.jsdt.core.codeComplete.fieldSuffixes");
        options.put("org.eclipse.wst.jsdt.core.codeComplete.fieldSuffixes", "suf");
        JavaScriptCore.setOptions((Hashtable)options);
        char[][] suggestions = NamingConventions.suggestFieldNames((IJavaScriptProject)this.project, (char[])"a.b.c".toCharArray(), (char[])"OneName".toCharArray(), (int)1, (int)0, (char[][])new char[][]{"preNamesuf".toCharArray()});
        options.put("org.eclipse.wst.jsdt.core.codeComplete.fieldPrefixes", fieldPrefixPreviousValue);
        options.put("org.eclipse.wst.jsdt.core.codeComplete.fieldSuffixes", fieldSuffixPreviousValue);
        JavaScriptCore.setOptions((Hashtable)options);
        NamingConventionTests.assertEquals((String)"preNamessuf\npreOneNamessuf\npreNames\npreOneNames\nnamessuf\noneNamessuf\nnames\noneNames", (String)this.toString(suggestions));
    }

    public void testSuggestFieldName011() {
        char[][] suggestions = NamingConventions.suggestFieldNames((IJavaScriptProject)this.project, (char[])"a.b.c".toCharArray(), (char[])"Factory".toCharArray(), (int)1, (int)0, (char[][])CharOperation.NO_CHAR_CHAR);
        NamingConventionTests.assertEquals((String)"factories", (String)this.toString(suggestions));
    }

    public void testSuggestFieldName012() {
        String[] suggestions = NamingConventions.suggestFieldNames((IJavaScriptProject)this.project, (String)"a.b.c", (String)"FooBar", (int)0, (int)0, (String[])new String[]{"bar"});
        NamingConventionTests.assertEquals((String)"bar2\nfooBar", (String)this.toString(suggestions));
    }

    public void testSuggestFieldName013() {
        char[][] suggestions = NamingConventions.suggestFieldNames((IJavaScriptProject)this.project, (char[])"java.lang".toCharArray(), (char[])"Class".toCharArray(), (int)0, (int)0, (char[][])CharOperation.NO_CHAR_CHAR);
        NamingConventionTests.assertEquals((String)"class1", (String)this.toString(suggestions));
    }

    public void testSuggestFieldName014() {
        char[][] suggestions = NamingConventions.suggestFieldNames((IJavaScriptProject)this.project, (char[])"java.lang".toCharArray(), (char[])"Class".toCharArray(), (int)0, (int)0, (char[][])new char[][]{"class1".toCharArray()});
        NamingConventionTests.assertEquals((String)"class2", (String)this.toString(suggestions));
    }

    public void testSuggestFieldName015() {
        char[][] suggestions = NamingConventions.suggestFieldNames((IJavaScriptProject)this.project, (char[])"".toCharArray(), (char[])"#".toCharArray(), (int)0, (int)0, (char[][])CharOperation.NO_CHAR_CHAR);
        NamingConventionTests.assertEquals((String)"name", (String)this.toString(suggestions));
    }

    public void testSuggestFieldName016() {
        char[][] suggestions = NamingConventions.suggestFieldNames((IJavaScriptProject)this.project, (char[])"".toCharArray(), (char[])"#".toCharArray(), (int)0, (int)0, (char[][])new char[][]{"name".toCharArray()});
        NamingConventionTests.assertEquals((String)"name2", (String)this.toString(suggestions));
    }

    public void testSuggestFieldName017() {
        char[][] suggestions = NamingConventions.suggestFieldNames((IJavaScriptProject)this.project, (char[])"".toCharArray(), (char[])"names".toCharArray(), (int)0, (int)0, (char[][])new char[0][]);
        NamingConventionTests.assertEquals((String)"names", (String)this.toString(suggestions));
    }

    public void testSuggestFieldName018() {
        char[][] suggestions = NamingConventions.suggestFieldNames((IJavaScriptProject)this.project, (char[])"".toCharArray(), (char[])"names".toCharArray(), (int)1, (int)0, (char[][])new char[0][]);
        NamingConventionTests.assertEquals((String)"names", (String)this.toString(suggestions));
    }

    public void testSuggestFieldName019() {
        char[][] suggestions = NamingConventions.suggestFieldNames((IJavaScriptProject)this.project, (char[])"".toCharArray(), (char[])"MyClass".toCharArray(), (int)0, (int)0, (char[][])new char[0][]);
        NamingConventionTests.assertEquals((String)"class1\nmyClass", (String)this.toString(suggestions));
    }

    public void testSuggestFieldName020() {
        char[][] suggestions = NamingConventions.suggestFieldNames((IJavaScriptProject)this.project, (char[])"".toCharArray(), (char[])"MyClass".toCharArray(), (int)1, (int)0, (char[][])new char[0][]);
        NamingConventionTests.assertEquals((String)"classes\nmyClasses", (String)this.toString(suggestions));
    }

    public void testRemovePrefixAndSuffixForFieldName001() {
        Hashtable options = JavaScriptCore.getOptions();
        Object fieldPrefixPreviousValue = options.get("org.eclipse.wst.jsdt.core.codeComplete.fieldPrefixes");
        options.put("org.eclipse.wst.jsdt.core.codeComplete.fieldPrefixes", "pre");
        Object fieldSuffixPreviousValue = options.get("org.eclipse.wst.jsdt.core.codeComplete.fieldSuffixes");
        options.put("org.eclipse.wst.jsdt.core.codeComplete.fieldSuffixes", "suf");
        JavaScriptCore.setOptions((Hashtable)options);
        char[] name = NamingConventions.removePrefixAndSuffixForFieldName((IJavaScriptProject)this.project, (char[])"preOneNamesuf".toCharArray(), (int)0);
        options.put("org.eclipse.wst.jsdt.core.codeComplete.fieldPrefixes", fieldPrefixPreviousValue);
        options.put("org.eclipse.wst.jsdt.core.codeComplete.fieldSuffixes", fieldSuffixPreviousValue);
        JavaScriptCore.setOptions((Hashtable)options);
        NamingConventionTests.assertEquals((String)"oneName", (String)new String(name));
    }

    public void testRemovePrefixAndSuffixForFieldName002() {
        Hashtable options = JavaScriptCore.getOptions();
        Object fieldPrefixPreviousValue = options.get("org.eclipse.wst.jsdt.core.codeComplete.fieldPrefixes");
        options.put("org.eclipse.wst.jsdt.core.codeComplete.fieldPrefixes", "pr, pre");
        Object fieldSuffixPreviousValue = options.get("org.eclipse.wst.jsdt.core.codeComplete.fieldSuffixes");
        options.put("org.eclipse.wst.jsdt.core.codeComplete.fieldSuffixes", "uf, suf");
        JavaScriptCore.setOptions((Hashtable)options);
        char[] name = NamingConventions.removePrefixAndSuffixForFieldName((IJavaScriptProject)this.project, (char[])"preOneNamesuf".toCharArray(), (int)8);
        options.put("org.eclipse.wst.jsdt.core.codeComplete.fieldPrefixes", fieldPrefixPreviousValue);
        options.put("org.eclipse.wst.jsdt.core.codeComplete.fieldSuffixes", fieldSuffixPreviousValue);
        JavaScriptCore.setOptions((Hashtable)options);
        NamingConventionTests.assertEquals((String)"preOneNamesuf", (String)new String(name));
    }

    public void testRemovePrefixAndSuffixForFieldName003() {
        Hashtable options = JavaScriptCore.getOptions();
        Object fieldPrefixPreviousValue = options.get("org.eclipse.wst.jsdt.core.codeComplete.fieldPrefixes");
        options.put("org.eclipse.wst.jsdt.core.codeComplete.fieldPrefixes", "pr, pre");
        Object fieldSuffixPreviousValue = options.get("org.eclipse.wst.jsdt.core.codeComplete.fieldSuffixes");
        options.put("org.eclipse.wst.jsdt.core.codeComplete.fieldSuffixes", "uf, suf");
        JavaScriptCore.setOptions((Hashtable)options);
        char[] name = NamingConventions.removePrefixAndSuffixForFieldName((IJavaScriptProject)this.project, (char[])"preOneNamesuf".toCharArray(), (int)0);
        options.put("org.eclipse.wst.jsdt.core.codeComplete.fieldPrefixes", fieldPrefixPreviousValue);
        options.put("org.eclipse.wst.jsdt.core.codeComplete.fieldSuffixes", fieldSuffixPreviousValue);
        JavaScriptCore.setOptions((Hashtable)options);
        NamingConventionTests.assertEquals((String)"oneName", (String)new String(name));
    }

    public void testRemovePrefixAndSuffixForFieldName004() {
        Hashtable options = JavaScriptCore.getOptions();
        Object fieldPrefixPreviousValue = options.get("org.eclipse.wst.jsdt.core.codeComplete.fieldPrefixes");
        options.put("org.eclipse.wst.jsdt.core.codeComplete.fieldPrefixes", "pre,");
        JavaScriptCore.setOptions((Hashtable)options);
        char[] name = NamingConventions.removePrefixAndSuffixForFieldName((IJavaScriptProject)this.project, (char[])"preOneName".toCharArray(), (int)0);
        options.put("org.eclipse.wst.jsdt.core.codeComplete.fieldPrefixes", fieldPrefixPreviousValue);
        JavaScriptCore.setOptions((Hashtable)options);
        NamingConventionTests.assertEquals((String)"oneName", (String)new String(name));
    }

    public void testRemovePrefixAndSuffixForLocalName001() {
        Hashtable options = JavaScriptCore.getOptions();
        Object fieldPrefixPreviousValue = options.get("org.eclipse.wst.jsdt.core.codeComplete.localPrefixes");
        options.put("org.eclipse.wst.jsdt.core.codeComplete.localPrefixes", "pr, pre");
        Object fieldSuffixPreviousValue = options.get("org.eclipse.wst.jsdt.core.codeComplete.localSuffixes");
        options.put("org.eclipse.wst.jsdt.core.codeComplete.localSuffixes", "uf, suf");
        JavaScriptCore.setOptions((Hashtable)options);
        char[] name = NamingConventions.removePrefixAndSuffixForLocalVariableName((IJavaScriptProject)this.project, (char[])"preOneNamesuf".toCharArray());
        options.put("org.eclipse.wst.jsdt.core.codeComplete.localPrefixes", fieldPrefixPreviousValue);
        options.put("org.eclipse.wst.jsdt.core.codeComplete.localSuffixes", fieldSuffixPreviousValue);
        JavaScriptCore.setOptions((Hashtable)options);
        NamingConventionTests.assertEquals((String)"oneName", (String)new String(name));
    }

    public void testSuggestGetterName001() {
        char[] suggestion = NamingConventions.suggestGetterName((IJavaScriptProject)this.project, (char[])"fieldName".toCharArray(), (int)0, (boolean)false, (char[][])CharOperation.NO_CHAR_CHAR);
        NamingConventionTests.assertEquals((String)"getFieldName", (String)new String(suggestion));
    }

    public void testSuggestGetterName002() {
        char[] suggestion = NamingConventions.suggestGetterName((IJavaScriptProject)this.project, (char[])"FieldName".toCharArray(), (int)0, (boolean)false, (char[][])CharOperation.NO_CHAR_CHAR);
        NamingConventionTests.assertEquals((String)"getFieldName", (String)new String(suggestion));
    }

    public void testSuggestGetterName003() {
        Hashtable options = JavaScriptCore.getOptions();
        Object fieldPrefixPreviousValue = options.get("org.eclipse.wst.jsdt.core.codeComplete.fieldPrefixes");
        options.put("org.eclipse.wst.jsdt.core.codeComplete.fieldPrefixes", "pr, pre");
        Object fieldSuffixPreviousValue = options.get("org.eclipse.wst.jsdt.core.codeComplete.fieldSuffixes");
        options.put("org.eclipse.wst.jsdt.core.codeComplete.fieldSuffixes", "uf, suf");
        JavaScriptCore.setOptions((Hashtable)options);
        char[] suggestion = NamingConventions.suggestGetterName((IJavaScriptProject)this.project, (char[])"preFieldName".toCharArray(), (int)0, (boolean)false, (char[][])CharOperation.NO_CHAR_CHAR);
        options.put("org.eclipse.wst.jsdt.core.codeComplete.fieldPrefixes", fieldPrefixPreviousValue);
        options.put("org.eclipse.wst.jsdt.core.codeComplete.fieldSuffixes", fieldSuffixPreviousValue);
        JavaScriptCore.setOptions((Hashtable)options);
        NamingConventionTests.assertEquals((String)"getFieldName", (String)new String(suggestion));
    }

    public void testSuggestGetterName004() {
        Hashtable options = JavaScriptCore.getOptions();
        Object fieldPrefixPreviousValue = options.get("org.eclipse.wst.jsdt.core.codeComplete.fieldPrefixes");
        options.put("org.eclipse.wst.jsdt.core.codeComplete.fieldPrefixes", "pr, pre");
        Object fieldSuffixPreviousValue = options.get("org.eclipse.wst.jsdt.core.codeComplete.fieldSuffixes");
        options.put("org.eclipse.wst.jsdt.core.codeComplete.fieldSuffixes", "uf, suf");
        JavaScriptCore.setOptions((Hashtable)options);
        char[] suggestion = NamingConventions.suggestGetterName((IJavaScriptProject)this.project, (char[])"preFieldNamesuf".toCharArray(), (int)0, (boolean)false, (char[][])CharOperation.NO_CHAR_CHAR);
        options.put("org.eclipse.wst.jsdt.core.codeComplete.fieldPrefixes", fieldPrefixPreviousValue);
        options.put("org.eclipse.wst.jsdt.core.codeComplete.fieldSuffixes", fieldSuffixPreviousValue);
        JavaScriptCore.setOptions((Hashtable)options);
        NamingConventionTests.assertEquals((String)"getFieldName", (String)new String(suggestion));
    }

    public void testSuggestGetterName005() {
        Hashtable options = JavaScriptCore.getOptions();
        Object fieldPrefixPreviousValue = options.get("org.eclipse.wst.jsdt.core.codeComplete.fieldPrefixes");
        options.put("org.eclipse.wst.jsdt.core.codeComplete.fieldPrefixes", "pr, pre");
        Object fieldSuffixPreviousValue = options.get("org.eclipse.wst.jsdt.core.codeComplete.fieldSuffixes");
        options.put("org.eclipse.wst.jsdt.core.codeComplete.fieldSuffixes", "uf, suf");
        JavaScriptCore.setOptions((Hashtable)options);
        char[] suggestion = NamingConventions.suggestGetterName((IJavaScriptProject)this.project, (char[])"preFieldNamesuf".toCharArray(), (int)0, (boolean)true, (char[][])CharOperation.NO_CHAR_CHAR);
        options.put("org.eclipse.wst.jsdt.core.codeComplete.fieldPrefixes", fieldPrefixPreviousValue);
        options.put("org.eclipse.wst.jsdt.core.codeComplete.fieldSuffixes", fieldSuffixPreviousValue);
        JavaScriptCore.setOptions((Hashtable)options);
        NamingConventionTests.assertEquals((String)"isFieldName", (String)new String(suggestion));
    }

    public void testSuggestGetterName006() {
        char[] suggestion = NamingConventions.suggestGetterName((IJavaScriptProject)this.project, (char[])"isSomething".toCharArray(), (int)0, (boolean)true, (char[][])CharOperation.NO_CHAR_CHAR);
        NamingConventionTests.assertEquals((String)"isSomething", (String)new String(suggestion));
    }

    public void testSuggestGetterName007() {
        char[] suggestion = NamingConventions.suggestGetterName((IJavaScriptProject)this.project, (char[])"isSomething".toCharArray(), (int)0, (boolean)false, (char[][])CharOperation.NO_CHAR_CHAR);
        NamingConventionTests.assertEquals((String)"getIsSomething", (String)new String(suggestion));
    }

    public void testSuggestSetterName001() {
        char[] suggestion = NamingConventions.suggestSetterName((IJavaScriptProject)this.project, (char[])"isSomething".toCharArray(), (int)0, (boolean)true, (char[][])CharOperation.NO_CHAR_CHAR);
        NamingConventionTests.assertEquals((String)"setSomething", (String)new String(suggestion));
    }

    public void testSuggestSetterName002() {
        char[] suggestion = NamingConventions.suggestSetterName((IJavaScriptProject)this.project, (char[])"isSomething".toCharArray(), (int)0, (boolean)false, (char[][])CharOperation.NO_CHAR_CHAR);
        NamingConventionTests.assertEquals((String)"setIsSomething", (String)new String(suggestion));
    }

    public void testSuggestLocalName001() {
        Map options = this.project.getOptions(true);
        try {
            HashMap<String, String> newOptions = new HashMap<String, String>(options);
            newOptions.put("org.eclipse.wst.jsdt.core.compiler.codegen.targetPlatform", "1.5");
            newOptions.put("org.eclipse.wst.jsdt.core.compiler.source", "1.5");
            newOptions.put("org.eclipse.wst.jsdt.core.compiler.compliance", "1.5");
            this.project.setOptions(newOptions);
            String[] suggestions = NamingConventions.suggestLocalVariableNames((IJavaScriptProject)this.project, (String)"", (String)"Enum", (int)0, (String[])new String[]{"o"});
            NamingConventionTests.assertEquals((String)"enum1", (String)this.toString(suggestions));
        }
        finally {
            this.project.setOptions(options);
        }
    }

    public void testSuggestLocalName002() {
        Map options = this.project.getOptions(true);
        try {
            HashMap<String, String> newOptions = new HashMap<String, String>(options);
            newOptions.put("org.eclipse.wst.jsdt.core.compiler.codegen.targetPlatform", "1.5");
            newOptions.put("org.eclipse.wst.jsdt.core.compiler.source", "1.5");
            newOptions.put("org.eclipse.wst.jsdt.core.compiler.compliance", "1.5");
            this.project.setOptions(newOptions);
            String[] suggestions = NamingConventions.suggestLocalVariableNames((IJavaScriptProject)this.project, (String)"", (String)"Enums", (int)0, (String[])new String[]{"o"});
            NamingConventionTests.assertEquals((String)"enums", (String)this.toString(suggestions));
        }
        finally {
            this.project.setOptions(options);
        }
    }
}

