/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.core.tests.document;

import java.io.IOException;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension3;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.wst.sse.core.internal.text.BasicStructuredDocument;
import org.eclipse.wst.xml.core.internal.text.rules.StructuredTextPartitionerForXML;
import org.eclipse.wst.xml.core.tests.document.UnzippedProjectTester;

public class FileBufferDocumentTester
extends UnzippedProjectTester {
    private void doTestCreate(String filePath, Class expectedDocumentClass, Class expectedPartioner) throws CoreException, IOException {
        IFile file = (IFile)fTestProject.findMember(filePath);
        FileBufferDocumentTester.assertNotNull((String)("Test Case in error. Could not find file " + filePath), (Object)file);
        IPath fullPath = file.getFullPath();
        ITextFileBufferManager bufferManager = FileBuffers.getTextFileBufferManager();
        bufferManager.connect(fullPath, LocationKind.IFILE, null);
        ITextFileBuffer buffer = bufferManager.getTextFileBuffer(fullPath);
        IDocument document = buffer.getDocument();
        FileBufferDocumentTester.assertNotNull((Object)document);
        FileBufferDocumentTester.assertTrue((String)("wrong class of document: " + (document != null ? document.getClass() : null)), (boolean)expectedDocumentClass.isInstance(document));
        FileBufferDocumentTester.assertTrue((String)"document does not implement IDocumentExtension3", (boolean)(document instanceof IDocumentExtension3));
        IDocumentPartitioner actualPartitioner = ((IDocumentExtension3)document).getDocumentPartitioner("org.eclipse.wst.sse.core.default_structured_text_partitioning");
        FileBufferDocumentTester.assertTrue((String)("wrong partitioner in document: " + actualPartitioner), (boolean)expectedPartioner.isInstance(actualPartitioner));
        bufferManager.disconnect(fullPath, LocationKind.IFILE, null);
    }

    public void testFile103() throws CoreException, IOException {
        this.doTestCreate("testfiles/xml/EmptyFile.xml", BasicStructuredDocument.class, StructuredTextPartitionerForXML.class);
    }

    public void testFile104() throws CoreException, IOException {
        this.doTestCreate("testfiles/xml/eucjp.xml", BasicStructuredDocument.class, StructuredTextPartitionerForXML.class);
    }

    public void testFile105() throws CoreException, IOException {
        this.doTestCreate("testfiles/xml/IllformedNormalNonDefault.xml", BasicStructuredDocument.class, StructuredTextPartitionerForXML.class);
    }

    public void testFile106() throws CoreException, IOException {
        this.doTestCreate("testfiles/xml/MalformedNoEncoding.xml", BasicStructuredDocument.class, StructuredTextPartitionerForXML.class);
    }

    public void testFile107() throws CoreException, IOException {
        this.doTestCreate("testfiles/xml/MalformedNoEncoding.xsl", BasicStructuredDocument.class, StructuredTextPartitionerForXML.class);
    }

    public void testFile108() throws CoreException, IOException {
        this.doTestCreate("testfiles/xml/NoEncoding.xml", BasicStructuredDocument.class, StructuredTextPartitionerForXML.class);
    }

    public void testFile109() throws CoreException, IOException {
        this.doTestCreate("testfiles/xml/NormalNonDefault.xml", BasicStructuredDocument.class, StructuredTextPartitionerForXML.class);
    }

    public void testFile110() throws CoreException, IOException {
        this.doTestCreate("testfiles/xml/shiftjis.xml", BasicStructuredDocument.class, StructuredTextPartitionerForXML.class);
    }

    public void testFile111() throws CoreException, IOException {
        this.doTestCreate("testfiles/xml/testExtraJunk.xml", BasicStructuredDocument.class, StructuredTextPartitionerForXML.class);
    }

    public void testFile112() throws CoreException, IOException {
        this.doTestCreate("testfiles/xml/testExtraValidStuff.xml", BasicStructuredDocument.class, StructuredTextPartitionerForXML.class);
    }

    public void testFile113() throws CoreException, IOException {
        this.doTestCreate("testfiles/xml/testIllFormed.xml", BasicStructuredDocument.class, StructuredTextPartitionerForXML.class);
    }

    public void testFile114() throws CoreException, IOException {
        this.doTestCreate("testfiles/xml/testIllFormed2.xml", BasicStructuredDocument.class, StructuredTextPartitionerForXML.class);
    }

    public void testFile115() throws CoreException, IOException {
        this.doTestCreate("testfiles/xml/testIllFormed3.xml", BasicStructuredDocument.class, StructuredTextPartitionerForXML.class);
    }

    public void testFile116() throws CoreException, IOException {
        this.doTestCreate("testfiles/xml/testIllFormed4.xml", BasicStructuredDocument.class, StructuredTextPartitionerForXML.class);
    }

    public void testFile117() throws CoreException, IOException {
        this.doTestCreate("testfiles/xml/testMultiLine.xml", BasicStructuredDocument.class, StructuredTextPartitionerForXML.class);
    }

    public void testFile118() throws CoreException, IOException {
        this.doTestCreate("testfiles/xml/testNoEncodingValue.xml", BasicStructuredDocument.class, StructuredTextPartitionerForXML.class);
    }

    public void testFile119() throws CoreException, IOException {
        this.doTestCreate("testfiles/xml/testNormalCase.xml", BasicStructuredDocument.class, StructuredTextPartitionerForXML.class);
    }

    public void testFile120() throws CoreException, IOException {
        this.doTestCreate("testfiles/xml/testNoXMLDecl.xml", BasicStructuredDocument.class, StructuredTextPartitionerForXML.class);
    }

    public void testFile121() throws CoreException, IOException {
        this.doTestCreate("testfiles/xml/testNoXMLDeclAtFirst.xml", BasicStructuredDocument.class, StructuredTextPartitionerForXML.class);
    }

    public void testFile122() throws CoreException, IOException {
        this.doTestCreate("testfiles/xml/testNoXMLDeclInLargeFile.xml", BasicStructuredDocument.class, StructuredTextPartitionerForXML.class);
    }

    public void testFile123() throws CoreException, IOException {
        this.doTestCreate("testfiles/xml/testUTF16.xml", BasicStructuredDocument.class, StructuredTextPartitionerForXML.class);
    }

    public void testFile124() throws CoreException, IOException {
        this.doTestCreate("testfiles/xml/UTF16LEAtStartOfLargeFile.xml", BasicStructuredDocument.class, StructuredTextPartitionerForXML.class);
    }

    public void testFile125() throws CoreException, IOException {
        this.doTestCreate("testfiles/xml/utf16UnicodeStreamWithNoEncodingInHeader2.xml", BasicStructuredDocument.class, StructuredTextPartitionerForXML.class);
    }

    public void testFile126() throws CoreException, IOException {
        this.doTestCreate("testfiles/xml/utf16UnicodeStreamWithNoEncodingInHeaderBE.xml", BasicStructuredDocument.class, StructuredTextPartitionerForXML.class);
    }

    public void testFile127() throws CoreException, IOException {
        this.doTestCreate("testfiles/xml/utf16WithJapaneseChars.xml", BasicStructuredDocument.class, StructuredTextPartitionerForXML.class);
    }

    public void testFile128() throws CoreException, IOException {
        this.doTestCreate("testfiles/xml/UTF8With3ByteBOM.xml", BasicStructuredDocument.class, StructuredTextPartitionerForXML.class);
    }

    public void testSimpleCase() throws CoreException, IOException {
        this.doTestCreate("testfiles/xml/testNormalCase.xml", BasicStructuredDocument.class, StructuredTextPartitionerForXML.class);
    }
}

