/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.tests.internal.collection;

import junit.framework.TestCase;
import org.eclipse.jpt.common.utility.collection.Bag;
import org.eclipse.jpt.common.utility.internal.collection.CollectionTools;
import org.eclipse.jpt.common.utility.internal.collection.HashBag;
import org.eclipse.jpt.common.utility.tests.internal.TestTools;

public class EmptyBagTests
extends TestCase {
    public EmptyBagTests(String name) {
        super(name);
    }

    public void testEmptyBag_iterator() throws Exception {
        EmptyBagTests.assertFalse((boolean)CollectionTools.emptyBag().iterator().hasNext());
    }

    public void testEmptyBag_size() throws Exception {
        EmptyBagTests.assertEquals((int)0, (int)CollectionTools.emptyBag().size());
    }

    public void testEmptyBag_uniqueIterator() throws Exception {
        EmptyBagTests.assertFalse((boolean)CollectionTools.emptyBag().uniqueIterator().hasNext());
    }

    public void testEmptyBag_uniqueCount() throws Exception {
        EmptyBagTests.assertEquals((int)0, (int)CollectionTools.emptyBag().uniqueCount());
    }

    public void testEmptyBag_count() throws Exception {
        EmptyBagTests.assertEquals((int)0, (int)CollectionTools.emptyBag().count((Object)"foo"));
    }

    public void testEmptyBag_entries() throws Exception {
        EmptyBagTests.assertFalse((boolean)CollectionTools.emptyBag().entries().hasNext());
    }

    public void testEmptyBag_remove() throws Exception {
        EmptyBagTests.assertFalse((boolean)CollectionTools.emptyBag().remove((Object)"foo", 3));
    }

    public void testEmptyBag_add() throws Exception {
        boolean exCaught = false;
        try {
            CollectionTools.emptyBag().add((Object)"foo", 3);
            EmptyBagTests.fail();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            exCaught = true;
        }
        EmptyBagTests.assertTrue((boolean)exCaught);
    }

    public void testEmptyBag_equals() throws Exception {
        EmptyBagTests.assertTrue((boolean)CollectionTools.emptyBag().equals((Object)CollectionTools.emptyBag()));
        EmptyBagTests.assertFalse((boolean)CollectionTools.emptyBag().equals((Object)"foo"));
        HashBag bag = new HashBag();
        EmptyBagTests.assertTrue((boolean)CollectionTools.emptyBag().equals((Object)bag));
        bag.add((Object)"foo");
        EmptyBagTests.assertFalse((boolean)CollectionTools.emptyBag().equals((Object)bag));
    }

    public void testEmptyBag_hashCode() throws Exception {
        EmptyBagTests.assertEquals((int)0, (int)CollectionTools.emptyBag().hashCode());
    }

    public void testEmptyBag_serialization() throws Exception {
        Bag xxx = TestTools.serialize(CollectionTools.emptyBag());
        EmptyBagTests.assertSame((Object)CollectionTools.emptyBag(), (Object)xxx);
    }
}

