/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.validation.tests.testcase;

import java.io.UnsupportedEncodingException;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.wst.validation.ValidationFramework;
import org.eclipse.wst.validation.ValidationResults;
import org.eclipse.wst.validation.internal.Tracing;
import org.eclipse.wst.validation.tests.testcase.TestEnvironment;

public class TestSuite5
extends TestCase {
    private TestEnvironment _env;
    private IProject _project;

    public static Test suite() {
        return new TestSuite(TestSuite5.class);
    }

    public TestSuite5(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this._env = new TestEnvironment();
        this._project = this._env.createProject("TestSuite5");
        IPath first = this._env.addFolder(this._project.getFullPath(), "first");
        IPath second = this._env.addFolder(first, "second");
        IPath third = this._env.addFolder(second, "third");
        this._env.addFile(third, "sample.test1", "info - information\nwarning - warning\nerror - error\n\nt1error - extra error\nt1warning - extra warning");
        TestEnvironment.enableOnlyTheseValidators("T5");
    }

    protected void tearDown() throws Exception {
        this._project.delete(true, null);
        this._env.dispose();
        super.tearDown();
    }

    public void testPatterns() throws CoreException, UnsupportedEncodingException, InterruptedException {
        Tracing.log((String)"TestSuite5-01: testFacetVersions starting");
        NullProgressMonitor monitor = new NullProgressMonitor();
        ValidationFramework vf = ValidationFramework.getDefault();
        IProject[] projects = new IProject[]{this._project};
        ValidationResults vr = vf.validate(projects, true, false, (IProgressMonitor)monitor);
        int errors = vr.getSeverityError();
        TestSuite5.assertEquals((String)"Number of errors", (int)1, (int)errors);
        Tracing.log((String)"TestSuite5-02:testFacetVersions finished");
    }
}

