/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.tests.model;

import junit.framework.Test;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.wst.jsdt.core.JavaScriptCore;
import org.eclipse.wst.jsdt.core.tests.model.ModifyingResourceTests;
import org.eclipse.wst.jsdt.internal.core.util.Util;

public class JavaScriptLikeExtensionsTests
extends ModifyingResourceTests {
    public JavaScriptLikeExtensionsTests(String name) {
        super(name);
    }

    public static Test suite() {
        return JavaScriptLikeExtensionsTests.buildModelTestSuite(JavaScriptLikeExtensionsTests.class);
    }

    @Override
    public void setUpSuite() throws Exception {
        super.setUpSuite();
        Util.resetJavaLikeExtensions();
    }

    public void testGetJavaScriptLikeExtensions01() {
        this.assertSortedStringsEqual("Unexpected file extensions", "js\n", JavaScriptCore.getJavaScriptLikeExtensions());
    }

    public void testGetJavaScriptLikeExtensions02() throws CoreException {
        IContentType javaContentType = Platform.getContentTypeManager().getContentType("org.eclipse.wst.jsdt.core.jsSource");
        try {
            if (javaContentType != null) {
                javaContentType.addFileSpec("abc", 8);
            }
            this.assertSortedStringsEqual("Unexpected file extensions", "abc\njs\n", JavaScriptCore.getJavaScriptLikeExtensions());
        }
        finally {
            if (javaContentType != null) {
                javaContentType.removeFileSpec("abc", 8);
            }
        }
    }

    public void testIJavaScriptLikeFileName01() {
        JavaScriptLikeExtensionsTests.assertTrue((String)"file.js should be a JavaScript-like file name", (boolean)JavaScriptCore.isJavaScriptLikeFileName((String)"file.js"));
    }

    public void testIJavaScriptLikeFileName02() {
        JavaScriptLikeExtensionsTests.assertFalse((String)"file.other should not be a JavaScript-like file name", (boolean)JavaScriptCore.isJavaScriptLikeFileName((String)"file.other"));
    }

    public void testIJavaScriptLikeFileName04() {
        JavaScriptLikeExtensionsTests.assertFalse((String)"file should not be a JavaScript-like file name", (boolean)JavaScriptCore.isJavaScriptLikeFileName((String)"file"));
    }

    public void testRemoveJavaScriptLikeExtension02() {
        JavaScriptLikeExtensionsTests.assertEquals((String)"Unexpected file without JavaScript-like extension", (String)"file", (String)JavaScriptCore.removeJavaScriptLikeExtension((String)"file.js"));
    }

    public void testRemoveJavaScriptLikeExtension03() {
        JavaScriptLikeExtensionsTests.assertEquals((String)"Unexpected file without JavaScript-like extension", (String)"file.other", (String)JavaScriptCore.removeJavaScriptLikeExtension((String)"file.other"));
    }
}

