/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.catalog.tests.internal;

import java.util.List;
import org.eclipse.wst.xml.catalog.tests.internal.AbstractCatalogTest;
import org.eclipse.wst.xml.catalog.tests.internal.CatalogTest;
import org.eclipse.wst.xml.catalog.tests.internal.TestPlugin;
import org.eclipse.wst.xml.core.internal.catalog.provisional.ICatalog;
import org.eclipse.wst.xml.core.internal.catalog.provisional.ICatalogEntry;
import org.eclipse.wst.xml.core.internal.catalog.provisional.INextCatalog;

public class CatalogContributorRegistryReaderTest
extends AbstractCatalogTest {
    @Override
    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public CatalogContributorRegistryReaderTest(String name) {
        super(name);
    }

    public final void testReadRegistry() throws Exception {
        String resolvedURI;
        ICatalogEntry entry;
        CatalogContributorRegistryReaderTest.assertNotNull((Object)this.defaultCatalog);
        CatalogContributorRegistryReaderTest.assertEquals((String)"default_catalog", (String)this.defaultCatalog.getId());
        CatalogContributorRegistryReaderTest.assertEquals((int)2, (int)this.defaultCatalog.getNextCatalogs().length);
        String pluginId = TestPlugin.getDefault().getBundle().getSymbolicName();
        CatalogContributorRegistryReaderTest.assertNotNull((Object)this.systemCatalog);
        List entries = CatalogTest.getCatalogEntries(this.systemCatalog, 3);
        int i = 0;
        while (i < entries.size()) {
            entry = (ICatalogEntry)entries.get(i);
            if ("testSystemId".equals(entry.getId())) {
                resolvedURI = this.resolvePath(pluginId, "data/Personal/personal.dtd");
                CatalogContributorRegistryReaderTest.assertEquals((String)resolvedURI, (String)entry.getURI());
                CatalogContributorRegistryReaderTest.assertEquals((String)"http://personal/personal.dtd", (String)entry.getKey());
            }
            ++i;
        }
        entries = CatalogTest.getCatalogEntries(this.systemCatalog, 2);
        i = 0;
        while (i < entries.size()) {
            entry = (ICatalogEntry)entries.get(i);
            if ("testPublicId1".equals(entry.getId())) {
                resolvedURI = this.resolvePath(pluginId, "data/Invoice/Invoice.dtd");
                CatalogContributorRegistryReaderTest.assertEquals((String)resolvedURI, (String)entry.getURI());
                CatalogContributorRegistryReaderTest.assertEquals((String)"InvoiceId_test", (String)entry.getKey());
                CatalogContributorRegistryReaderTest.assertEquals((String)"http://org.eclipse.wst.xml.example/Invoice.dtd", (String)entry.getAttributeValue("webURL"));
            } else if ("testMappingInfo".equals(entry.getId())) {
                resolvedURI = this.resolvePath(pluginId, "platform:/plugin/org.eclipse.xsd/cache/www.w3.org/2001/XMLSchema.xsd");
                CatalogContributorRegistryReaderTest.assertEquals((String)resolvedURI, (String)entry.getURI());
                CatalogContributorRegistryReaderTest.assertEquals((String)"http://www.w3.org/2001/XMLSchema1", (String)entry.getKey());
            }
            ++i;
        }
        entries = CatalogTest.getCatalogEntries(this.systemCatalog, 4);
        i = 0;
        while (i < entries.size()) {
            entry = (ICatalogEntry)entries.get(i);
            if ("testURIId1".equals(entry.getId())) {
                resolvedURI = this.resolvePath(pluginId, "data/example/example.xsd");
                CatalogContributorRegistryReaderTest.assertEquals((String)resolvedURI, (String)entry.getURI());
                CatalogContributorRegistryReaderTest.assertEquals((String)"http://apache.org/xml/xcatalog/example", (String)entry.getKey());
            } else if ("testURIId2".equals(entry.getId())) {
                resolvedURI = this.resolvePath(pluginId, "platform:/plugin/org.eclipse.xsd/cache/www.w3.org/2001/XMLSchema.xsd");
                CatalogContributorRegistryReaderTest.assertEquals((String)resolvedURI, (String)entry.getURI());
                CatalogContributorRegistryReaderTest.assertEquals((String)"http://www.w3.org/2001/XMLSchema", (String)entry.getKey());
            } else if ("testURIId3".equals(entry.getId())) {
                resolvedURI = this.resolvePath(pluginId, "jar:platform:/plugin/org.eclipse.wst.xml.catalog.tests/data/schemas.jar!/data/catalog.xsd");
                CatalogContributorRegistryReaderTest.assertEquals((String)resolvedURI, (String)entry.getURI());
                CatalogContributorRegistryReaderTest.assertEquals((String)"http://oasis.names.tc.entity.xmlns.xml.catalog", (String)entry.getKey());
            }
            ++i;
        }
        INextCatalog[] nextCatalogEntries = this.systemCatalog.getNextCatalogs();
        int i2 = 0;
        while (i2 < nextCatalogEntries.length) {
            INextCatalog nextCatalogEntry = nextCatalogEntries[i2];
            if ("testNestedCatalog".equals(nextCatalogEntry.getId())) {
                String resolvedURI2 = this.resolvePath(pluginId, "data/catalog1.xml");
                CatalogContributorRegistryReaderTest.assertEquals((String)resolvedURI2, (String)nextCatalogEntry.getCatalogLocation());
                ICatalog nextCatalog = nextCatalogEntry.getReferencedCatalog();
                CatalogContributorRegistryReaderTest.assertNotNull((Object)nextCatalog);
                CatalogContributorRegistryReaderTest.assertEquals((int)3, (int)nextCatalog.getCatalogEntries().length);
                entries = CatalogTest.getCatalogEntries(nextCatalog, 2);
                CatalogContributorRegistryReaderTest.assertEquals((int)1, (int)entries.size());
                ICatalogEntry entry2 = (ICatalogEntry)entries.get(0);
                CatalogContributorRegistryReaderTest.assertEquals((String)this.getFileLocation("data/Invoice/Invoice.dtd"), (String)entry2.getURI());
                CatalogContributorRegistryReaderTest.assertEquals((String)"InvoiceId_test", (String)entry2.getKey());
                entries = CatalogTest.getCatalogEntries(nextCatalog, 3);
                CatalogContributorRegistryReaderTest.assertEquals((int)1, (int)entries.size());
                entry2 = (ICatalogEntry)entries.get(0);
                CatalogContributorRegistryReaderTest.assertEquals((String)this.getFileLocation("data/Invoice/Invoice.dtd"), (String)entry2.getURI());
                CatalogContributorRegistryReaderTest.assertEquals((String)"Invoice.dtd", (String)entry2.getKey());
                entries = CatalogTest.getCatalogEntries(nextCatalog, 4);
                CatalogContributorRegistryReaderTest.assertEquals((int)1, (int)entries.size());
                entry2 = (ICatalogEntry)entries.get(0);
                CatalogContributorRegistryReaderTest.assertEquals((String)this.getFileLocation("data/Invoice/Invoice.dtd"), (String)entry2.getURI());
                CatalogContributorRegistryReaderTest.assertEquals((String)"http://www.test.com/Invoice.dtd", (String)entry2.getKey());
            }
            ++i2;
        }
    }
}

