/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.ui.internal.asd.design.editparts;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.Panel;
import org.eclipse.draw2d.ToolbarLayout;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.tools.DirectEditManager;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wst.wsdl.ui.internal.asd.design.DesignViewGraphicsConstants;
import org.eclipse.wst.wsdl.ui.internal.asd.design.directedit.LabelCellEditorLocator;
import org.eclipse.wst.wsdl.ui.internal.asd.design.directedit.LabelEditManager;
import org.eclipse.wst.wsdl.ui.internal.asd.design.editparts.BaseEditPart;
import org.eclipse.wst.wsdl.ui.internal.asd.design.editparts.EditPartNavigationHandlerUtil;
import org.eclipse.wst.wsdl.ui.internal.asd.design.editparts.IFeedbackHandler;
import org.eclipse.wst.wsdl.ui.internal.asd.design.editparts.INamedEditPart;
import org.eclipse.wst.wsdl.ui.internal.asd.design.editparts.InterfaceEditPart;
import org.eclipse.wst.wsdl.ui.internal.asd.design.editpolicies.ASDDragAndDropEditPolicy;
import org.eclipse.wst.wsdl.ui.internal.asd.design.editpolicies.ASDGraphNodeDragTracker;
import org.eclipse.wst.wsdl.ui.internal.asd.design.editpolicies.ASDLabelDirectEditPolicy;
import org.eclipse.wst.wsdl.ui.internal.asd.design.editpolicies.ASDSelectionEditPolicy;
import org.eclipse.wst.wsdl.ui.internal.asd.design.layouts.RowLayout;
import org.eclipse.wst.wsdl.ui.internal.asd.facade.IParameter;
import org.eclipse.wst.wsdl.ui.internal.asd.outline.ITreeElement;

public class ParameterEditPart
extends BaseEditPart
implements IFeedbackHandler,
INamedEditPart {
    protected Figure contentPane;
    protected Label parameterName;
    protected RowLayout rowLayout = new RowLayout();
    protected Image labelImage;
    protected ASDSelectionEditPolicy selectionHandlesEditPolicy = new ASDSelectionEditPolicy();
    private DirectEditManager manager;

    protected IFigure createFigure() {
        Figure figure = new Figure(){

            public void paint(Graphics graphics) {
                super.paint(graphics);
                graphics.pushState();
                Rectangle r = ParameterEditPart.this.parameterName.getBounds();
                int x = r.x + r.width - 1;
                graphics.setForegroundColor(ColorConstants.lightGray);
                graphics.drawLine(x, r.y, x, r.y + r.height);
                graphics.popState();
                ParameterEditPart.this.paintFocusCursor(new Rectangle(r.x + 1, r.y, r.width - 2, r.height), graphics);
            }
        };
        figure.setForegroundColor(DesignViewGraphicsConstants.defaultForegroundColor);
        figure.setLayoutManager((LayoutManager)this.rowLayout);
        this.contentPane = new Figure();
        ToolbarLayout toolbarLayout2 = new ToolbarLayout(false);
        toolbarLayout2.setStretchMinorAxis(true);
        this.contentPane.setLayoutManager((LayoutManager)toolbarLayout2);
        Panel parameterNamePane = new Panel();
        toolbarLayout2 = new ToolbarLayout(false);
        toolbarLayout2.setStretchMinorAxis(true);
        parameterNamePane.setLayoutManager((LayoutManager)toolbarLayout2);
        this.parameterName = new Label();
        this.parameterName.setLabelAlignment(1);
        this.parameterName.setBorder((Border)new MarginBorder(4, 10, 4, 10));
        parameterNamePane.add((IFigure)this.parameterName);
        figure.add((IFigure)parameterNamePane);
        figure.add((IFigure)this.contentPane);
        this.rowLayout.setConstraint((IFigure)parameterNamePane, "parameterName");
        this.rowLayout.setConstraint((IFigure)this.contentPane, "parameterType");
        if (this.getModel() instanceof ITreeElement) {
            this.labelImage = ((ITreeElement)this.getModel()).getImage();
        }
        if (this.isReadOnly()) {
            this.parameterName.setForegroundColor(DesignViewGraphicsConstants.readOnlyLabelColor);
        } else {
            this.parameterName.setForegroundColor(DesignViewGraphicsConstants.defaultForegroundColor);
        }
        return figure;
    }

    public void addNotify() {
        InterfaceEditPart.attachToInterfaceEditPart((EditPart)this, this.rowLayout);
        super.addNotify();
    }

    @Override
    public void performDirectEdit(Point cursorLocation) {
        if (!(this.isFileReadOnly() || this.isReadOnly() || cursorLocation != null && !this.hitTest(this.getLabelFigure().getBounds(), cursorLocation))) {
            this.manager = new LabelEditManager((GraphicalEditPart)this, new LabelCellEditorLocator(this, cursorLocation));
            this.manager.show();
        } else if (this.getFigure() instanceof Figure && this.hitTestFigure((Figure)this.getFigure(), cursorLocation) && this.isReadOnly()) {
            this.doOpenNewEditor();
        }
    }

    public void performRequest(Request req) {
        if (req.getType().equals("direct edit")) {
            this.performDirectEdit(null);
        }
    }

    @Override
    protected void createEditPolicies() {
        super.createEditPolicies();
        this.installEditPolicy("DirectEditPolicy", (EditPolicy)new ASDLabelDirectEditPolicy());
        if (!this.isReadOnly() && !this.isFileReadOnly()) {
            this.installEditPolicy("PrimaryDrag Policy", (EditPolicy)new ASDDragAndDropEditPolicy(this.getViewer(), this.selectionHandlesEditPolicy));
        }
        this.installEditPolicy("Selection Feedback", (EditPolicy)this.selectionHandlesEditPolicy);
    }

    public DragTracker getDragTracker(Request request) {
        return new ASDGraphNodeDragTracker((EditPart)this);
    }

    @Override
    public Label getLabelFigure() {
        return this.parameterName;
    }

    protected void refreshVisuals() {
        super.refreshVisuals();
        IParameter parameter = (IParameter)this.getModel();
        this.parameterName.setText(parameter.getName());
        if (this.labelImage != null) {
            this.parameterName.setIcon(this.labelImage);
        }
        this.rowLayout.getColumnData().clearColumnWidths();
        EditPart parent = this.getParent();
        while (parent != null) {
            if (parent instanceof InterfaceEditPart) {
                ((GraphicalEditPart)parent).getFigure().invalidateTree();
                break;
            }
            parent = parent.getParent();
        }
    }

    protected List getModelChildren() {
        ArrayList<Object> kids = new ArrayList<Object>();
        kids.add(this.getModel());
        return kids;
    }

    public IFigure getContentPane() {
        return this.contentPane;
    }

    @Override
    public void addFeedback() {
        this.parameterName.getParent().setBackgroundColor(DesignViewGraphicsConstants.tableCellSelectionColor);
    }

    @Override
    public void removeFeedback() {
        this.parameterName.getParent().setBackgroundColor(this.figure.getBackgroundColor());
    }

    @Override
    public EditPart getRelativeEditPart(int direction) {
        EditPart editPart = super.getRelativeEditPart(direction);
        if (direction == 4 && (editPart == null || editPart == this)) {
            editPart = EditPartNavigationHandlerUtil.getNextInterface((EditPart)this);
        }
        return editPart;
    }

    @Override
    protected String getAccessibleName() {
        Label labelFigure = this.getLabelFigure();
        if (labelFigure != null) {
            return labelFigure.getText();
        }
        return "";
    }
}

