/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.jsf.ui.sections;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jst.pagedesigner.commands.single.AddSubNodeCommand;
import org.eclipse.jst.pagedesigner.commands.single.ChangeAttributeCommand;
import org.eclipse.jst.pagedesigner.commands.single.RemoveSubNodeCommand;
import org.eclipse.jst.pagedesigner.jsf.ui.sections.SectionResources;
import org.eclipse.jst.pagedesigner.properties.BaseCustomSection;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;
import org.eclipse.wst.sse.core.internal.provisional.INodeNotifier;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class JSFHtmlInputOthersSection
extends BaseCustomSection {
    private Table _validatorsTable;
    private Table _convertorsTable;
    private Table _listenersTable;
    private TableViewer _validatorsViewer;
    private TableViewer _convertorsViewer;
    private TableViewer _listenersViewer;
    private Button _validateAddButton;
    private Button _validateRemoveButton;
    private Button _convertAddButton;
    private Button _convertRemoveButton;
    private Button _listenAddButton;
    private Button _listenRemoveButton;
    private CCombo _validateTypeCombo;
    private CCombo _convertTypeCombo;
    private CCombo _listenTypeCombo;
    private static final String[] VALIDATETYPES = new String[]{"DoubleRange", "Length", "LongRange"};
    private static final String[] CONVERTTYPES = new String[]{"DateTime", "Number"};
    private static final String[] LISTENTYPES = new String[]{"ValueChange"};
    private static final String[] VALIDATORS_COLUMN_NAMES = new String[]{"validator", "minimum", "maximum"};

    public void createControls(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        super.createControls(parent, aTabbedPropertySheetPage);
        TabbedPropertySheetWidgetFactory factory = aTabbedPropertySheetPage.getWidgetFactory();
        Composite top = factory.createFlatFormComposite(parent);
        GridLayout layout = new GridLayout();
        layout.numColumns = 4;
        top.setLayout((Layout)layout);
        this.createValidatePart(factory, top);
        this.createConvertPart(factory, top);
        this.createListenPart(factory, top);
    }

    private void createConvertPart(TabbedPropertySheetWidgetFactory factory, Composite other) {
        this._convertorsTable = factory.createTable(other, 65538);
        GridData data = new GridData(1808);
        data.horizontalSpan = 3;
        data.verticalSpan = 3;
        data.heightHint = 50;
        this._convertorsTable.setHeaderVisible(true);
        this._convertorsTable.setLayoutData((Object)data);
        this._convertorsTable.setLinesVisible(true);
        TableColumn convertColumn = new TableColumn(this._convertorsTable, 0);
        convertColumn.setText(SectionResources.getString("JSFHtmlInputTextSection.Converter"));
        convertColumn.setWidth(150);
        this._convertorsViewer = new TableViewer(this._convertorsTable);
        this._convertorsViewer.setContentProvider((IContentProvider)new ConvertContentLabelProvider());
        this._convertorsViewer.setLabelProvider((IBaseLabelProvider)new ConvertContentLabelProvider());
        this._convertorsViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                if (selection != null) {
                    IDOMElement node = (IDOMElement)selection.getFirstElement();
                    JSFHtmlInputOthersSection.this.gotoNode((Node)node);
                }
            }
        });
        this._convertorsViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                JSFHtmlInputOthersSection.this.updateConvertButtonStatus();
            }
        });
        this._convertTypeCombo = factory.createCCombo(other, 8);
        this._convertTypeCombo.setItems(CONVERTTYPES);
        this._convertTypeCombo.select(0);
        data = new GridData(256);
        this._convertTypeCombo.setLayoutData((Object)data);
        this._convertAddButton = factory.createButton(other, SectionResources.getString("JSFHtmlInputTextSection.Add"), 0);
        data = new GridData(256);
        this._convertAddButton.setLayoutData((Object)data);
        this._convertAddButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                HashMap attributes = new HashMap();
                AddSubNodeCommand c = new AddSubNodeCommand(SectionResources.getString("JSFHtmlInputTextSection.CommandLabel.AddSubTag"), JSFHtmlInputOthersSection.this._element, "convert" + JSFHtmlInputOthersSection.this._convertTypeCombo.getText(), "http://java.sun.com/jsf/core", attributes);
                c.execute();
                JSFHtmlInputOthersSection.this._convertorsViewer.refresh();
                JSFHtmlInputOthersSection.this.updateConvertButtonStatus();
            }
        });
        this._convertRemoveButton = factory.createButton(other, SectionResources.getString("JSFHtmlInputTextSection.Remove"), 0);
        data = new GridData(256);
        this._convertRemoveButton.setLayoutData((Object)data);
        this._convertRemoveButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = (IStructuredSelection)JSFHtmlInputOthersSection.this._convertorsViewer.getSelection();
                if (selection != null) {
                    for (IDOMElement node : selection) {
                        RemoveSubNodeCommand c = new RemoveSubNodeCommand(SectionResources.getString("JSFHtmlInputTextSection.CommandLabel.RemoveSubTag"), JSFHtmlInputOthersSection.this._element, node);
                        c.execute();
                    }
                    JSFHtmlInputOthersSection.this._convertorsViewer.refresh();
                    JSFHtmlInputOthersSection.this.updateConvertButtonStatus();
                }
            }
        });
    }

    private void createListenPart(TabbedPropertySheetWidgetFactory factory, Composite other) {
        this._listenersTable = factory.createTable(other, 65538);
        GridData data = new GridData(1808);
        data.horizontalSpan = 3;
        data.verticalSpan = 3;
        data.heightHint = 50;
        this._listenersTable.setHeaderVisible(true);
        this._listenersTable.setLayoutData((Object)data);
        this._listenersTable.setLinesVisible(true);
        TableColumn listenColumn = new TableColumn(this._listenersTable, 0);
        listenColumn.setText(SectionResources.getString("JSFHtmlInputTextSection.Listeners"));
        listenColumn.setWidth(150);
        this._listenersViewer = new TableViewer(this._listenersTable);
        this._listenersViewer.setContentProvider((IContentProvider)new ListenerContentLabelProvider());
        this._listenersViewer.setLabelProvider((IBaseLabelProvider)new ListenerContentLabelProvider());
        this._listenersViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                if (selection != null) {
                    IDOMElement node = (IDOMElement)selection.getFirstElement();
                    JSFHtmlInputOthersSection.this.gotoNode((Node)node);
                }
            }
        });
        this._listenersViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                JSFHtmlInputOthersSection.this.updateListenButtonStatus();
            }
        });
        this._listenTypeCombo = factory.createCCombo(other, 8);
        this._listenTypeCombo.setItems(LISTENTYPES);
        this._listenTypeCombo.select(0);
        data = new GridData(256);
        this._listenTypeCombo.setLayoutData((Object)data);
        this._listenAddButton = factory.createButton(other, SectionResources.getString("JSFHtmlInputTextSection.Add"), 0);
        data = new GridData(256);
        this._listenAddButton.setLayoutData((Object)data);
        this._listenAddButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                HashMap attributes = new HashMap();
                String listener = JSFHtmlInputOthersSection.this._listenTypeCombo.getText();
                listener = String.valueOf(listener.substring(0, 1).toLowerCase()) + listener.substring(1) + "Listener";
                AddSubNodeCommand c = new AddSubNodeCommand(SectionResources.getString("JSFHtmlInputTextSection.CommandLabel.AddSubTag"), JSFHtmlInputOthersSection.this._element, listener, "http://java.sun.com/jsf/core", attributes);
                c.execute();
                JSFHtmlInputOthersSection.this._listenersViewer.refresh();
                JSFHtmlInputOthersSection.this.updateListenButtonStatus();
            }
        });
        this._listenRemoveButton = factory.createButton(other, SectionResources.getString("JSFHtmlInputTextSection.Remove"), 0);
        data = new GridData(256);
        this._listenRemoveButton.setLayoutData((Object)data);
        this._listenRemoveButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = (IStructuredSelection)JSFHtmlInputOthersSection.this._listenersViewer.getSelection();
                if (selection != null) {
                    for (IDOMElement node : selection) {
                        RemoveSubNodeCommand c = new RemoveSubNodeCommand(SectionResources.getString("JSFHtmlInputTextSection.CommandLabel.RemoveSubTag"), JSFHtmlInputOthersSection.this._element, node);
                        c.execute();
                    }
                    JSFHtmlInputOthersSection.this._listenersViewer.refresh();
                    JSFHtmlInputOthersSection.this.updateListenButtonStatus();
                }
            }
        });
    }

    private void createValidatePart(TabbedPropertySheetWidgetFactory factory, Composite other) {
        this._validatorsTable = factory.createTable(other, 65538);
        GridData data = new GridData(1808);
        data.horizontalSpan = 3;
        data.verticalSpan = 3;
        data.heightHint = 50;
        this._validatorsTable.setHeaderVisible(true);
        this._validatorsTable.setLayoutData((Object)data);
        this._validatorsTable.setLinesVisible(true);
        TableColumn validateColumn = new TableColumn(this._validatorsTable, 0);
        validateColumn.setText(SectionResources.getString("JSFHtmlInputTextSection.Validators"));
        validateColumn.setWidth(150);
        TableColumn minColumn = new TableColumn(this._validatorsTable, 0);
        minColumn.setText(SectionResources.getString("JSFHtmlInputTextSection.Minimum"));
        minColumn.setWidth(100);
        TableColumn maxColumn = new TableColumn(this._validatorsTable, 0);
        maxColumn.setText(SectionResources.getString("JSFHtmlInputTextSection.Maximum"));
        maxColumn.setWidth(100);
        this._validatorsViewer = new TableViewer(this._validatorsTable);
        this._validatorsViewer.setColumnProperties(VALIDATORS_COLUMN_NAMES);
        CellEditor[] editors = new CellEditor[VALIDATORS_COLUMN_NAMES.length];
        TextCellEditor textEditor = new TextCellEditor((Composite)this._validatorsTable);
        editors[0] = textEditor;
        textEditor = new TextCellEditor((Composite)this._validatorsTable);
        editors[1] = textEditor;
        textEditor = new TextCellEditor((Composite)this._validatorsTable);
        editors[2] = textEditor;
        this._validatorsViewer.setCellEditors(editors);
        this._validatorsViewer.setCellModifier((ICellModifier)new ValidateCellModifier());
        this._validatorsViewer.setContentProvider((IContentProvider)new ValidateContentLabelProvider());
        this._validatorsViewer.setLabelProvider((IBaseLabelProvider)new ValidateContentLabelProvider());
        this._validatorsViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                if (selection != null) {
                    IDOMElement node = (IDOMElement)selection.getFirstElement();
                    JSFHtmlInputOthersSection.this.gotoNode((Node)node);
                }
            }
        });
        this._validatorsViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                JSFHtmlInputOthersSection.this.updateValidateButtonStatus();
            }
        });
        this._validateTypeCombo = factory.createCCombo(other, 8);
        this._validateTypeCombo.setItems(VALIDATETYPES);
        this._validateTypeCombo.select(0);
        data = new GridData(256);
        this._validateTypeCombo.setLayoutData((Object)data);
        this._validateAddButton = factory.createButton(other, SectionResources.getString("JSFHtmlInputTextSection.Add"), 0);
        data = new GridData(256);
        this._validateAddButton.setLayoutData((Object)data);
        this._validateAddButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                HashMap attributes = new HashMap();
                AddSubNodeCommand c = new AddSubNodeCommand(SectionResources.getString("JSFHtmlInputTextSection.CommandLabel.AddSubTag"), JSFHtmlInputOthersSection.this._element, "validate" + JSFHtmlInputOthersSection.this._validateTypeCombo.getText(), "http://java.sun.com/jsf/core", attributes);
                c.execute();
                JSFHtmlInputOthersSection.this._validatorsViewer.refresh();
                JSFHtmlInputOthersSection.this.updateValidateButtonStatus();
            }
        });
        this._validateRemoveButton = factory.createButton(other, SectionResources.getString("JSFHtmlInputTextSection.Remove"), 0);
        data = new GridData(256);
        this._validateRemoveButton.setLayoutData((Object)data);
        this._validateRemoveButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = (IStructuredSelection)JSFHtmlInputOthersSection.this._validatorsViewer.getSelection();
                if (selection != null) {
                    for (IDOMElement node : selection) {
                        RemoveSubNodeCommand c = new RemoveSubNodeCommand(SectionResources.getString("JSFHtmlInputTextSection.CommandLabel.RemoveSubTag"), JSFHtmlInputOthersSection.this._element, node);
                        c.execute();
                    }
                    JSFHtmlInputOthersSection.this._validatorsViewer.refresh();
                    JSFHtmlInputOthersSection.this.updateValidateButtonStatus();
                }
            }
        });
    }

    private void updateValidateButtonStatus() {
        this._validateRemoveButton.setEnabled(true);
        ISelection selection = this._validatorsViewer.getSelection();
        if (selection == null || selection.isEmpty()) {
            this._validateRemoveButton.setEnabled(false);
        }
        if (this._validatorsTable.getItemCount() == 0) {
            this._validateRemoveButton.setEnabled(false);
        }
    }

    private void updateConvertButtonStatus() {
        this._convertAddButton.setEnabled(true);
        this._convertRemoveButton.setEnabled(true);
        ISelection selection = this._convertorsViewer.getSelection();
        if (selection == null || selection.isEmpty()) {
            this._convertRemoveButton.setEnabled(false);
        }
        if (this._convertorsTable.getItemCount() == 0) {
            this._convertRemoveButton.setEnabled(false);
        }
        if (this._convertorsTable.getItemCount() > 0) {
            this._convertAddButton.setEnabled(false);
        }
    }

    private void updateListenButtonStatus() {
        this._listenRemoveButton.setEnabled(true);
        ISelection selection = this._listenersViewer.getSelection();
        if (selection == null || selection.isEmpty()) {
            this._listenRemoveButton.setEnabled(false);
        }
        if (this._listenersTable.getItemCount() == 0) {
            this._listenRemoveButton.setEnabled(false);
        }
    }

    public void setInput(IWorkbenchPart part, ISelection selection) {
        super.setInput(part, selection);
        this._validatorsViewer.setInput((Object)this._element);
        this.updateValidateButtonStatus();
        this._convertorsViewer.setInput((Object)this._element);
        this.updateConvertButtonStatus();
        this._listenersViewer.setInput((Object)this._element);
        this.updateListenButtonStatus();
    }

    private List getColumnNames() {
        return Arrays.asList(VALIDATORS_COLUMN_NAMES);
    }

    protected void notifyChanged(INodeNotifier notifier, int eventType, Object changedFeature, Object oldValue, Object newValue, int pos) {
        if (this._validatorsViewer != null && !this._validatorsViewer.getControl().isDisposed()) {
            this._validatorsViewer.refresh();
            this._convertorsViewer.refresh();
            this._listenersViewer.refresh();
        }
    }

    private class ConvertContentLabelProvider
    implements IStructuredContentProvider,
    ITableLabelProvider {
        private ConvertContentLabelProvider() {
        }

        public Object[] getElements(Object inputElement) {
            IDOMElement root = JSFHtmlInputOthersSection.this._element;
            ArrayList<Node> result = new ArrayList<Node>();
            NodeList children = root.getChildNodes();
            int i = 0;
            int n = children.getLength();
            while (i < n) {
                IDOMElement element;
                String nodeName;
                Node child = children.item(i);
                if (child.getNodeType() == 1 && (nodeName = (element = (IDOMElement)child).getNodeName()).indexOf("convert") != -1) {
                    result.add(child);
                }
                ++i;
            }
            if (result.isEmpty()) {
                return new Object[0];
            }
            return result.toArray(new IDOMElement[result.size()]);
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public String getColumnText(Object element, int columnIndex) {
            String result = null;
            if (element instanceof IDOMElement) {
                IDOMElement node = (IDOMElement)element;
                String nodeName = node.getNodeName();
                switch (columnIndex) {
                    case 0: {
                        result = nodeName;
                        break;
                    }
                }
            }
            return result != null ? result : "";
        }

        public void dispose() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }

    private class ListenerContentLabelProvider
    implements IStructuredContentProvider,
    ITableLabelProvider {
        private ListenerContentLabelProvider() {
        }

        public Object[] getElements(Object inputElement) {
            IDOMElement root = JSFHtmlInputOthersSection.this._element;
            ArrayList<Node> result = new ArrayList<Node>();
            NodeList children = root.getChildNodes();
            int i = 0;
            int n = children.getLength();
            while (i < n) {
                IDOMElement element;
                String nodeName;
                Node child = children.item(i);
                if (child.getNodeType() == 1 && (nodeName = (element = (IDOMElement)child).getNodeName()).indexOf("Listener") != -1) {
                    result.add(child);
                }
                ++i;
            }
            if (result.isEmpty()) {
                return new Object[0];
            }
            return result.toArray(new IDOMElement[result.size()]);
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public String getColumnText(Object element, int columnIndex) {
            String result = null;
            if (element instanceof IDOMElement) {
                IDOMElement node = (IDOMElement)element;
                String nodeName = node.getNodeName();
                switch (columnIndex) {
                    case 0: {
                        result = nodeName;
                        break;
                    }
                }
            }
            return result != null ? result : "";
        }

        public void dispose() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }

    private class ValidateCellModifier
    implements ICellModifier {
        private ValidateCellModifier() {
        }

        public boolean canModify(Object element, String property) {
            int columnIndex = JSFHtmlInputOthersSection.this.getColumnNames().indexOf(property);
            return columnIndex != 0;
        }

        public Object getValue(Object element, String property) {
            int columnIndex = JSFHtmlInputOthersSection.this.getColumnNames().indexOf(property);
            String result = null;
            IDOMElement node = (IDOMElement)element;
            switch (columnIndex) {
                case 0: {
                    result = node.getNodeName();
                    break;
                }
                case 1: {
                    result = node.getAttribute("minimum");
                    break;
                }
                case 2: {
                    result = node.getAttribute("maximum");
                    break;
                }
                default: {
                    result = "";
                }
            }
            return result != null ? result : "";
        }

        public void modify(Object element, String property, Object value) {
            int columnIndex = JSFHtmlInputOthersSection.this.getColumnNames().indexOf(property);
            TableItem item = (TableItem)element;
            IDOMElement node = (IDOMElement)item.getData();
            switch (columnIndex) {
                case 1: {
                    String valueString = ((String)value).trim();
                    ChangeAttributeCommand c = new ChangeAttributeCommand(SectionResources.getString("JSFHtmlInputTextSection.CommandLabel.ChangeAttribute"), node, "minimum", valueString);
                    c.execute();
                    break;
                }
                case 2: {
                    String valueString = ((String)value).trim();
                    ChangeAttributeCommand c = new ChangeAttributeCommand(SectionResources.getString("JSFHtmlInputTextSection.CommandLabel.ChangeAttribute"), node, "maximum", valueString);
                    c.execute();
                    break;
                }
            }
            JSFHtmlInputOthersSection.this._validatorsViewer.refresh();
            JSFHtmlInputOthersSection.this.updateValidateButtonStatus();
        }
    }

    private class ValidateContentLabelProvider
    implements IStructuredContentProvider,
    ITableLabelProvider {
        private ValidateContentLabelProvider() {
        }

        public Object[] getElements(Object inputElement) {
            IDOMElement root = JSFHtmlInputOthersSection.this._element;
            ArrayList<Node> result = new ArrayList<Node>();
            NodeList children = root.getChildNodes();
            int i = 0;
            int n = children.getLength();
            while (i < n) {
                IDOMElement element;
                String nodeName;
                Node child = children.item(i);
                if (child.getNodeType() == 1 && (nodeName = (element = (IDOMElement)child).getNodeName()).indexOf("validat") != -1) {
                    result.add(child);
                }
                ++i;
            }
            if (result.isEmpty()) {
                return new Object[0];
            }
            return result.toArray(new IDOMElement[result.size()]);
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public String getColumnText(Object element, int columnIndex) {
            String result = null;
            if (element instanceof IDOMElement) {
                IDOMElement node = (IDOMElement)element;
                String nodeName = node.getNodeName();
                switch (columnIndex) {
                    case 0: {
                        result = nodeName;
                        break;
                    }
                    case 1: {
                        result = node.getAttribute("minimum");
                        break;
                    }
                    case 2: {
                        result = node.getAttribute("maximum");
                        break;
                    }
                }
            }
            return result != null ? result : "";
        }

        public void dispose() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }
}

