/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.ui.internal.hyperlink;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.wst.xml.ui.internal.Logger;
import org.eclipse.wst.xml.ui.internal.XMLUIMessages;

class WorkspaceFileHyperlink
implements IHyperlink {
    private IRegion fRegion;
    private IFile fFile;
    private IRegion fHighlightRange;

    public WorkspaceFileHyperlink(IRegion region, IFile file) {
        this.fRegion = region;
        this.fFile = file;
    }

    public WorkspaceFileHyperlink(IRegion region, IFile file, IRegion range) {
        this.fRegion = region;
        this.fFile = file;
        this.fHighlightRange = range;
    }

    public IRegion getHyperlinkRegion() {
        return this.fRegion;
    }

    public String getTypeLabel() {
        return null;
    }

    public String getHyperlinkText() {
        String path = this.fFile.getFullPath().toString();
        if (path.length() > 60) {
            path = String.valueOf(path.substring(0, 25)) + "..." + path.substring(path.length() - 25, path.length());
        }
        String editorLabel = null;
        try {
            editorLabel = this.getEditorLabel();
        }
        catch (CoreException e) {
            Logger.logException(e);
        }
        if (editorLabel != null) {
            return NLS.bind((String)XMLUIMessages.Open_With, (Object)path, (Object)editorLabel);
        }
        return NLS.bind((String)XMLUIMessages.Open, (Object)path);
    }

    private String getEditorLabel() throws CoreException {
        IContentDescription description = this.fFile.getContentDescription();
        IEditorDescriptor defaultEditor = PlatformUI.getWorkbench().getEditorRegistry().getDefaultEditor(this.fFile.getName(), description != null ? description.getContentType() : null);
        return defaultEditor != null ? defaultEditor.getLabel() : null;
    }

    public void open() {
        if (this.fFile != null && this.fFile.exists()) {
            try {
                IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                IEditorPart editor = IDE.openEditor((IWorkbenchPage)page, (IFile)this.fFile, (boolean)true);
                if (this.fHighlightRange != null && editor instanceof ITextEditor) {
                    ((ITextEditor)editor).setHighlightRange(this.fHighlightRange.getOffset(), this.fHighlightRange.getLength(), true);
                }
            }
            catch (PartInitException pie) {
                Logger.log(202, pie.getMessage(), pie);
            }
        }
    }
}

