/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpadiagrameditor.ui.internal.relations;

import org.eclipse.jpt.jpa.core.context.PersistentAttribute;
import org.eclipse.jpt.jpa.core.context.PersistentType;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.provider.IJPAEditorFeatureProvider;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.relations.IRelation;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.relations.IUnidirectionalRelation;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.relations.ManyToOneRelation;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.util.JPAEditorUtil;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.util.JpaArtifactFactory;

public class ManyToOneUniDirRelation
extends ManyToOneRelation
implements IUnidirectionalRelation {
    public ManyToOneUniDirRelation(IJPAEditorFeatureProvider fp, PersistentType owner, PersistentType inverse, String ownerAttributeName, boolean createAttribs, boolean isDerivedIdFeature) {
        super(owner, inverse);
        this.ownerAttributeName = ownerAttributeName;
        if (createAttribs) {
            this.createRelation(fp, isDerivedIdFeature);
        }
    }

    @Override
    public PersistentAttribute getAnnotatedAttribute() {
        return this.ownerAnnotatedAttribute;
    }

    @Override
    public void setAnnotatedAttribute(PersistentAttribute annotatedAttribute) {
        this.ownerAnnotatedAttribute = annotatedAttribute;
    }

    private void createRelation(IJPAEditorFeatureProvider fp, boolean isDerivedIdFeature) {
        this.ownerAnnotatedAttribute = JPAEditorUtil.addAnnotatedAttribute(this.owner, this.inverse, false, null);
        JpaArtifactFactory.instance().addManyToOneUnidirectionalRelation(fp, this.owner, this.ownerAnnotatedAttribute);
        if (isDerivedIdFeature) {
            JpaArtifactFactory.instance().calculateDerivedIdAttribute(this.owner, this.inverse, this.ownerAnnotatedAttribute);
        }
    }

    @Override
    public IRelation.RelDir getRelDir() {
        return IRelation.RelDir.UNI;
    }
}

