/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.rename;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.RefactoringArguments;
import org.eclipse.ltk.core.refactoring.participants.RenameArguments;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IJavaScriptProject;
import org.eclipse.wst.jsdt.core.IPackageFragmentRoot;
import org.eclipse.wst.jsdt.core.JavaScriptCore;
import org.eclipse.wst.jsdt.core.refactoring.descriptors.JavaScriptRefactoringDescriptor;
import org.eclipse.wst.jsdt.core.refactoring.descriptors.RenameJavaScriptElementDescriptor;
import org.eclipse.wst.jsdt.internal.corext.refactoring.JDTRefactoringDescriptorComment;
import org.eclipse.wst.jsdt.internal.corext.refactoring.JavaRefactoringArguments;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringAvailabilityTester;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.wst.jsdt.internal.corext.refactoring.changes.DynamicValidationRefactoringChange;
import org.eclipse.wst.jsdt.internal.corext.refactoring.changes.RenameSourceFolderChange;
import org.eclipse.wst.jsdt.internal.corext.refactoring.code.ScriptableRefactoring;
import org.eclipse.wst.jsdt.internal.corext.refactoring.participants.JavaProcessors;
import org.eclipse.wst.jsdt.internal.corext.refactoring.rename.JavaRenameProcessor;
import org.eclipse.wst.jsdt.internal.corext.refactoring.rename.RenameModifications;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;

public final class RenameSourceFolderProcessor
extends JavaRenameProcessor {
    private static final String ATTRIBUTE_PATH = "path";
    private static final String ATTRIBUTE_NAME = "name";
    private IPackageFragmentRoot fSourceFolder;
    public static final String IDENTIFIER = "org.eclipse.wst.jsdt.ui.renameSourceFolderProcessor";

    public RenameSourceFolderProcessor(IPackageFragmentRoot root) {
        this.fSourceFolder = root;
        if (root != null) {
            this.setNewElementName(root.getElementName());
        }
    }

    public String getIdentifier() {
        return IDENTIFIER;
    }

    public boolean isApplicable() throws CoreException {
        return RefactoringAvailabilityTester.isRenameAvailable(this.fSourceFolder);
    }

    public String getProcessorName() {
        return RefactoringCoreMessages.RenameSourceFolderRefactoring_rename;
    }

    @Override
    protected String[] getAffectedProjectNatures() throws CoreException {
        return JavaProcessors.computeAffectedNatures((IJavaScriptElement)this.fSourceFolder);
    }

    @Override
    public Object[] getElements() {
        return new Object[]{this.fSourceFolder};
    }

    @Override
    public Object getNewElement() throws CoreException {
        IPackageFragmentRoot[] roots = this.fSourceFolder.getJavaScriptProject().getPackageFragmentRoots();
        int i = 0;
        while (i < roots.length) {
            if (roots[i].getElementName().equals(this.getNewElementName())) {
                return roots[i];
            }
            ++i;
        }
        return null;
    }

    @Override
    public int getSaveMode() {
        return 2;
    }

    @Override
    protected RenameModifications computeRenameModifications() throws CoreException {
        RenameModifications result = new RenameModifications();
        result.rename(this.fSourceFolder, new RenameArguments(this.getNewElementName(), this.getUpdateReferences()));
        return result;
    }

    @Override
    protected IFile[] getChangedFiles() throws CoreException {
        return new IFile[0];
    }

    @Override
    public String getCurrentElementName() {
        return this.fSourceFolder.getElementName();
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException {
        return new RefactoringStatus();
    }

    @Override
    public RefactoringStatus checkNewElementName(String newName) throws CoreException {
        IPath p;
        Assert.isNotNull((Object)newName, (String)"new name");
        if (!newName.trim().equals(newName)) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.RenameSourceFolderRefactoring_blank);
        }
        IContainer c = this.fSourceFolder.getResource().getParent();
        if (!c.getFullPath().isValidSegment(newName)) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.RenameSourceFolderRefactoring_invalid_name);
        }
        RefactoringStatus result = RefactoringStatus.create((IStatus)c.getWorkspace().validateName(newName, 2));
        if (result.hasFatalError()) {
            return result;
        }
        result.merge(RefactoringStatus.create((IStatus)c.getWorkspace().validatePath(this.createNewPath(newName), 2)));
        if (result.hasFatalError()) {
            return result;
        }
        IJavaScriptProject project = this.fSourceFolder.getJavaScriptProject();
        if (project.findPackageFragmentRoot(p = project.getProject().getFullPath().append(newName)) != null) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.RenameSourceFolderRefactoring_already_exists);
        }
        if (project.getProject().findMember((IPath)new Path(newName)) != null) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.RenameSourceFolderRefactoring_alread_exists);
        }
        return result;
    }

    private String createNewPath(String newName) {
        return this.fSourceFolder.getPath().removeLastSegments(1).append(newName).toString();
    }

    @Override
    protected RefactoringStatus doCheckFinalConditions(IProgressMonitor pm, CheckConditionsContext context) throws CoreException {
        pm.beginTask("", 1);
        try {
            RefactoringStatus refactoringStatus = new RefactoringStatus();
            return refactoringStatus;
        }
        finally {
            pm.done();
        }
    }

    public boolean getUpdateReferences() {
        return true;
    }

    public Change createChange(IProgressMonitor monitor) throws CoreException {
        monitor.beginTask(RefactoringCoreMessages.RenameTypeRefactoring_creating_change, 1);
        try {
            IResource resource = this.fSourceFolder.getResource();
            String project = resource.getProject().getName();
            String newName = this.getNewElementName();
            String description = Messages.format(RefactoringCoreMessages.RenameSourceFolderChange_descriptor_description_short, this.fSourceFolder.getElementName());
            String header = Messages.format(RefactoringCoreMessages.RenameSourceFolderChange_descriptor_description, new String[]{resource.getFullPath().toString(), newName});
            String comment = new JDTRefactoringDescriptorComment(project, this, header).asString();
            RenameJavaScriptElementDescriptor descriptor = new RenameJavaScriptElementDescriptor("org.eclipse.wst.jsdt.ui.rename.source.folder");
            descriptor.setProject(project);
            descriptor.setDescription(description);
            descriptor.setComment(comment);
            descriptor.setFlags(0);
            descriptor.setJavaElement((IJavaScriptElement)this.fSourceFolder);
            descriptor.setNewName(newName);
            DynamicValidationRefactoringChange dynamicValidationRefactoringChange = new DynamicValidationRefactoringChange((JavaScriptRefactoringDescriptor)descriptor, RefactoringCoreMessages.RenameSourceFolderRefactoring_rename, new Change[]{new RenameSourceFolderChange(this.fSourceFolder, newName)});
            return dynamicValidationRefactoringChange;
        }
        finally {
            monitor.done();
        }
    }

    @Override
    public RefactoringStatus initialize(RefactoringArguments arguments) {
        String name;
        if (arguments instanceof JavaRefactoringArguments) {
            IResource resource;
            JavaRefactoringArguments generic = (JavaRefactoringArguments)arguments;
            String path = generic.getAttribute(ATTRIBUTE_PATH);
            if (path != null) {
                resource = ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)new Path(path));
                if (resource == null || !resource.exists()) {
                    return ScriptableRefactoring.createInputFatalStatus(resource, this.getRefactoring().getName(), "org.eclipse.wst.jsdt.ui.rename.source.folder");
                }
            } else {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ATTRIBUTE_PATH));
            }
            this.fSourceFolder = (IPackageFragmentRoot)JavaScriptCore.create((IResource)resource);
            name = generic.getAttribute(ATTRIBUTE_NAME);
            if (name == null || "".equals(name)) {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ATTRIBUTE_NAME));
            }
        } else {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.InitializableRefactoring_inacceptable_arguments);
        }
        this.setNewElementName(name);
        return new RefactoringStatus();
    }
}

