/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.jaxws.utils.clazz;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jst.ws.jaxws.utils.ContractChecker;
import org.eclipse.jst.ws.jaxws.utils.resources.FileUtils;

public class ASTUtils {
    private static ASTUtils instance;

    private ASTUtils() {
    }

    public static ASTUtils getInstance() {
        if (instance == null) {
            instance = new ASTUtils();
        }
        return instance;
    }

    public ASTNode createAST(File sourceFile, IProgressMonitor monitor) throws IOException {
        ContractChecker.nullCheckParam(sourceFile, "sourceFile");
        ASTParser parser = ASTParser.newParser((int)3);
        parser.setSource(FileUtils.getInstance().getFileContent(sourceFile).toCharArray());
        return parser.createAST(monitor);
    }

    public CompilationUnit createCompilationUnit(ICompilationUnit sourceCu, IProgressMonitor monitor) {
        ContractChecker.nullCheckParam(sourceCu, "sourceCu");
        ASTParser parser = ASTParser.newParser((int)3);
        parser.setSource(sourceCu);
        parser.setBindingsRecovery(false);
        return (CompilationUnit)parser.createAST(monitor);
    }

    public FieldDeclaration getFieldDeclaration(IField fieldType, TypeDeclaration typeDeclaration) {
        FieldDeclaration[] fieldDeclarationArray = typeDeclaration.getFields();
        int n = fieldDeclarationArray.length;
        int n2 = 0;
        while (n2 < n) {
            FieldDeclaration fd = fieldDeclarationArray[n2];
            for (Object fr : fd.fragments()) {
                VariableDeclarationFragment vdf = (VariableDeclarationFragment)fr;
                if (!vdf.getName().getFullyQualifiedName().equals(fieldType.getElementName())) continue;
                return fd;
            }
            ++n2;
        }
        return null;
    }

    private boolean compareMethodParams(IMethod methodType, MethodDeclaration md) {
        List list = md.parameters();
        if (list.size() == methodType.getNumberOfParameters()) {
            String[] parameterTypes = methodType.getParameterTypes();
            int i = 0;
            while (i < list.size()) {
                if (!this.isSameParam(parameterTypes[i], (SingleVariableDeclaration)list.get(i))) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    private boolean isSameParam(String type, SingleVariableDeclaration svDecl) {
        return type.equals(this.getTypeSignature(svDecl));
    }

    public String getTypeSignature(SingleVariableDeclaration svDecl) {
        String typeName = this.createDimensionedTypeName(Signature.createTypeSignature((String)svDecl.getType().toString(), (boolean)false), svDecl.getExtraDimensions());
        if (svDecl.isVarargs()) {
            typeName = String.valueOf('[') + typeName;
        }
        return typeName;
    }

    private String createDimensionedTypeName(String typeName, int dimensions) {
        StringBuilder result = new StringBuilder(typeName);
        String dimensionString = this.createDimensionString(dimensions);
        while (!result.toString().startsWith(dimensionString)) {
            result.insert(0, '[');
        }
        return result.toString();
    }

    private String createDimensionString(int dimensions) {
        char[] dimensionChars = new char[dimensions];
        Arrays.fill(dimensionChars, '[');
        return new String(dimensionChars);
    }

    public MethodDeclaration getMethodDeclaration(IMethod methodType, TypeDeclaration typeDeclaration) {
        MethodDeclaration[] methodDeclarationArray = typeDeclaration.getMethods();
        int n = methodDeclarationArray.length;
        int n2 = 0;
        while (n2 < n) {
            MethodDeclaration md = methodDeclarationArray[n2];
            if (md.getName().getFullyQualifiedName().equals(methodType.getElementName()) && this.compareMethodParams(methodType, md)) {
                return md;
            }
            ++n2;
        }
        return null;
    }

    public AbstractTypeDeclaration getTypeDeclaration(String className, CompilationUnit unit) {
        AbstractTypeDeclaration typeDeclaration = null;
        for (Object typeObject : unit.types()) {
            AbstractTypeDeclaration tmpTypeDeclaration = (AbstractTypeDeclaration)typeObject;
            if (!tmpTypeDeclaration.getName().getFullyQualifiedName().equals(className)) continue;
            typeDeclaration = tmpTypeDeclaration;
            break;
        }
        if (typeDeclaration == null) {
            List list = unit.types();
            typeDeclaration = this.getInnerClass(list.toArray(new AbstractTypeDeclaration[list.size()]), className);
        }
        return typeDeclaration;
    }

    private AbstractTypeDeclaration getInnerClass(AbstractTypeDeclaration[] types, String className) {
        AbstractTypeDeclaration result = null;
        AbstractTypeDeclaration[] abstractTypeDeclarationArray = types;
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            AbstractTypeDeclaration abstractType = abstractTypeDeclarationArray[n2];
            if (abstractType.getName().getFullyQualifiedName().equals(className)) {
                return abstractType;
            }
            if (abstractType instanceof TypeDeclaration && (result = this.getInnerClass((AbstractTypeDeclaration[])((TypeDeclaration)abstractType).getTypes(), className)) != null) {
                return result;
            }
            ++n2;
        }
        return null;
    }
}

