/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.actions;

import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.wst.xsd.ui.internal.actions.MoveXSDBaseAction;
import org.eclipse.xsd.XSDAttributeDeclaration;
import org.eclipse.xsd.XSDAttributeGroupContent;
import org.eclipse.xsd.XSDAttributeGroupDefinition;
import org.eclipse.xsd.XSDAttributeUse;
import org.eclipse.xsd.XSDComplexTypeDefinition;
import org.eclipse.xsd.XSDConcreteComponent;
import org.eclipse.xsd.XSDElementDeclaration;
import org.w3c.dom.Node;

public class MoveXSDAttributeAction
extends MoveXSDBaseAction {
    private static int INSERT_BEFORE = 0;
    private static int INSERT_AFTER = 1;
    private static int INSERT_DIRECT = 2;
    protected List selectedNodes;
    protected Node parentNode;
    protected Node previousRefChild;
    protected Node nextRefChild;
    int insertType;
    XSDConcreteComponent parentComponent;
    XSDConcreteComponent selected;
    XSDConcreteComponent previousRefComponent;
    XSDConcreteComponent nextRefComponent;
    boolean insertAtEnd = true;

    public MoveXSDAttributeAction(XSDConcreteComponent parentComponent, XSDConcreteComponent selected, XSDConcreteComponent previousRefChildComponent, XSDConcreteComponent nextRefChildComponent) {
        this.parentComponent = parentComponent;
        this.selected = selected;
        this.previousRefComponent = previousRefChildComponent;
        this.nextRefComponent = nextRefChildComponent;
        if (parentComponent == null) {
            return;
        }
        this.parentNode = parentComponent.getElement();
        this.nextRefChild = nextRefChildComponent != null ? nextRefChildComponent.getElement() : null;
        Node node = this.previousRefChild = previousRefChildComponent != null ? previousRefChildComponent.getElement() : null;
        if (this.nextRefComponent != null && this.nextRefComponent.getContainer().getContainer() == parentComponent) {
            this.insertType = INSERT_BEFORE;
        }
        if (this.previousRefComponent != null && this.previousRefComponent.getContainer().getContainer() == parentComponent) {
            this.insertType = INSERT_AFTER;
        }
        if (nextRefChildComponent == null && previousRefChildComponent == null) {
            this.insertType = INSERT_DIRECT;
        }
    }

    public MoveXSDAttributeAction(XSDConcreteComponent parentComponent, XSDConcreteComponent selected, XSDConcreteComponent previousRefChildComponent, XSDConcreteComponent nextRefChildComponent, boolean insertAtEnd) {
        this(parentComponent, selected, previousRefChildComponent, nextRefChildComponent);
        this.insertAtEnd = insertAtEnd;
    }

    public boolean canMove() {
        boolean result = true;
        if (this.nextRefComponent instanceof XSDElementDeclaration || this.previousRefComponent instanceof XSDElementDeclaration || this.parentComponent == null) {
            return false;
        }
        return result;
    }

    public void run() {
        if (this.parentComponent instanceof XSDAttributeGroupDefinition) {
            this.moveUnderXSDAttributeGroupDefinition((XSDAttributeGroupDefinition)this.parentComponent);
        } else if (this.parentComponent instanceof XSDComplexTypeDefinition) {
            this.moveUnderXSDComplexTypeDefinition((XSDComplexTypeDefinition)this.parentComponent);
        }
    }

    protected void moveUnderXSDAttributeGroupDefinition(XSDAttributeGroupDefinition parentGroup) {
        int originalIndex = 0;
        Iterator iterator = parentGroup.getContents().iterator();
        while (iterator.hasNext()) {
            XSDAttributeDeclaration attribute;
            XSDAttributeGroupContent attributeGroupContent = (XSDAttributeGroupContent)iterator.next();
            if (attributeGroupContent instanceof XSDAttributeUse && (attribute = ((XSDAttributeUse)attributeGroupContent).getContent()) == this.selected) {
                parentGroup.getContents().remove((Object)attribute.getContainer());
                break;
            }
            ++originalIndex;
        }
        int index = 0;
        boolean addedBack = false;
        if (this.insertType == INSERT_DIRECT) {
            XSDConcreteComponent container = this.selected.getContainer();
            if (container != null) {
                if (this.insertAtEnd) {
                    ((XSDAttributeGroupDefinition)this.parentComponent).getResolvedAttributeGroupDefinition().getContents().add((Object)container);
                } else {
                    ((XSDAttributeGroupDefinition)this.parentComponent).getResolvedAttributeGroupDefinition().getContents().add(0, (Object)container);
                }
                addedBack = true;
            }
            return;
        }
        EList attributeGroupContents = parentGroup.getContents();
        Iterator iterator2 = attributeGroupContents.iterator();
        while (iterator2.hasNext()) {
            XSDAttributeGroupContent attributeGroupContent = (XSDAttributeGroupContent)iterator2.next();
            if (attributeGroupContent instanceof XSDAttributeUse) {
                XSDAttributeDeclaration attribute = ((XSDAttributeUse)attributeGroupContent).getContent();
                if (this.insertType == INSERT_BEFORE) {
                    if (attribute == this.nextRefComponent) {
                        parentGroup.getContents().add(index, (Object)this.selected.getContainer());
                        addedBack = true;
                        break;
                    }
                    if (this.selected == this.nextRefComponent && originalIndex == index) {
                        parentGroup.getContents().add(index, (Object)this.selected.getContainer());
                        addedBack = true;
                        break;
                    }
                } else if (this.insertType == INSERT_AFTER) {
                    if (attribute == this.previousRefComponent) {
                        parentGroup.getContents().add(index + 1, (Object)this.selected.getContainer());
                        addedBack = true;
                        break;
                    }
                    if (this.selected == this.previousRefComponent && originalIndex == index) {
                        parentGroup.getContents().add(index, (Object)this.selected.getContainer());
                        addedBack = true;
                        break;
                    }
                }
            }
            ++index;
        }
        if (attributeGroupContents.size() == 0) {
            parentGroup.getContents().add((Object)this.selected.getContainer());
            addedBack = true;
        }
        if (!addedBack) {
            parentGroup.getContents().add(originalIndex, (Object)this.selected.getContainer());
        }
    }

    protected void moveUnderXSDComplexTypeDefinition(XSDComplexTypeDefinition complexType) {
        int originalIndex = 0;
        Iterator iterator = complexType.getAttributeContents().iterator();
        while (iterator.hasNext()) {
            XSDAttributeDeclaration attribute;
            XSDAttributeGroupContent attributeGroupContent = (XSDAttributeGroupContent)iterator.next();
            if (attributeGroupContent instanceof XSDAttributeUse && (attribute = ((XSDAttributeUse)attributeGroupContent).getContent()) == this.selected) {
                complexType.getAttributeContents().remove((Object)attribute.getContainer());
                break;
            }
            ++originalIndex;
        }
        int index = 0;
        boolean addedBack = false;
        EList attributeGroupContents = complexType.getAttributeContents();
        Iterator iterator2 = attributeGroupContents.iterator();
        while (iterator2.hasNext()) {
            XSDAttributeGroupContent attributeGroupContent = (XSDAttributeGroupContent)iterator2.next();
            if (attributeGroupContent instanceof XSDAttributeUse) {
                XSDAttributeDeclaration attribute = ((XSDAttributeUse)attributeGroupContent).getContent();
                if (this.insertType == INSERT_AFTER) {
                    if (attribute == this.previousRefComponent) {
                        complexType.getAttributeContents().add(index + 1, (Object)this.selected.getContainer());
                        addedBack = true;
                        break;
                    }
                } else if (this.insertType == INSERT_BEFORE && attribute == this.nextRefComponent) {
                    complexType.getAttributeContents().add(index, (Object)this.selected.getContainer());
                    addedBack = true;
                    break;
                }
            }
            ++index;
        }
        if (attributeGroupContents.size() == 0) {
            complexType.getAttributeContents().add((Object)this.selected.getContainer());
            addedBack = true;
        }
        if (!addedBack) {
            complexType.getAttributeContents().add(originalIndex, (Object)this.selected.getContainer());
        }
    }
}

