/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.facesconfig.tests.write;

import org.eclipse.jst.jsf.facesconfig.emf.AttributeType;
import org.eclipse.jst.jsf.facesconfig.emf.ComponentClassType;
import org.eclipse.jst.jsf.facesconfig.emf.ComponentExtensionType;
import org.eclipse.jst.jsf.facesconfig.emf.ComponentType;
import org.eclipse.jst.jsf.facesconfig.emf.ComponentTypeType;
import org.eclipse.jst.jsf.facesconfig.emf.DescriptionType;
import org.eclipse.jst.jsf.facesconfig.emf.DisplayNameType;
import org.eclipse.jst.jsf.facesconfig.emf.DynamicElement;
import org.eclipse.jst.jsf.facesconfig.emf.FacesConfigFactory;
import org.eclipse.jst.jsf.facesconfig.emf.FacesConfigPackage;
import org.eclipse.jst.jsf.facesconfig.emf.FacetType;
import org.eclipse.jst.jsf.facesconfig.emf.IconType;
import org.eclipse.jst.jsf.facesconfig.emf.PropertyType;
import org.eclipse.jst.jsf.facesconfig.tests.util.CommonStructuresUtil;
import org.eclipse.jst.jsf.facesconfig.tests.write.BaseWriteTestCase;
import org.eclipse.jst.jsf.facesconfig.util.FacesConfigArtifactEdit;

public class WriteComponentTestCase
extends BaseWriteTestCase {
    private static final String COMPONENT = "component";
    private static final String COMPONENT_CLASS = "component-class";
    private static final String COMPONENT_TYPE = "component-type";

    public WriteComponentTestCase(String name) {
        super(name);
    }

    public void testWriteComponent() {
        FacesConfigArtifactEdit edit = null;
        try {
            edit = this.getArtifactEditForWrite();
            WriteComponentTestCase.assertNotNull((Object)edit.getFacesConfig());
            FacesConfigPackage facesConfigPackage = FacesConfigPackage.eINSTANCE;
            FacesConfigFactory facesConfigFactory = facesConfigPackage.getFacesConfigFactory();
            ComponentType newComponent = facesConfigFactory.createComponentType();
            newComponent.getDescription().add((Object)CommonStructuresUtil.createDescription(COMPONENT));
            newComponent.getDisplayName().add((Object)CommonStructuresUtil.createDisplayName(COMPONENT));
            newComponent.getIcon().add((Object)CommonStructuresUtil.createIcon(COMPONENT));
            ComponentTypeType componentTypeType = facesConfigFactory.createComponentTypeType();
            componentTypeType.setTextContent(COMPONENT_TYPE);
            componentTypeType.setId(CommonStructuresUtil.createPreficedString(COMPONENT_TYPE, "id"));
            newComponent.setComponentType(componentTypeType);
            ComponentClassType componentClassType = facesConfigFactory.createComponentClassType();
            componentClassType.setTextContent(COMPONENT_CLASS);
            componentClassType.setId(CommonStructuresUtil.createPreficedString(COMPONENT_CLASS, "id"));
            newComponent.setComponentClass(componentClassType);
            newComponent.getAttribute().add((Object)CommonStructuresUtil.createAttribute(COMPONENT));
            newComponent.getProperty().add((Object)CommonStructuresUtil.createProperty(COMPONENT));
            newComponent.getFacet().add((Object)CommonStructuresUtil.createFacet(COMPONENT));
            ComponentExtensionType ext = facesConfigFactory.createComponentExtensionType();
            DynamicElement element = facesConfigFactory.createDynamicElement();
            element.setName("some-meta-data");
            ext.getChildNodes().add((Object)element);
            newComponent.getComponentExtension().add((Object)ext);
            edit.getFacesConfig().getComponent().add((Object)newComponent);
            edit.save(null);
        }
        finally {
            if (edit != null) {
                edit.dispose();
                WriteComponentTestCase.assertTrue((boolean)edit.isDisposed());
                edit = null;
            }
        }
        try {
            edit = this.getArtifactEditForRead();
            WriteComponentTestCase.assertNotNull((Object)edit.getFacesConfig());
            WriteComponentTestCase.assertEquals((int)1, (int)edit.getFacesConfig().getComponent().size());
            ComponentType component = (ComponentType)edit.getFacesConfig().getComponent().get(0);
            WriteComponentTestCase.assertEquals((int)1, (int)component.getDescription().size());
            CommonStructuresUtil.assertMatchesDescription(COMPONENT, (DescriptionType)component.getDescription().get(0));
            WriteComponentTestCase.assertEquals((int)1, (int)component.getDisplayName().size());
            CommonStructuresUtil.assertMatchesDisplayName(COMPONENT, (DisplayNameType)component.getDisplayName().get(0));
            WriteComponentTestCase.assertEquals((int)1, (int)component.getIcon().size());
            CommonStructuresUtil.assertMatchesIcon(COMPONENT, (IconType)component.getIcon().get(0));
            ComponentTypeType componentTypeType = component.getComponentType();
            WriteComponentTestCase.assertEquals((String)COMPONENT_TYPE, (String)componentTypeType.getTextContent());
            WriteComponentTestCase.assertEquals((String)CommonStructuresUtil.createPreficedString(COMPONENT_TYPE, "id"), (String)componentTypeType.getId());
            ComponentClassType componentClassType = component.getComponentClass();
            WriteComponentTestCase.assertEquals((String)COMPONENT_CLASS, (String)componentClassType.getTextContent());
            WriteComponentTestCase.assertEquals((String)CommonStructuresUtil.createPreficedString(COMPONENT_CLASS, "id"), (String)componentClassType.getId());
            WriteComponentTestCase.assertEquals((int)1, (int)component.getAttribute().size());
            CommonStructuresUtil.assertMatchAttribute(COMPONENT, (AttributeType)component.getAttribute().get(0));
            WriteComponentTestCase.assertEquals((int)1, (int)component.getProperty().size());
            CommonStructuresUtil.assertMatchProperty(COMPONENT, (PropertyType)component.getProperty().get(0));
            WriteComponentTestCase.assertEquals((int)1, (int)component.getFacet().size());
            CommonStructuresUtil.assertMatchFacet(COMPONENT, (FacetType)component.getFacet().get(0));
            WriteComponentTestCase.assertEquals((int)1, (int)component.getComponentExtension().size());
            ComponentExtensionType ext = (ComponentExtensionType)component.getComponentExtension().get(0);
            WriteComponentTestCase.assertEquals((int)1, (int)ext.getChildNodes().size());
            DynamicElement element = (DynamicElement)ext.getChildNodes().get(0);
            WriteComponentTestCase.assertEquals((String)"some-meta-data", (String)element.getName());
        }
        finally {
            if (edit != null) {
                edit.dispose();
            }
        }
    }
}

