/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.chromium.internal.v8native;

import org.eclipse.wst.jsdt.chromium.Breakpoint;
import org.eclipse.wst.jsdt.chromium.BreakpointTypeExtension;
import org.eclipse.wst.jsdt.chromium.IgnoreCountBreakpointExtension;
import org.eclipse.wst.jsdt.chromium.JavascriptVm;
import org.eclipse.wst.jsdt.chromium.RelayOk;
import org.eclipse.wst.jsdt.chromium.SyncCallback;
import org.eclipse.wst.jsdt.chromium.internal.ScriptRegExpBreakpointTarget;
import org.eclipse.wst.jsdt.chromium.internal.v8native.BreakpointManager;
import org.eclipse.wst.jsdt.chromium.internal.v8native.DebugSession;
import org.eclipse.wst.jsdt.chromium.internal.v8native.JavascriptVmImpl;
import org.eclipse.wst.jsdt.chromium.internal.v8native.V8CommandCallbackBase;
import org.eclipse.wst.jsdt.chromium.internal.v8native.protocol.input.FailedCommandResponse;
import org.eclipse.wst.jsdt.chromium.internal.v8native.protocol.input.SuccessCommandResponse;
import org.eclipse.wst.jsdt.chromium.internal.v8native.protocol.input.data.BreakpointInfo;
import org.eclipse.wst.jsdt.chromium.internal.v8native.protocol.output.ChangeBreakpointMessage;
import org.eclipse.wst.jsdt.chromium.util.GenericCallback;
import org.eclipse.wst.jsdt.chromium.util.RelaySyncCallback;

public class BreakpointImpl
implements Breakpoint {
    private Breakpoint.Target target;
    private long id;
    private long lineNumber;
    private boolean isEnabled;
    private String condition;
    private final BreakpointManager breakpointManager;
    private volatile boolean isDirty = false;
    static final IgnoreCountBreakpointExtension IGNORE_COUNT_EXTENSION = new IgnoreCountBreakpointExtension(){

        @Override
        public RelayOk setBreakpoint(JavascriptVm javascriptVm, Breakpoint.Target target, int line, int column, boolean enabled, String condition, int ignoreCount, JavascriptVm.BreakpointCallback callback, SyncCallback syncCallback) {
            JavascriptVmImpl javascriptVmImpl = (JavascriptVmImpl)javascriptVm;
            BreakpointManager breakpointManager = javascriptVmImpl.getDebugSession().getBreakpointManager();
            return breakpointManager.setBreakpoint(target, line, column, enabled, condition, ignoreCount, callback, syncCallback);
        }

        @Override
        public RelayOk setIgnoreCount(Breakpoint breakpoint, int ignoreCount, GenericCallback<Void> callback, SyncCallback syncCallback) {
            BreakpointImpl breakpointImpl = (BreakpointImpl)breakpoint;
            return breakpointImpl.setIgnoreCount(ignoreCount, callback, syncCallback);
        }
    };

    public BreakpointImpl(long id, Breakpoint.Target target, long lineNumber, boolean enabled, String condition, BreakpointManager breakpointManager) {
        this.target = target;
        this.id = id;
        this.isEnabled = enabled;
        this.condition = condition;
        this.lineNumber = lineNumber;
        this.breakpointManager = breakpointManager;
    }

    public BreakpointImpl(BreakpointInfo info, BreakpointManager breakpointManager) {
        this.target = BreakpointImpl.getType(info);
        this.id = info.number();
        this.breakpointManager = breakpointManager;
        this.updateFromRemote(info);
    }

    public void updateFromRemote(BreakpointInfo info) {
        if (this.id != info.number()) {
            throw new IllegalArgumentException();
        }
        this.lineNumber = info.line();
        this.isEnabled = info.active();
        this.condition = info.condition();
    }

    @Override
    public boolean isEnabled() {
        return this.isEnabled;
    }

    @Override
    public Breakpoint.Target getTarget() {
        return this.target;
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public String getCondition() {
        return this.condition;
    }

    @Override
    public long getLineNumber() {
        return this.lineNumber;
    }

    @Override
    public void setEnabled(boolean enabled) {
        if (this.isEnabled != enabled) {
            this.setDirty(true);
        }
        this.isEnabled = enabled;
    }

    private RelayOk setIgnoreCount(int ignoreCount, final GenericCallback<Void> callback, SyncCallback syncCallback) {
        ChangeBreakpointMessage message = new ChangeBreakpointMessage(this.id, ignoreCount);
        V8CommandCallbackBase wrappedCallback = callback == null ? null : new V8CommandCallbackBase(){

            @Override
            public void success(SuccessCommandResponse successResponse) {
                callback.success(null);
            }

            @Override
            public void failure(String message, FailedCommandResponse.ErrorDetails errorDetails) {
                callback.failure(new Exception(message));
            }
        };
        DebugSession debugSession = this.breakpointManager.getDebugSession();
        return debugSession.sendMessageAsync(message, true, wrappedCallback, syncCallback);
    }

    @Override
    public void setCondition(String condition) {
        if (!BreakpointImpl.eq(this.condition, condition)) {
            this.setDirty(true);
        }
        this.condition = condition;
    }

    private static <T> boolean eq(T left, T right) {
        return left == right || left != null && left.equals(right);
    }

    @Override
    public RelayOk clear(JavascriptVm.BreakpointCallback callback, SyncCallback syncCallback) {
        long originalId = this.id;
        this.id = -1L;
        return this.breakpointManager.clearBreakpoint(this, callback, syncCallback, originalId);
    }

    @Override
    public RelayOk flush(JavascriptVm.BreakpointCallback callback, SyncCallback syncCallback) {
        if (!this.isDirty()) {
            if (callback != null) {
                callback.success(this);
            }
            return RelaySyncCallback.finish(syncCallback);
        }
        this.setDirty(false);
        return this.breakpointManager.changeBreakpoint(this, callback, syncCallback);
    }

    @Override
    public IgnoreCountBreakpointExtension getIgnoreCountBreakpointExtension() {
        JavascriptVm javascriptVm = this.breakpointManager.getDebugSession().getJavascriptVm();
        return javascriptVm.getIgnoreCountBreakpointExtension();
    }

    private void setDirty(boolean isDirty) {
        this.isDirty = isDirty;
    }

    private boolean isDirty() {
        return this.isDirty;
    }

    private static Breakpoint.Target getType(BreakpointInfo info) {
        BreakpointInfo.Type infoType = info.type();
        switch (infoType) {
            case SCRIPTID: {
                return new Breakpoint.Target.ScriptId(info.script_id());
            }
            case SCRIPTNAME: {
                return new Breakpoint.Target.ScriptName(info.script_name());
            }
            case SCRIPTREGEXP: {
                return new ScriptRegExpBreakpointTarget(info.script_regexp());
            }
            case FUNCTION: {
                return new FunctionTarget(null);
            }
        }
        throw new RuntimeException("Unknown type: " + (Object)((Object)infoType));
    }

    static class FunctionTarget
    extends Breakpoint.Target {
        private final String expression;

        FunctionTarget(String expression) {
            this.expression = expression;
        }

        @Override
        public <R> R accept(Breakpoint.Target.Visitor<R> visitor) {
            if (visitor instanceof BreakpointTypeExtension.FunctionSupport.Visitor) {
                BreakpointTypeExtension.FunctionSupport.Visitor functionVisitor = (BreakpointTypeExtension.FunctionSupport.Visitor)visitor;
                return functionVisitor.visitFunction(this.expression);
            }
            return visitor.visitUnknown(this);
        }
    }

    public static interface TargetExtendedVisitor<R>
    extends BreakpointTypeExtension.FunctionSupport.Visitor<R>,
    BreakpointTypeExtension.ScriptRegExpSupport.Visitor<R> {
    }
}

