/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsi.internal.core.monitor.config.impl;

import java.io.PrintWriter;
import java.io.StringWriter;
import org.eclipse.wst.wsi.internal.core.WSIException;
import org.eclipse.wst.wsi.internal.core.common.AddStyleSheet;
import org.eclipse.wst.wsi.internal.core.common.impl.AddStyleSheetImpl;
import org.eclipse.wst.wsi.internal.core.monitor.config.Comment;
import org.eclipse.wst.wsi.internal.core.monitor.config.ManInTheMiddle;
import org.eclipse.wst.wsi.internal.core.monitor.config.MonitorConfig;
import org.eclipse.wst.wsi.internal.core.monitor.config.impl.CommentImpl;
import org.eclipse.wst.wsi.internal.core.monitor.config.impl.ManInTheMiddleImpl;
import org.eclipse.wst.wsi.internal.core.monitor.config.impl.MonitorConfigReaderImpl;
import org.eclipse.wst.wsi.internal.core.monitor.config.impl.RedirectImpl;
import org.eclipse.wst.wsi.internal.core.util.MessageList;

public class MonitorConfigImpl
implements MonitorConfig {
    protected MessageList messageList = null;
    protected String documentURI = null;
    protected Comment comment = null;
    protected String logURI;
    protected boolean replaceLog = false;
    protected AddStyleSheet addStyleSheet;
    protected int logDuration = 600;
    protected int timeout = 3;
    protected ManInTheMiddle manInTheMiddle = null;
    protected boolean verbose = false;

    @Override
    public void init(MessageList messageList) {
        this.messageList = messageList;
    }

    @Override
    public Comment getComment() {
        return this.comment;
    }

    @Override
    public void setComment(Comment comment) {
        this.comment = comment;
    }

    @Override
    public String getLogLocation() {
        return this.logURI;
    }

    @Override
    public void setLogLocation(String logURI) {
        this.logURI = logURI;
    }

    @Override
    public boolean getReplaceLog() {
        return this.replaceLog;
    }

    @Override
    public void setReplaceLog(boolean replaceLog) {
        this.replaceLog = replaceLog;
    }

    @Override
    public AddStyleSheet getAddStyleSheet() {
        return this.addStyleSheet;
    }

    @Override
    public void setAddStyleSheet(AddStyleSheet addStyleSheet) {
        this.addStyleSheet = addStyleSheet;
    }

    @Override
    public int getLogDuration() {
        return this.logDuration;
    }

    @Override
    public void setLogDuration(int logDuration) {
        this.logDuration = logDuration;
    }

    @Override
    public int getTimeout() {
        return this.timeout;
    }

    @Override
    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    @Override
    public ManInTheMiddle getManInTheMiddle() {
        return this.manInTheMiddle;
    }

    @Override
    public void setManInTheMiddle(ManInTheMiddle manInTheMiddle) {
        this.manInTheMiddle = manInTheMiddle;
    }

    @Override
    public String getLocation() {
        return this.documentURI;
    }

    @Override
    public void setLocation(String documentURI) {
        this.documentURI = documentURI;
    }

    @Override
    public boolean getVerboseOption() {
        return this.verbose;
    }

    @Override
    public void setVerboseOption(boolean verbose) {
        this.verbose = verbose;
    }

    @Override
    public String toXMLString(String namespaceName) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        String nsName = namespaceName;
        if (!nsName.equals("") && !nsName.endsWith(":")) {
            nsName = String.valueOf(nsName) + ":";
        }
        pw.println("    <" + nsName + "configuration" + ">");
        if (this.comment != null) {
            pw.print(this.comment.toXMLString(nsName));
        }
        pw.print("      <" + nsName + "logFile" + " ");
        pw.print("replace=\"" + this.replaceLog + "\" ");
        pw.println("location=\"" + this.logURI + "\">");
        pw.print(this.getAddStyleSheet().toXMLString(namespaceName));
        pw.println("    </" + nsName + "logFile" + ">");
        pw.print("      <" + nsName + "logDuration" + ">");
        pw.print(this.logDuration);
        pw.println("</" + nsName + "logDuration" + ">");
        pw.print("      <" + nsName + "cleanupTimeoutSeconds" + ">");
        pw.print(this.timeout);
        pw.println("</" + nsName + "cleanupTimeoutSeconds" + ">");
        if (this.manInTheMiddle != null) {
            pw.print(this.manInTheMiddle.toXMLString(nsName));
        }
        pw.println("    </" + nsName + "configuration" + ">");
        return sw.toString();
    }

    public String toString() {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        pw.println("  comment ..................... " + this.comment);
        pw.println("  logURI ...................... " + this.logURI);
        pw.println("  replaceLog .................. " + this.replaceLog);
        pw.println("  logDuration ................. " + this.logDuration);
        pw.println("  timeout ..................... " + this.timeout);
        if (this.addStyleSheet != null) {
            pw.println("  addStyleSheet ............... " + this.addStyleSheet.toString());
        }
        if (this.manInTheMiddle != null) {
            pw.print(this.manInTheMiddle.toString());
        }
        return sw.toString();
    }

    private void setConfig(MonitorConfig monitorConfig) {
        this.comment = monitorConfig.getComment();
        this.documentURI = monitorConfig.getLocation();
        this.logURI = monitorConfig.getLogLocation();
        this.replaceLog = monitorConfig.getReplaceLog();
        this.logDuration = monitorConfig.getLogDuration();
        this.timeout = monitorConfig.getTimeout();
        this.manInTheMiddle = monitorConfig.getManInTheMiddle();
        this.addStyleSheet = monitorConfig.getAddStyleSheet();
        this.verbose = monitorConfig.getVerboseOption();
    }

    private void verifyConfig() throws WSIException {
        if (this.manInTheMiddle == null || this.manInTheMiddle.getRedirectList() == null || this.manInTheMiddle.getRedirectList().size() == 0) {
            throw new IllegalArgumentException(this.getMessage("config05", "Monitor config file did not contain any redirect statements."));
        }
        if (this.logURI == null) {
            throw new IllegalArgumentException(this.getMessage("config06", "Monitor config file did not contain the log file URI."));
        }
    }

    @Override
    public void parseArgs(String[] args) throws WSIException {
        MonitorConfigReaderImpl monitorConfigReader = new MonitorConfigReaderImpl();
        MonitorConfig monitorConfigFromArgs = null;
        if (args.length == 0) {
            throw new IllegalArgumentException(this.getMessage("usage01", "Usage: Monitor -config <configFilename>"));
        }
        int argCount = 0;
        while (argCount < args.length) {
            if (args[argCount].equalsIgnoreCase("-config") || args[argCount].equals("-c")) {
                monitorConfigFromArgs = monitorConfigReader.readMonitorConfig(args[++argCount]);
            }
            ++argCount;
        }
        if (monitorConfigFromArgs == null) {
            monitorConfigFromArgs = new MonitorConfigImpl();
            monitorConfigFromArgs.init(this.messageList);
        }
        argCount = 0;
        while (argCount < args.length) {
            if (args[argCount].equalsIgnoreCase("-config") || args[argCount].equals("-c")) {
                ++argCount;
            } else if (args[argCount].equalsIgnoreCase("-comment") || args[argCount].equals("-C")) {
                CommentImpl comment = new CommentImpl();
                comment.setText(args[++argCount]);
                monitorConfigFromArgs.setComment(comment);
            } else if (args[argCount].equalsIgnoreCase("-logFile") || args[argCount].equals("-l")) {
                monitorConfigFromArgs.setLogLocation(args[++argCount]);
            } else if (args[argCount].equalsIgnoreCase("-replace") || args[argCount].equals("-r")) {
                monitorConfigFromArgs.setReplaceLog(Boolean.valueOf(args[++argCount]));
            } else if (args[argCount].equalsIgnoreCase("-logDuration") || args[argCount].equals("-d")) {
                monitorConfigFromArgs.setLogDuration(Integer.valueOf(args[++argCount]));
            } else if (args[argCount].equalsIgnoreCase("-timeout") || args[argCount].equals("-t")) {
                monitorConfigFromArgs.setTimeout(Integer.valueOf(args[++argCount]));
            } else if (args[argCount].equalsIgnoreCase("-manInTheMiddle") || args[argCount].equals("-m")) {
                ManInTheMiddle manInTheMiddle = null;
                ++argCount;
                manInTheMiddle = monitorConfigFromArgs.getManInTheMiddle();
                if (manInTheMiddle == null) {
                    manInTheMiddle = new ManInTheMiddleImpl();
                }
                RedirectImpl redirect = new RedirectImpl();
                redirect.setListenPort(Integer.valueOf(args[argCount++]));
                redirect.setHost(args[argCount++]);
                redirect.setMaxConnections(Integer.valueOf(args[argCount++]));
                redirect.setReadTimeoutSeconds(Integer.valueOf(args[argCount++]));
                manInTheMiddle.addRedirect(redirect);
                monitorConfigFromArgs.setManInTheMiddle(manInTheMiddle);
            } else if (args[argCount].equalsIgnoreCase("-verbose") || args[argCount].equals("-v")) {
                ++argCount;
                monitorConfigFromArgs.setVerboseOption(true);
            } else if (!args[argCount].equalsIgnoreCase("-GUI")) {
                throw new IllegalArgumentException(this.getMessage("config01", args[argCount], "The specified option is not supported."));
            }
            ++argCount;
        }
        if (monitorConfigFromArgs.getAddStyleSheet() == null) {
            AddStyleSheetImpl addStyleSheet = new AddStyleSheetImpl();
            addStyleSheet.setHref("../common/xsl/log.xsl");
            addStyleSheet.setType("text/xsl");
            addStyleSheet.setComment(true);
            monitorConfigFromArgs.setAddStyleSheet(addStyleSheet);
        }
        this.setConfig(monitorConfigFromArgs);
        this.verifyConfig();
    }

    private String getMessage(String messageID, String defaultMessage) {
        return this.getMessage(messageID, null, defaultMessage);
    }

    private String getMessage(String messageID, String messageData, String defaultMessage) {
        String message = defaultMessage;
        message = this.messageList != null ? this.messageList.getMessage(messageID, messageData, defaultMessage) : String.valueOf(message) + " " + messageData + ".";
        return message;
    }
}

