/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsi.ui.internal.actions.actionDelegates;

import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.dialogs.ContainerGenerator;
import org.eclipse.wst.internet.monitor.core.internal.provisional.Request;
import org.eclipse.wst.internet.monitor.ui.internal.provisional.MonitorUICore;
import org.eclipse.wst.wsi.internal.core.log.Log;
import org.eclipse.wst.wsi.internal.core.log.LogBuilder;
import org.eclipse.wst.wsi.ui.internal.Messages;
import org.eclipse.wst.wsi.ui.internal.WSIValidator;
import org.eclipse.wst.wsi.ui.internal.actions.actionDelegates.RequestHandlerImpl;
import org.eclipse.wst.wsi.ui.internal.wizards.ValidationWizard;

public class ValidateWSIProfileActionDelegate
implements IViewActionDelegate {
    public static final String DEFAULT_LOG_FILENAME = "log.wsimsg";
    private final String HTTP = "http://";
    private final String WSDL = "?WSDL";
    ISelection selection;
    Request[] requestResponses;
    IViewPart view;

    public void init(IViewPart view) {
        this.view = view;
    }

    public void run(IAction action) {
        WorkspaceModifyOperation operation = new WorkspaceModifyOperation(){

            protected void execute(IProgressMonitor progressMonitor) throws CoreException {
                ValidateWSIProfileActionDelegate.this.validate(progressMonitor);
            }
        };
        try {
            operation.run(null);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void validate(IProgressMonitor progressMonitor) {
        try {
            this.requestResponses = MonitorUICore.getRequests();
            Shell shell = Display.getCurrent().getActiveShell();
            if (this.requestResponses != null && this.requestResponses.length > 0) {
                ValidationWizard validateWizard = new ValidationWizard(DEFAULT_LOG_FILENAME);
                Vector<String> wsdllocs = new Vector<String>();
                int i = 0;
                while (i < this.requestResponses.length) {
                    Request reqresp = this.requestResponses[i];
                    String remotehost = reqresp.getRemoteHost();
                    int remoteport = reqresp.getRemotePort();
                    String remotelabel = reqresp.getName();
                    String location = "http://" + remotehost + ":" + remoteport + remotelabel + "?WSDL";
                    if (!wsdllocs.contains(location)) {
                        wsdllocs.add(location);
                    }
                    ++i;
                }
                validateWizard.setWSDLLocations(wsdllocs.toArray(new String[wsdllocs.size()]));
                WizardDialog wizardDialog = new WizardDialog(shell, (IWizard)validateWizard);
                wizardDialog.create();
                int result = wizardDialog.open();
                if (validateWizard.isValid() && result != 1) {
                    ValidateWSIProfileActionDelegate.checkAndCreateContainer(validateWizard.getContainerFullPath());
                    IFile file = validateWizard.getFile();
                    LogBuilder builder = new LogBuilder(file);
                    Log log = builder.buildLog(this.getRequestHandlers(this.requestResponses));
                    builder.writeLog(log);
                    file.refreshLocal(1, progressMonitor);
                    WSIValidator messageValidator = new WSIValidator();
                    if (validateWizard.includeWSDLFile()) {
                        String wsdlfile = validateWizard.getWSDLFile();
                        String name = validateWizard.getElementName();
                        String namespace = validateWizard.getNamespace();
                        String parentname = validateWizard.getParentName();
                        String type = validateWizard.getType();
                        messageValidator.validate(file, wsdlfile, name, namespace, parentname, type);
                    } else {
                        messageValidator.validate(file);
                    }
                }
            } else {
                String title = Messages.ACTION_WSI_VALIDATOR;
                String message = Messages.INFO_NO_MESSAGES_TO_VALIDATE;
                MessageDialog.openInformation((Shell)shell, (String)title, (String)message);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private List getRequestHandlers(Request[] requestResponses) {
        ArrayList<RequestHandlerImpl> requestHandlers = new ArrayList<RequestHandlerImpl>();
        int size = requestResponses.length;
        int i = 0;
        while (i < size) {
            Request request = requestResponses[i];
            RequestHandlerImpl handler = new RequestHandlerImpl(request);
            requestHandlers.add(handler);
            ++i;
        }
        return requestHandlers;
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.selection = selection;
    }

    public static void checkAndCreateContainer(IPath containerPath) {
        IResource resource = ResourcesPlugin.getWorkspace().getRoot().findMember(containerPath);
        if (resource == null) {
            try {
                ContainerGenerator generator = new ContainerGenerator(containerPath);
                generator.generateContainer(null);
            }
            catch (CoreException coreException) {}
        }
    }
}

