/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.web.ui.internal.contentassist;

import java.util.ArrayList;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.wst.jsdt.web.core.javascript.IJsTranslation;
import org.eclipse.wst.jsdt.web.core.javascript.JsTranslationAdapter;
import org.eclipse.wst.jsdt.web.ui.internal.contentassist.Messages;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.ui.internal.contentassist.CustomCompletionProposal;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;

public class JSDTHtmlCompletionProcessor {
    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int offset) {
        ArrayList allProposals = new ArrayList();
        this.getJSPTranslation(viewer);
        return allProposals.toArray(new ICompletionProposal[allProposals.size()]);
    }

    public ICompletionProposal getEndScriptProposal(ITextViewer viewer, int offset) {
        IJsTranslation tran = this.getJSPTranslation(viewer);
        if (tran == null) {
            return null;
        }
        int missingAtOffset = tran.getMissingTagStart();
        if (offset >= missingAtOffset && missingAtOffset > -1) {
            String allText = viewer.getDocument().get();
            String text = "</script>";
            int startInTag = -1;
            int i = 0;
            while (i < text.length() && allText.length() > offset - 1) {
                if (allText.charAt(offset - 1) == text.charAt(i)) {
                    startInTag = i;
                    break;
                }
                ++i;
            }
            if (startInTag == -1) {
                String displayText = Messages.getString("JSDTHtmlCompletionProcessor.1");
                return new CustomCompletionProposal("\n" + text + "\n", offset, 0, offset, null, displayText, null, Messages.getString("JSDTHtmlCompletionProcessor.4"), 100);
            }
            String text1 = allText.substring(offset - startInTag - 1, offset).toLowerCase();
            String text2 = text.substring(0, startInTag + 1).toLowerCase();
            if (startInTag > -1 && text2.compareTo(text1) == 0) {
                String displayText = Messages.getString("JSDTHtmlCompletionProcessor.5");
                return new CustomCompletionProposal(text, offset - startInTag - 1, 0, text.length(), null, displayText, null, Messages.getString("JSDTHtmlCompletionProcessor.6"), 100);
            }
        }
        return null;
    }

    private IJsTranslation getJSPTranslation(ITextViewer viewer) {
        IDOMModel xmlModel = null;
        try {
            xmlModel = (IDOMModel)StructuredModelManager.getModelManager().getExistingModelForRead(viewer.getDocument());
            IDOMDocument xmlDoc = xmlModel.getDocument();
            JsTranslationAdapter fTranslationAdapter = (JsTranslationAdapter)xmlDoc.getAdapterFor(IJsTranslation.class);
            if (fTranslationAdapter != null) {
                IJsTranslation iJsTranslation = fTranslationAdapter.getJsTranslation(true);
                return iJsTranslation;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (xmlModel != null) {
                xmlModel.releaseFromRead();
            }
        }
        return null;
    }
}

