/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.util;

import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.wst.jsdt.core.IClassFile;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IJavaScriptProject;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.ITypeRoot;
import org.eclipse.wst.jsdt.core.WorkingCopyOwner;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.ASTParser;
import org.eclipse.wst.jsdt.core.dom.JavaScriptUnit;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.ASTProvider;

public class RefactoringASTParser {
    private ASTParser fParser;

    public RefactoringASTParser(int level) {
        this.fParser = ASTParser.newParser((int)level);
    }

    public JavaScriptUnit parse(ITypeRoot typeRoot, boolean resolveBindings) {
        return this.parse(typeRoot, resolveBindings, null);
    }

    public JavaScriptUnit parse(ITypeRoot typeRoot, boolean resolveBindings, IProgressMonitor pm) {
        return this.parse(typeRoot, null, resolveBindings, pm);
    }

    public JavaScriptUnit parse(ITypeRoot typeRoot, WorkingCopyOwner owner, boolean resolveBindings, IProgressMonitor pm) {
        return this.parse(typeRoot, owner, resolveBindings, false, false, pm);
    }

    public JavaScriptUnit parse(ITypeRoot typeRoot, WorkingCopyOwner owner, boolean resolveBindings, boolean statementsRecovery, boolean bindingsRecovery, IProgressMonitor pm) {
        this.fParser.setResolveBindings(resolveBindings);
        this.fParser.setStatementsRecovery(statementsRecovery);
        this.fParser.setBindingsRecovery(bindingsRecovery);
        this.fParser.setSource(typeRoot);
        if (owner != null) {
            this.fParser.setWorkingCopyOwner(owner);
        }
        this.fParser.setCompilerOptions(RefactoringASTParser.getCompilerOptions((IJavaScriptElement)typeRoot));
        JavaScriptUnit result = (JavaScriptUnit)this.fParser.createAST(pm);
        return result;
    }

    public JavaScriptUnit parse(String newCuSource, IJavaScriptUnit originalCu, boolean resolveBindings, boolean statementsRecovery, IProgressMonitor pm) {
        this.fParser.setResolveBindings(resolveBindings);
        this.fParser.setStatementsRecovery(statementsRecovery);
        this.fParser.setSource(newCuSource.toCharArray());
        this.fParser.setUnitName(originalCu.getElementName());
        this.fParser.setProject(originalCu.getJavaScriptProject());
        this.fParser.setCompilerOptions(RefactoringASTParser.getCompilerOptions((IJavaScriptElement)originalCu));
        JavaScriptUnit newCUNode = (JavaScriptUnit)this.fParser.createAST(pm);
        return newCUNode;
    }

    public JavaScriptUnit parse(String newCfSource, IClassFile originalCf, boolean resolveBindings, boolean statementsRecovery, IProgressMonitor pm) {
        this.fParser.setResolveBindings(resolveBindings);
        this.fParser.setStatementsRecovery(statementsRecovery);
        this.fParser.setSource(newCfSource.toCharArray());
        String cfName = originalCf.getElementName();
        this.fParser.setUnitName(String.valueOf(cfName.substring(0, cfName.length() - 6)) + ".js");
        this.fParser.setProject(originalCf.getJavaScriptProject());
        this.fParser.setCompilerOptions(RefactoringASTParser.getCompilerOptions((IJavaScriptElement)originalCf));
        JavaScriptUnit newCUNode = (JavaScriptUnit)this.fParser.createAST(pm);
        return newCUNode;
    }

    public static JavaScriptUnit parseWithASTProvider(ITypeRoot typeRoot, boolean resolveBindings, IProgressMonitor pm) {
        JavaScriptUnit cuNode = ASTProvider.getASTProvider().getAST((IJavaScriptElement)typeRoot, ASTProvider.WAIT_ACTIVE_ONLY, pm);
        if (cuNode != null) {
            return cuNode;
        }
        return new RefactoringASTParser(3).parse(typeRoot, null, resolveBindings, true, true, pm);
    }

    public static IJavaScriptUnit getCompilationUnit(ASTNode node) {
        IJavaScriptElement cu;
        ASTNode root = node.getRoot();
        if (root instanceof JavaScriptUnit && (cu = ((JavaScriptUnit)root).getJavaElement()) instanceof IJavaScriptUnit) {
            return (IJavaScriptUnit)cu;
        }
        return null;
    }

    public static Map getCompilerOptions(IJavaScriptElement element) {
        IJavaScriptProject project = element.getJavaScriptProject();
        Map options = project.getOptions(true);
        for (String key : options.keySet()) {
            String value = (String)options.get(key);
            if (!"error".equals(value) && !"warning".equals(value)) continue;
            options.put(key, "ignore");
        }
        options.put("org.eclipse.wst.jsdt.core.compiler.taskTags", "");
        return options;
    }
}

