/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.cxf.ui.widgets;

import org.eclipse.jst.ws.internal.cxf.core.CXFCorePlugin;
import org.eclipse.jst.ws.internal.cxf.core.context.Java2WSPersistentContext;
import org.eclipse.jst.ws.internal.cxf.core.utils.CXFModelUtils;
import org.eclipse.jst.ws.internal.cxf.ui.CXFUIMessages;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;

public class AnnotationsComposite
extends Composite {
    private Java2WSPersistentContext context = CXFCorePlugin.getDefault().getJava2WSContext();
    private Button generateWebMethodButton;
    private Button generateWebParamButton;
    private Button generateRequestWrapperButton;
    private Button generateResponseWrapperButton;
    private Button generateWebResultButton;
    private Button enableAPTButton;

    public AnnotationsComposite(Composite parent, int style) {
        super(parent, style);
        this.addControls();
    }

    private void addControls() {
        GridLayout preflayout = new GridLayout(1, true);
        this.setLayout((Layout)preflayout);
        GridData gridData = new GridData(4, 4, true, false);
        this.setLayoutData(gridData);
        Group jaxwsAnnotationsGroup = new Group((Composite)this, 4);
        jaxwsAnnotationsGroup.setText(CXFUIMessages.JAXWS_ANNOTATIONS_GROUP_LABEL);
        jaxwsAnnotationsGroup.setToolTipText(CXFUIMessages.JAXWS_ANNOTATIONS_GROUP_TOOLTIP);
        GridLayout gridLayout = new GridLayout(1, true);
        jaxwsAnnotationsGroup.setLayout((Layout)gridLayout);
        gridData = new GridData(4, 4, true, false);
        jaxwsAnnotationsGroup.setLayoutData((Object)gridData);
        this.generateWebMethodButton = new Button((Composite)jaxwsAnnotationsGroup, 32);
        this.generateWebMethodButton.setText(CXFUIMessages.JAXWS_GENERATE_WEB_METHOD);
        this.generateWebMethodButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean selected = ((Button)e.widget).getSelection();
                AnnotationsComposite.this.context.setGenerateWebMethodAnnotation(selected);
            }
        });
        this.generateWebMethodButton.setSelection(this.context.isGenerateWebMethodAnnotation());
        this.generateWebParamButton = new Button((Composite)jaxwsAnnotationsGroup, 32);
        this.generateWebParamButton.setText(CXFUIMessages.JAXWS_GENERATE_WEB_PARAM);
        this.generateWebParamButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean selected = ((Button)e.widget).getSelection();
                AnnotationsComposite.this.context.setGenerateWebParamAnnotation(selected);
            }
        });
        this.generateWebParamButton.setSelection(this.context.isGenerateWebParamAnnotation());
        this.generateRequestWrapperButton = new Button((Composite)jaxwsAnnotationsGroup, 32);
        this.generateRequestWrapperButton.setText(CXFUIMessages.JAXWS_GENERATE_REQUEST_WRAPPER);
        this.generateRequestWrapperButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean selected = ((Button)e.widget).getSelection();
                AnnotationsComposite.this.context.setGenerateRequestWrapperAnnotation(selected);
            }
        });
        this.generateRequestWrapperButton.setSelection(this.context.isGenerateRequestWrapperAnnotation());
        this.generateResponseWrapperButton = new Button((Composite)jaxwsAnnotationsGroup, 32);
        this.generateResponseWrapperButton.setText(CXFUIMessages.JAXWS_GENERATE_RESPONSE_WRAPPER);
        this.generateResponseWrapperButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean selected = ((Button)e.widget).getSelection();
                AnnotationsComposite.this.context.setGenerateResponseWrapperAnnotation(selected);
            }
        });
        this.generateResponseWrapperButton.setSelection(this.context.isGenerateResponseWrapperAnnotation());
        this.generateWebResultButton = new Button((Composite)jaxwsAnnotationsGroup, 32);
        this.generateWebResultButton.setText(CXFUIMessages.JAXWS_GENERATE_WEB_RESULT);
        this.generateWebResultButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean selected = ((Button)e.widget).getSelection();
                AnnotationsComposite.this.context.setGenerateWebResultAnnotation(selected);
            }
        });
        this.generateWebResultButton.setSelection(this.context.isGenerateWebResultAnnotation());
        Group annotationProcessingGroup = new Group((Composite)this, 4);
        annotationProcessingGroup.setText(CXFUIMessages.JAXWS_ANNOTATIONS_PROCESSING_GROUP_LABEL);
        annotationProcessingGroup.setToolTipText(CXFUIMessages.bind((String)CXFUIMessages.JAXWS_ENABLE_ANNOTATION_PROCESSING_TOOLTIP, (Object)this.context.getDefaultRuntimeType()));
        gridLayout = new GridLayout(1, true);
        annotationProcessingGroup.setLayout((Layout)gridLayout);
        gridData = new GridData(4, 4, true, false);
        annotationProcessingGroup.setLayoutData((Object)gridData);
        this.enableAPTButton = new Button((Composite)annotationProcessingGroup, 32);
        this.enableAPTButton.setText(CXFUIMessages.JAXWS_ENABLE_ANNOTATION_PROCESSING);
        this.enableAPTButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean selected = ((Button)e.widget).getSelection();
                AnnotationsComposite.this.context.setAnnotationProcessingEnabled(selected);
            }
        });
        this.enableAPTButton.setSelection(this.context.isAnnotationProcessingEnabled());
    }

    public void setDefaults() {
        this.generateWebMethodButton.setSelection(CXFModelUtils.getDefaultBooleanValue((int)2, (int)17));
        this.generateWebParamButton.setSelection(CXFModelUtils.getDefaultBooleanValue((int)2, (int)18));
        this.generateRequestWrapperButton.setSelection(CXFModelUtils.getDefaultBooleanValue((int)2, (int)19));
        this.generateResponseWrapperButton.setSelection(CXFModelUtils.getDefaultBooleanValue((int)2, (int)20));
        this.generateWebResultButton.setSelection(CXFModelUtils.getDefaultBooleanValue((int)2, (int)21));
        this.enableAPTButton.setSelection(CXFModelUtils.getDefaultBooleanValue((int)2, (int)16));
    }

    public void storeValues() {
        this.context.setGenerateWebMethodAnnotation(this.generateWebMethodButton.getSelection());
        this.context.setGenerateWebParamAnnotation(this.generateWebParamButton.getSelection());
        this.context.setGenerateRequestWrapperAnnotation(this.generateRequestWrapperButton.getSelection());
        this.context.setGenerateResponseWrapperAnnotation(this.generateResponseWrapperButton.getSelection());
        this.context.setGenerateWebResultAnnotation(this.generateWebResultButton.getSelection());
        this.context.setAnnotationProcessingEnabled(this.enableAPTButton.getSelection());
    }
}

