/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsp.ui.internal.hyperlink;

import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ui.JavaElementLabels;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.hyperlink.AbstractHyperlinkDetector;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.jst.jsp.core.internal.Logger;
import org.eclipse.jst.jsp.core.internal.java.IJSPTranslation;
import org.eclipse.jst.jsp.core.internal.java.JSPTranslationAdapter;
import org.eclipse.jst.jsp.core.internal.java.JSPTranslationExtension;
import org.eclipse.jst.jsp.ui.internal.JSPUIMessages;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.PartInitException;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.utils.StringUtils;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;

public class XMLJavaHyperlinkDetector
extends AbstractHyperlinkDetector {
    private static final String JAR_FILE_PROTOCOL = "jar:file:";

    private IHyperlink createHyperlink(String elementName, IRegion region, IDocument document) {
        block15: {
            String baseLocation;
            IStructuredModel model;
            block16: {
                IPath basePath;
                ITextFileBuffer textFileBuffer = FileBuffers.getTextFileBufferManager().getTextFileBuffer(document);
                if (textFileBuffer != null && (basePath = textFileBuffer.getLocation()) != null && !basePath.isEmpty()) {
                    IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(basePath.segment(0));
                    try {
                        if (basePath.segmentCount() > 1 && project.isAccessible() && project.hasNature("org.eclipse.jdt.core.javanature")) {
                            return this.createJavaElementHyperlink(JavaCore.create((IProject)project), elementName, region);
                        }
                    }
                    catch (CoreException e) {
                        Logger.logException((Throwable)e);
                    }
                }
                model = null;
                model = StructuredModelManager.getModelManager().getExistingModelForRead(document);
                if (model == null) break block15;
                baseLocation = model.getBaseLocation();
                if (baseLocation.startsWith("jar:/file:")) {
                    baseLocation = StringUtils.replace((String)baseLocation, (String)"jar:/", (String)"jar:");
                }
                if (!baseLocation.startsWith(JAR_FILE_PROTOCOL) || baseLocation.indexOf(33) <= JAR_FILE_PROTOCOL.length()) break block16;
                String baseFile = baseLocation.substring(JAR_FILE_PROTOCOL.length(), baseLocation.indexOf(33));
                Path basePath2 = new Path(baseFile);
                IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
                int i = 0;
                while (i < projects.length) {
                    try {
                        IPackageFragmentRoot root;
                        IJavaProject javaProject;
                        if (projects[i].isAccessible() && projects[i].hasNature("org.eclipse.jdt.core.javanature") && (javaProject = JavaCore.create((IProject)projects[i])).exists() && (root = javaProject.findPackageFragmentRoot((IPath)basePath2)) != null) {
                            IHyperlink iHyperlink = this.createJavaElementHyperlink(javaProject, elementName, region);
                            return iHyperlink;
                        }
                    }
                    catch (CoreException e) {
                        Logger.logException((Throwable)e);
                    }
                    ++i;
                }
                break block15;
            }
            Path basePath = new Path(baseLocation);
            if (basePath.segmentCount() > 1) {
                IHyperlink iHyperlink = this.createJavaElementHyperlink(JavaCore.create((IProject)ResourcesPlugin.getWorkspace().getRoot().getProject(basePath.segment(0))), elementName, region);
                return iHyperlink;
            }
            break block15;
            finally {
                if (model != null) {
                    model.releaseFromRead();
                }
            }
        }
        return null;
    }

    private boolean isJspJavaContent(IDocument document, IRegion region) {
        JSPTranslationExtension translation = null;
        IStructuredModel model = null;
        try {
            int javaOffset;
            IDOMDocument xmlDoc;
            JSPTranslationAdapter adapter;
            IDOMModel xmlModel;
            model = StructuredModelManager.getModelManager().getExistingModelForRead(document);
            if (model instanceof IDOMModel && (xmlModel = (IDOMModel)model) != null && (adapter = (JSPTranslationAdapter)(xmlDoc = xmlModel.getDocument()).getAdapterFor(IJSPTranslation.class)) != null && (translation = adapter.getJSPTranslation()) != null && (javaOffset = translation.getJavaOffset(region.getOffset())) > -1) {
                return true;
            }
        }
        finally {
            if (model != null) {
                model.releaseFromRead();
            }
        }
        return false;
    }

    private IHyperlink createJavaElementHyperlink(IJavaProject javaProject, String elementName, IRegion region) {
        if (javaProject != null && javaProject.exists()) {
            try {
                IType element = javaProject.findType(elementName);
                if (element != null && element.exists()) {
                    return new JavaElementHyperlink(region, (IJavaElement)element);
                }
            }
            catch (JavaModelException javaModelException) {}
        }
        return null;
    }

    public IHyperlink[] detectHyperlinks(ITextViewer textViewer, IRegion region, boolean canShowMultipleHyperlinks) {
        if (region != null && textViewer != null) {
            IHyperlink link;
            IRegion hyperlinkRegion;
            IDocument document = textViewer.getDocument();
            IRegion iRegion = hyperlinkRegion = region.getLength() > 0 ? region : this.selectQualifiedName(document, region.getOffset());
            if (hyperlinkRegion == null || this.isJspJavaContent(document, hyperlinkRegion)) {
                return null;
            }
            String name = null;
            try {
                name = document.get(hyperlinkRegion.getOffset(), hyperlinkRegion.getLength()).trim();
            }
            catch (BadLocationException badLocationException) {}
            if (name != null && (link = this.createHyperlink(name, hyperlinkRegion, document)) != null) {
                return new IHyperlink[]{link};
            }
        }
        return null;
    }

    private IRegion selectQualifiedName(IDocument document, int anchor) {
        try {
            char c;
            int offset = anchor;
            while (offset >= 0) {
                c = document.getChar(offset);
                if (!Character.isJavaIdentifierPart(c) && c != '.') break;
                --offset;
            }
            int start = offset;
            offset = anchor;
            int length = document.getLength();
            while (offset < length) {
                c = document.getChar(offset);
                if (!Character.isJavaIdentifierPart(c) && c != '.') break;
                ++offset;
            }
            int end = offset;
            if (start == end) {
                return new Region(start, 0);
            }
            return new Region(start + 1, end - start - 1);
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
    }

    static class JavaElementHyperlink
    implements IHyperlink {
        private final IJavaElement fElement;
        private final IRegion fRegion;

        JavaElementHyperlink(IRegion region, IJavaElement element) {
            this.fRegion = region;
            this.fElement = element;
        }

        public IRegion getHyperlinkRegion() {
            return this.fRegion;
        }

        public String getHyperlinkText() {
            String elementLabel = JavaElementLabels.getElementLabel((IJavaElement)this.fElement, (long)4471368321280L);
            return NLS.bind((String)JSPUIMessages.Open, (Object)elementLabel);
        }

        public String getTypeLabel() {
            return null;
        }

        public void open() {
            try {
                JavaUI.openInEditor((IJavaElement)this.fElement);
            }
            catch (PartInitException partInitException) {
            }
            catch (JavaModelException javaModelException) {}
        }
    }
}

