/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsp.css.ui.internal.views.properties;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jst.jsp.css.ui.internal.properties.JSPedCSSPropertySource;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.IPropertySourceProvider;
import org.eclipse.ui.views.properties.PropertySheetPage;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSNode;
import org.eclipse.wst.sse.core.internal.provisional.INodeAdapter;
import org.eclipse.wst.sse.core.internal.provisional.INodeNotifier;
import org.eclipse.wst.sse.ui.views.properties.PropertySheetConfiguration;
import org.eclipse.wst.xml.ui.internal.XMLUIMessages;

public class JSPedCSSPropertySheetConfiguration
extends PropertySheetConfiguration {
    private PropertiesRefreshJob fPropertiesRefreshJob = null;
    IPropertySheetPage fPropertySheetPage;
    private IPropertySourceProvider fPropertySourceProvider = null;
    private INodeAdapter fRefreshAdapter = new CSSPropertySheetRefreshAdapter();
    private INodeNotifier[] fSelectedNotifiers;

    public ISelection getInputSelection(IWorkbenchPart selectingPart, ISelection selection) {
        ISelection preferredSelection;
        if (this.fSelectedNotifiers != null) {
            int i = 0;
            while (i < this.fSelectedNotifiers.length) {
                this.fSelectedNotifiers[i].removeAdapter(this.fRefreshAdapter);
                ++i;
            }
            this.fSelectedNotifiers = null;
        }
        if ((preferredSelection = super.getInputSelection(selectingPart, selection)) instanceof IStructuredSelection) {
            Object[] selectedObjects = new Object[((IStructuredSelection)selection).size()];
            System.arraycopy(((IStructuredSelection)selection).toArray(), 0, selectedObjects, 0, selectedObjects.length);
            int i = 0;
            while (i < selectedObjects.length) {
                if (selectedObjects[i] instanceof ICSSNode) {
                    ICSSNode node = (ICSSNode)selectedObjects[i];
                    while (node.getNodeType() == 11 || node.getNodeType() == 9) {
                        node = node.getParentNode();
                        selectedObjects[i] = node;
                    }
                }
                ++i;
            }
            if (selectedObjects.length > 0) {
                ArrayList<Object> selectedNotifiers = new ArrayList<Object>(1);
                int i2 = 0;
                while (i2 < selectedObjects.length) {
                    if (selectedObjects[i2] instanceof INodeNotifier) {
                        selectedNotifiers.add(selectedObjects[i2]);
                        ((INodeNotifier)selectedObjects[i2]).addAdapter(this.fRefreshAdapter);
                    }
                    ++i2;
                }
                this.fSelectedNotifiers = selectedNotifiers.toArray(new INodeNotifier[selectedNotifiers.size()]);
            }
            preferredSelection = new StructuredSelection(selectedObjects);
        }
        return preferredSelection;
    }

    PropertiesRefreshJob getPropertiesRefreshJob() {
        if (this.fPropertiesRefreshJob == null) {
            this.fPropertiesRefreshJob = new PropertiesRefreshJob();
        }
        return this.fPropertiesRefreshJob;
    }

    public IPropertySourceProvider getPropertySourceProvider(IPropertySheetPage page) {
        if (this.fPropertySourceProvider == null) {
            this.fPropertySourceProvider = new CSSPropertySourceProvider();
            this.fPropertySheetPage = page;
        }
        return this.fPropertySourceProvider;
    }

    public void unconfigure() {
        super.unconfigure();
        if (this.fSelectedNotifiers != null) {
            int i = 0;
            while (i < this.fSelectedNotifiers.length) {
                this.fSelectedNotifiers[i].removeAdapter(this.fRefreshAdapter);
                ++i;
            }
            this.fSelectedNotifiers = null;
        }
    }

    private class CSSPropertySheetRefreshAdapter
    implements INodeAdapter {
        private CSSPropertySheetRefreshAdapter() {
        }

        public boolean isAdapterForType(Object type) {
            return false;
        }

        public void notifyChanged(INodeNotifier notifier, int eventType, Object changedFeature, Object oldValue, Object newValue, int pos) {
            if (JSPedCSSPropertySheetConfiguration.this.fPropertySheetPage != null) {
                JSPedCSSPropertySheetConfiguration.this.getPropertiesRefreshJob().addPropertySheetPage(JSPedCSSPropertySheetConfiguration.this.fPropertySheetPage);
            }
        }
    }

    private class CSSPropertySourceProvider
    implements IPropertySourceProvider {
        private IPropertySource fPropertySource = null;
        private ICSSNode fSource = null;

        private CSSPropertySourceProvider() {
        }

        public IPropertySource getPropertySource(Object object) {
            if (this.fSource != null && object.equals(this.fSource)) {
                return this.fPropertySource;
            }
            if (object instanceof ICSSNode) {
                this.fSource = (ICSSNode)object;
                this.fPropertySource = new JSPedCSSPropertySource(this.fSource);
            } else {
                this.fSource = null;
                this.fPropertySource = null;
            }
            return this.fPropertySource;
        }
    }

    private class PropertiesRefreshJob
    extends UIJob {
        public static final int UPDATE_DELAY = 200;
        private Set propertySheetPages;

        public PropertiesRefreshJob() {
            super(XMLUIMessages.JFaceNodeAdapter_1);
            this.propertySheetPages = null;
            this.setSystem(true);
            this.setPriority(20);
            this.propertySheetPages = new HashSet(1);
        }

        void addPropertySheetPage(IPropertySheetPage page) {
            this.propertySheetPages.add(page);
            this.schedule(200L);
        }

        public IStatus runInUIThread(IProgressMonitor monitor) {
            Object[] pages = this.propertySheetPages.toArray();
            this.propertySheetPages.clear();
            int i = 0;
            while (i < pages.length) {
                PropertySheetPage page = (PropertySheetPage)pages[i];
                if (page.getControl() != null && !page.getControl().isDisposed()) {
                    page.refresh();
                }
                ++i;
            }
            return Status.OK_STATUS;
        }
    }
}

