/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.tests.rewrite.modifying;

import java.util.List;
import junit.framework.Test;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.IPackageFragment;
import org.eclipse.wst.jsdt.core.dom.AST;
import org.eclipse.wst.jsdt.core.dom.Block;
import org.eclipse.wst.jsdt.core.dom.Expression;
import org.eclipse.wst.jsdt.core.dom.FunctionDeclaration;
import org.eclipse.wst.jsdt.core.dom.JSdoc;
import org.eclipse.wst.jsdt.core.dom.JavaScriptUnit;
import org.eclipse.wst.jsdt.core.dom.ObjectLiteral;
import org.eclipse.wst.jsdt.core.dom.ObjectLiteralField;
import org.eclipse.wst.jsdt.core.dom.SimpleName;
import org.eclipse.wst.jsdt.core.dom.TagElement;
import org.eclipse.wst.jsdt.core.dom.TextElement;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationFragment;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationStatement;
import org.eclipse.wst.jsdt.core.tests.model.SuiteOfTestCases;
import org.eclipse.wst.jsdt.core.tests.rewrite.modifying.ASTRewritingModifyingTest;

public class ASTRewritingModifyingInsertTest
extends ASTRewritingModifyingTest {
    private static final Class THIS = ASTRewritingModifyingInsertTest.class;

    public ASTRewritingModifyingInsertTest(String name) {
        super(name);
    }

    public static Test allTests() {
        return new SuiteOfTestCases.Suite(THIS);
    }

    public static Test suite() {
        return ASTRewritingModifyingInsertTest.allTests();
    }

    public void test0001() throws Exception {
        IPackageFragment pack1 = this.fSourceFolder.createPackageFragment("test0001", false, null);
        StringBuffer buf = new StringBuffer();
        buf.append("var test0001;\n");
        buf.append("\n");
        buf.append("function X() {\n");
        buf.append("\n");
        buf.append("}\n");
        buf.append("function Y() {\n");
        buf.append("\n");
        buf.append("}\n");
        buf.append("function Z() {\n");
        buf.append("\n");
        buf.append("}\n");
        IJavaScriptUnit cu = pack1.createCompilationUnit("X.js", buf.toString(), false, null);
        JavaScriptUnit astRoot = this.createCU(cu, false);
        astRoot.recordModifications();
        AST a = astRoot.getAST();
        List statements = astRoot.statements();
        FunctionDeclaration functionDeclaration = a.newFunctionDeclaration();
        SimpleName name = a.newSimpleName("AAA");
        functionDeclaration.setName(name);
        statements.add(0, functionDeclaration);
        String preview = this.evaluateRewrite(cu, astRoot);
        buf = new StringBuffer();
        buf.append("function AAA() {\n");
        buf.append("}\n");
        buf.append("var test0001;\n");
        buf.append("\n");
        buf.append("function X() {\n");
        buf.append("\n");
        buf.append("}\n");
        buf.append("function Y() {\n");
        buf.append("\n");
        buf.append("}\n");
        buf.append("function Z() {\n");
        buf.append("\n");
        buf.append("}\n");
        ASTRewritingModifyingInsertTest.assertEqualString(preview, buf.toString());
    }

    public void test0002() throws Exception {
        IPackageFragment pack1 = this.fSourceFolder.createPackageFragment("test0002", false, null);
        StringBuffer buf = new StringBuffer();
        buf.append("var test0002;\n");
        buf.append("\n");
        buf.append("function X() {\n");
        buf.append("\n");
        buf.append("}\n");
        buf.append("function Y() {\n");
        buf.append("\n");
        buf.append("}\n");
        buf.append("function Z() {\n");
        buf.append("\n");
        buf.append("}\n");
        IJavaScriptUnit cu = pack1.createCompilationUnit("X.js", buf.toString(), false, null);
        JavaScriptUnit astRoot = this.createCU(cu, false);
        astRoot.recordModifications();
        AST a = astRoot.getAST();
        List statements = astRoot.statements();
        FunctionDeclaration functionDeclaration = a.newFunctionDeclaration();
        SimpleName name = a.newSimpleName("AAA");
        functionDeclaration.setName(name);
        statements.add(1, functionDeclaration);
        String preview = this.evaluateRewrite(cu, astRoot);
        buf = new StringBuffer();
        buf.append("var test0002;\n");
        buf.append("\n");
        buf.append("function AAA() {\n");
        buf.append("}\n");
        buf.append("function X() {\n");
        buf.append("\n");
        buf.append("}\n");
        buf.append("function Y() {\n");
        buf.append("\n");
        buf.append("}\n");
        buf.append("function Z() {\n");
        buf.append("\n");
        buf.append("}\n");
        ASTRewritingModifyingInsertTest.assertEqualString(preview, buf.toString());
    }

    public void test0003() throws Exception {
        IPackageFragment pack1 = this.fSourceFolder.createPackageFragment("test0003", false, null);
        StringBuffer buf = new StringBuffer();
        buf.append("var test0003;\n");
        buf.append("\n");
        buf.append("function X() {\n");
        buf.append("\n");
        buf.append("}\n");
        buf.append("function Y() {\n");
        buf.append("\n");
        buf.append("}\n");
        buf.append("function Z() {\n");
        buf.append("\n");
        buf.append("}\n");
        IJavaScriptUnit cu = pack1.createCompilationUnit("X.js", buf.toString(), false, null);
        JavaScriptUnit astRoot = this.createCU(cu, false);
        astRoot.recordModifications();
        AST a = astRoot.getAST();
        List statements = astRoot.statements();
        FunctionDeclaration functionDeclaration = a.newFunctionDeclaration();
        SimpleName name = a.newSimpleName("AAA");
        functionDeclaration.setName(name);
        statements.add(4, functionDeclaration);
        String preview = this.evaluateRewrite(cu, astRoot);
        buf = new StringBuffer();
        buf.append("var test0003;\n");
        buf.append("\n");
        buf.append("function X() {\n");
        buf.append("\n");
        buf.append("}\n");
        buf.append("function Y() {\n");
        buf.append("\n");
        buf.append("}\n");
        buf.append("function Z() {\n");
        buf.append("\n");
        buf.append("}\n");
        buf.append("function AAA() {\n");
        buf.append("}\n");
        ASTRewritingModifyingInsertTest.assertEqualString(preview, buf.toString());
    }

    public void test0004() throws Exception {
        IPackageFragment pack1 = this.fSourceFolder.createPackageFragment("test0004", false, null);
        StringBuffer buf = new StringBuffer();
        buf.append("var test0004;\n");
        buf.append("\n");
        buf.append("function X() {\n");
        buf.append("\n");
        buf.append("}\n");
        IJavaScriptUnit cu = pack1.createCompilationUnit("X.js", buf.toString(), false, null);
        JavaScriptUnit astRoot = this.createCU(cu, false);
        astRoot.recordModifications();
        AST a = astRoot.getAST();
        List statements = astRoot.statements();
        FunctionDeclaration functionDeclaration = (FunctionDeclaration)statements.get(1);
        JSdoc jsdoc = a.newJSdoc();
        List tags = jsdoc.tags();
        TagElement tag = a.newTagElement();
        List fragment = tag.fragments();
        TextElement text = a.newTextElement();
        text.setText("NOTHING");
        fragment.add(text);
        tags.add(tag);
        functionDeclaration.setJavadoc(jsdoc);
        String preview = this.evaluateRewrite(cu, astRoot);
        buf = new StringBuffer();
        buf.append("var test0004;\n");
        buf.append("\n");
        buf.append("/**\n");
        buf.append(" * NOTHING\n");
        buf.append(" */\n");
        buf.append("function X() {\n");
        buf.append("\n");
        buf.append("}\n");
        ASTRewritingModifyingInsertTest.assertEqualString(preview, buf.toString());
    }

    public void test0005() throws Exception {
        IPackageFragment pack1 = this.fSourceFolder.createPackageFragment("test0005", false, null);
        StringBuffer buf = new StringBuffer();
        buf.append("function X() {\n");
        buf.append("}\n");
        IJavaScriptUnit cu = pack1.createCompilationUnit("X.js", buf.toString(), false, null);
        JavaScriptUnit astRoot = this.createCU(cu, false);
        astRoot.recordModifications();
        AST a = astRoot.getAST();
        List statements = astRoot.statements();
        FunctionDeclaration functionDeclaration = (FunctionDeclaration)statements.get(0);
        Block functionBody = functionDeclaration.getBody();
        FunctionDeclaration functionDeclaration2 = a.newFunctionDeclaration();
        functionDeclaration2.setName(a.newSimpleName("Z"));
        functionBody.statements().add(functionDeclaration2);
        String preview = this.evaluateRewrite(cu, astRoot);
        buf = new StringBuffer();
        buf.append("function X() {\n");
        buf.append("    function Z() {\n");
        buf.append("    }\n");
        buf.append("}\n");
        ASTRewritingModifyingInsertTest.assertEqualString(preview, buf.toString());
    }

    public void test0007() throws Exception {
        IPackageFragment pack1 = this.fSourceFolder.createPackageFragment("test0007", false, null);
        StringBuffer buf = new StringBuffer();
        buf.append("function X() {\n");
        buf.append("    function Y() {\n");
        buf.append("    }\n");
        buf.append("}\n");
        IJavaScriptUnit cu = pack1.createCompilationUnit("X.js", buf.toString(), false, null);
        JavaScriptUnit astRoot = this.createCU(cu, false);
        astRoot.recordModifications();
        AST a = astRoot.getAST();
        List statements = astRoot.statements();
        FunctionDeclaration functionDeclaration = (FunctionDeclaration)statements.get(0);
        Block functionBody = functionDeclaration.getBody();
        FunctionDeclaration functionDeclaration2 = a.newFunctionDeclaration();
        functionDeclaration2.setName(a.newSimpleName("Z"));
        functionBody.statements().add(functionDeclaration2);
        String preview = this.evaluateRewrite(cu, astRoot);
        buf = new StringBuffer();
        buf.append("function X() {\n");
        buf.append("    function Y() {\n");
        buf.append("    }\n");
        buf.append("    function Z() {\n");
        buf.append("    }\n");
        buf.append("}\n");
        ASTRewritingModifyingInsertTest.assertEqualString(preview, buf.toString());
    }

    public void test0008() throws Exception {
        String source = "\n";
        JavaScriptUnit astRoot = this.createCU(source.toCharArray());
        astRoot.recordModifications();
        AST a = astRoot.getAST();
        FunctionDeclaration functionDeclaration = a.newFunctionDeclaration();
        functionDeclaration.setName(a.newSimpleName("X"));
        astRoot.statements().add(functionDeclaration);
        String preview = this.evaluateRewrite(source, astRoot);
        StringBuffer buf = new StringBuffer();
        buf.append("\n");
        buf.append("function X() {\n");
        buf.append("}\n");
        ASTRewritingModifyingInsertTest.assertEqualString(preview, buf.toString());
    }

    public void test0009() throws Exception {
        IPackageFragment pack1 = this.fSourceFolder.createPackageFragment("test0009", false, null);
        StringBuffer buf = new StringBuffer();
        buf.append("var o = {\n");
        buf.append("con : function(args){},\n");
        buf.append("fun1 : function(args){}\n");
        buf.append("};\n");
        IJavaScriptUnit cu = pack1.createCompilationUnit("X.js", buf.toString(), false, null);
        JavaScriptUnit astRoot = this.createCU(cu, false);
        astRoot.recordModifications();
        AST a = astRoot.getAST();
        List statements = astRoot.statements();
        VariableDeclarationStatement varDeclaration = (VariableDeclarationStatement)statements.get(0);
        VariableDeclarationFragment frag = (VariableDeclarationFragment)varDeclaration.fragments().get(0);
        ObjectLiteral obLit = (ObjectLiteral)frag.getInitializer();
        List fields = obLit.fields();
        ObjectLiteralField newObjectLiteralField = a.newObjectLiteralField();
        newObjectLiteralField.setFieldName((Expression)a.newSimpleName("newMethod"));
        newObjectLiteralField.setInitializer((Expression)a.newFunctionExpression());
        fields.add(newObjectLiteralField);
        String preview = this.evaluateRewrite(cu, astRoot);
        buf = new StringBuffer();
        buf.append("var o = {\n");
        buf.append("con : function(args){},\n");
        buf.append("fun1 : function(args){}, ");
        buf.append("newMethod : function (){}\n");
        buf.append("};\n");
        ASTRewritingModifyingInsertTest.assertEqualString(preview, buf.toString());
    }
}

