/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.jaxws.testutils.jobs;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.TypeNameRequestor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jst.ws.jaxws.testutils.threading.TestContext;
import org.eclipse.jst.ws.jaxws.utils.logging.ILogger;
import org.eclipse.jst.ws.jaxws.utils.logging.Logger;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;

public class JobUtils {
    public static void waitForJobsInterruptable() throws InterruptedException {
        while (Job.getJobManager().currentJob() != null) {
            JobUtils.delay(5L);
        }
    }

    public static void waitForJobs() throws JavaModelException {
        JobUtils.waitForDummyJob(10);
        while (true) {
            try {
                JobUtils.waitForJobsInterruptable();
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
        JobUtils.waitForIndexer();
        JobUtils.waitForNotifications();
    }

    public static void delay(long millis) throws InterruptedException {
        Display display = Display.getCurrent();
        if (display != null) {
            long entTimeMillis = System.currentTimeMillis() + millis;
            while (System.currentTimeMillis() < entTimeMillis) {
                if (display.readAndDispatch()) continue;
                display.sleep();
            }
            display.update();
        } else {
            Thread.sleep(1000L);
        }
    }

    public static void waitForIndexer() throws JavaModelException {
        new SearchEngine().searchAllTypeNames(null, 0, null, 8, 5, SearchEngine.createJavaSearchScope((IJavaElement[])new IJavaElement[0]), new TypeNameRequestor(){

            public void acceptClass(char[] packageName, char[] simpleTypeName, char[][] enclosingTypeNames, String path) {
            }

            public void acceptInterface(char[] packageName, char[] simpleTypeName, char[][] enclosingTypeNames, String path) {
            }
        }, 3, null);
    }

    private static void waitForDummyJob(int priority) {
        try {
            JobUtils.waitForDummyJobWithPrio(priority);
        }
        catch (InterruptedException interruptedException) {}
    }

    private static void waitForDummyJobWithPrio(int prio) throws InterruptedException {
        Job myDummyJob = new Job("DUMMY"){

            protected IStatus run(IProgressMonitor monitor) {
                return Status.OK_STATUS;
            }
        };
        myDummyJob.setPriority(prio);
        myDummyJob.setUser(false);
        myDummyJob.schedule();
        myDummyJob.join();
    }

    private static void waitForNotifications() {
        final IWorkspace workspace = ResourcesPlugin.getWorkspace();
        final IWorkspaceRunnable dummyRunnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
            }
        };
        Job notifForcingJob = new Job("Delivering notifications..."){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    workspace.run(dummyRunnable, null, 1, null);
                }
                catch (CoreException e) {
                    JobUtils.logger().logDebug(e.getMessage(), (Throwable)e);
                }
                return Status.OK_STATUS;
            }
        };
        JobUtils.syncExecJob(notifForcingJob, PlatformUI.getWorkbench().getDisplay());
    }

    public static void waitForJobsSlow() throws JavaModelException {
        JobUtils.waitForJobs();
        JobUtils.waitForDummyJob(50);
        JobUtils.waitForEventLoop();
    }

    private static void waitForEventLoop() {
        final Display display = PlatformUI.getWorkbench().getDisplay();
        Runnable runnable = new Runnable(){

            public void run() {
                while (display.readAndDispatch()) {
                }
            }
        };
        if (Display.getCurrent() != null) {
            runnable.run();
        } else {
            display.syncExec(runnable);
        }
    }

    private static void syncExecJob(final Job job, Display display) {
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                job.schedule();
                try {
                    job.join();
                }
                catch (InterruptedException e) {
                    JobUtils.logger().logDebug(e.getMessage(), (Throwable)e);
                }
            }
        };
        try {
            TestContext.run(runnable, Display.getCurrent() != null, (IProgressMonitor)new NullProgressMonitor(), display);
        }
        catch (InvocationTargetException e) {
            JobUtils.logger().logDebug(e.getMessage(), (Throwable)e);
        }
        catch (InterruptedException e) {
            JobUtils.logger().logDebug(e.getMessage(), (Throwable)e);
        }
    }

    private static ILogger logger() {
        return new Logger();
    }
}

