/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.tests.internal.reference;

import org.eclipse.jpt.common.utility.internal.reference.SimpleObjectReference;
import org.eclipse.jpt.common.utility.reference.ModifiableObjectReference;
import org.eclipse.jpt.common.utility.tests.internal.reference.ObjectReferenceTests;

public abstract class ModifiableObjectReferenceTests
extends ObjectReferenceTests {
    public ModifiableObjectReferenceTests(String name) {
        super(name);
    }

    protected ModifiableObjectReference<String> buildObjectReference() {
        return (ModifiableObjectReference)super.buildObjectReference();
    }

    protected abstract ModifiableObjectReference<String> buildObjectReference(String var1);

    public void testSetNull() {
        ModifiableObjectReference<String> or = this.buildObjectReference();
        ModifiableObjectReferenceTests.assertNull((Object)or.getValue());
        or.setValue((Object)"foo");
        ModifiableObjectReferenceTests.assertEquals((String)"foo", (String)((String)or.getValue()));
        or.setNull();
        ModifiableObjectReferenceTests.assertNull((Object)or.getValue());
    }

    public void testCommit() throws Exception {
        String v1 = "foo";
        ModifiableObjectReference<String> or = this.buildObjectReference();
        ModifiableObjectReferenceTests.assertTrue((boolean)or.commit((Object)v1, null));
        ModifiableObjectReferenceTests.assertEquals((String)v1, (String)((String)or.getValue()));
        ModifiableObjectReferenceTests.assertFalse((boolean)or.commit((Object)v1, null));
        ModifiableObjectReferenceTests.assertEquals((String)v1, (String)((String)or.getValue()));
        String v2 = "bar";
        ModifiableObjectReferenceTests.assertTrue((boolean)or.commit((Object)v2, (Object)v1));
        ModifiableObjectReferenceTests.assertEquals((String)v2, (String)((String)or.getValue()));
        ModifiableObjectReferenceTests.assertFalse((boolean)or.commit((Object)v2, (Object)v1));
        ModifiableObjectReferenceTests.assertEquals((String)v2, (String)((String)or.getValue()));
    }

    public void testSwapRef() throws Exception {
        ModifiableObjectReference<String> or;
        ModifiableObjectReference<String> temp = or = this.buildObjectReference();
        ModifiableObjectReferenceTests.assertEquals(null, (String)((String)or.swap(temp)));
        SimpleObjectReference ref = new SimpleObjectReference((Object)"foo");
        ModifiableObjectReferenceTests.assertEquals((String)"foo", (String)((String)or.swap((ModifiableObjectReference)ref)));
        ModifiableObjectReferenceTests.assertEquals((String)"foo", (String)((String)or.getValue()));
        ModifiableObjectReferenceTests.assertEquals(null, (String)((String)ref.getValue()));
        or.setValue((Object)"foo");
        ref.setValue((Object)"foo");
        ModifiableObjectReferenceTests.assertEquals((String)"foo", (String)((String)or.swap((ModifiableObjectReference)ref)));
        ModifiableObjectReferenceTests.assertEquals((String)"foo", (String)((String)or.getValue()));
        ModifiableObjectReferenceTests.assertEquals((String)"foo", (String)((String)ref.getValue()));
    }
}

