/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.dtmanager.converter.operations.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.StringTokenizer;
import javax.xml.namespace.NamespaceContext;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jst.pagedesigner.dtmanager.converter.operations.AbstractTransformOperation;
import org.w3c.dom.Element;

public class CreateAttributeFromXPathOperation
extends AbstractTransformOperation {
    private static final String DEFAULT_PREFIX = "prefix";
    private String attributeName;
    private String xPathExpression;
    private String nsURI;
    private String prefixedTokens;

    public Element transform(Element srcElement, Element curElement) {
        if (this.getParameters().length < 2) {
            this.getLog().error("Warning.TransformOperationFactory.TooFewParameters", this.getTransformOperationID());
            return null;
        }
        this.attributeName = this.getParameters()[0];
        this.xPathExpression = this.getParameters()[1];
        Assert.isNotNull((Object)this.attributeName);
        Assert.isNotNull((Object)this.xPathExpression);
        if (this.getParameters().length > 3) {
            this.nsURI = this.getParameters()[2];
            Assert.isNotNull((Object)this.nsURI);
            this.prefixedTokens = this.getParameters()[3];
            Assert.isNotNull((Object)this.prefixedTokens);
        }
        if (srcElement != null) {
            XPath xPath = XPathFactory.newInstance().newXPath();
            try {
                Object resultObject = xPath.evaluate(this.xPathExpression, srcElement, XPathConstants.STRING);
                if (resultObject instanceof String && curElement != null) {
                    if (((String)resultObject).equals("0") && this.nsURI != null && this.prefixedTokens != null) {
                        xPath.setNamespaceContext(new NSContext(this.nsURI, DEFAULT_PREFIX));
                        resultObject = xPath.evaluate(this.getPrefixedExpression(DEFAULT_PREFIX), srcElement, XPathConstants.STRING);
                    }
                    curElement.setAttribute(this.attributeName, (String)resultObject);
                }
            }
            catch (XPathExpressionException xPathExpressionException) {}
        }
        return curElement;
    }

    private String getPrefixedExpression(String prefix) {
        String prefixedExpression = this.xPathExpression;
        ArrayList<String> tokens = new ArrayList<String>();
        StringTokenizer tokenizer = new StringTokenizer(this.prefixedTokens, ",");
        while (tokenizer.hasMoreTokens()) {
            tokens.add(tokenizer.nextToken());
        }
        for (String token : tokens) {
            prefixedExpression = prefixedExpression.replace(token, String.valueOf(prefix) + ":" + token);
        }
        return prefixedExpression;
    }

    class NSContext
    implements NamespaceContext {
        private String _namespaceURI;
        private String _prefix;

        public NSContext(String namespaceURI, String prefix) {
            this._namespaceURI = namespaceURI;
            this._prefix = prefix;
        }

        public String getNamespaceURI(String prefix) {
            return this._namespaceURI;
        }

        public String getPrefix(String namespaceURI) {
            return this._prefix;
        }

        public Iterator getPrefixes(String namespaceURI) {
            return Arrays.asList(this._prefix).iterator();
        }
    }
}

