/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.jaxws.utils.tests.internal.annotations;

import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jst.ws.jaxws.testutils.project.ClassLoadingTest;
import org.eclipse.jst.ws.jaxws.utils.annotations.AnnotationFactory;
import org.eclipse.jst.ws.jaxws.utils.annotations.AnnotationGeneratorException;
import org.eclipse.jst.ws.jaxws.utils.annotations.AnnotationWriter;
import org.eclipse.jst.ws.jaxws.utils.annotations.IAnnotation;
import org.eclipse.jst.ws.jaxws.utils.annotations.IParamValuePair;
import org.eclipse.jst.ws.jaxws.utils.annotations.IValue;
import org.eclipse.jst.ws.jaxws.utils.internal.annotations.impl.ArrayValueImpl;
import org.eclipse.jst.ws.jaxws.utils.internal.annotations.impl.StringValueImpl;

public class ArrayValueImplTest
extends ClassLoadingTest {
    private static final String SRC = "src";
    private static final String PCK = "org.eclipse.demo";
    private IType endpoint;

    public void setUp() throws CoreException, IOException, AnnotationGeneratorException {
        this.createJavaProject(SRC, PCK);
        this.endpoint = this.createClass("Endpoint.src", "Endpoint");
        AnnotationFactory.removeAnnotationsFromJavaElement((IJavaElement)this.endpoint);
    }

    public void testHashCode() {
        HashSet<StringValueImpl> values1 = new HashSet<StringValueImpl>();
        values1.clear();
        values1.add(new StringValueImpl("val1"));
        ArrayValueImpl av1 = new ArrayValueImpl(values1);
        HashSet<StringValueImpl> values2 = new HashSet<StringValueImpl>();
        values2.clear();
        values2.add(new StringValueImpl("val2"));
        ArrayValueImpl av2 = new ArrayValueImpl(values2);
        ArrayValueImplTest.assertTrue((av1.hashCode() != av2.hashCode() ? 1 : 0) != 0);
    }

    public void testArrayValueImpl() {
        try {
            new ArrayValueImpl(null);
            ArrayValueImplTest.fail((String)"NullPointerException not thrown");
        }
        catch (NullPointerException nullPointerException) {
            ArrayValueImplTest.assertTrue((boolean)true);
        }
    }

    public void testEqualsObject() {
        HashSet<StringValueImpl> values1 = new HashSet<StringValueImpl>();
        values1.clear();
        values1.add(new StringValueImpl("val1"));
        ArrayValueImpl av1 = new ArrayValueImpl(values1);
        HashSet<StringValueImpl> values2 = new HashSet<StringValueImpl>();
        values2.clear();
        values2.add(new StringValueImpl("val2"));
        ArrayValueImpl av2 = new ArrayValueImpl(values2);
        HashSet<StringValueImpl> values3 = new HashSet<StringValueImpl>();
        values3.clear();
        values3.add(new StringValueImpl("val1"));
        ArrayValueImpl av3 = new ArrayValueImpl(values3);
        ArrayValueImplTest.assertFalse((boolean)av1.equals(null));
        ArrayValueImplTest.assertFalse((boolean)av1.equals((Object)123));
        ArrayValueImplTest.assertFalse((boolean)av1.equals((Object)av2));
        ArrayValueImplTest.assertTrue((boolean)av1.equals((Object)av3));
        ArrayValueImplTest.assertTrue((boolean)av1.equals((Object)av1));
    }

    public void testArrays() throws Exception {
        this.setUp();
        HashSet<StringValueImpl> values = new HashSet<StringValueImpl>();
        values.clear();
        values.add(new StringValueImpl("val1"));
        values.add(new StringValueImpl("val2"));
        ArrayValueImpl av = new ArrayValueImpl(values);
        HashSet<IParamValuePair> pv = new HashSet<IParamValuePair>();
        pv.add(AnnotationFactory.createParamValuePairValue((String)"param", (IValue)av));
        IAnnotation ann = AnnotationFactory.createAnnotation((String)"org.eclipse.test.MyAnnotation", pv, (IJavaElement)this.endpoint);
        AnnotationWriter.getInstance().setAppliedElement(ann, (IJavaElement)this.endpoint);
        Collection annotattions = AnnotationFactory.createAnnotationInspector((IType)this.endpoint).inspectType();
        ArrayValueImplTest.assertNotNull((Object)annotattions);
        ArrayValueImplTest.assertTrue((annotattions.size() == 1 ? 1 : 0) != 0);
        IAnnotation readAnnotation = (IAnnotation)annotattions.iterator().next();
        readAnnotation.equals(ann);
        AnnotationWriter.getInstance().remove(ann);
        annotattions = AnnotationFactory.createAnnotationInspector((IType)this.endpoint).inspectType();
        ArrayValueImplTest.assertNotNull((Object)annotattions);
        ArrayValueImplTest.assertTrue((annotattions.size() == 0 ? 1 : 0) != 0);
    }
}

