/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.editors.palette;

import org.eclipse.gef.EditDomain;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.dnd.TemplateTransferDragSourceListener;
import org.eclipse.gef.dnd.TransferDragSourceListener;
import org.eclipse.gef.internal.ui.palette.editparts.DrawerEditPart;
import org.eclipse.gef.ui.palette.PaletteContextMenuProvider;
import org.eclipse.gef.ui.palette.PaletteViewer;
import org.eclipse.gef.ui.palette.PaletteViewerProvider;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jst.pagedesigner.PDPlugin;
import org.eclipse.jst.pagedesigner.editors.palette.DesignerPaletteCustomizationsHelper;
import org.eclipse.jst.pagedesigner.editors.palette.DesignerPaletteCustomizer;
import org.eclipse.jst.pagedesigner.editors.palette.DesignerPaletteViewer;
import org.eclipse.jst.pagedesigner.editors.palette.Messages;
import org.eclipse.jst.pagedesigner.editors.palette.impl.TaglibPaletteDrawer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.PlatformUI;

public class DesignerPaletteViewerProvider
extends PaletteViewerProvider {
    public DesignerPaletteViewerProvider(EditDomain graphicalViewerDomain) {
        super(graphicalViewerDomain);
    }

    protected void configurePaletteViewer(PaletteViewer viewer) {
        viewer.setContextMenu((MenuManager)new PaletteContextMenuProvider(viewer){

            public void buildContextMenu(IMenuManager menu) {
                StructuredSelection sel = (StructuredSelection)this.getViewer().getSelection();
                if (sel != null && sel.getFirstElement() instanceof DrawerEditPart && ((DrawerEditPart)sel.getFirstElement()).getDrawer() instanceof TaglibPaletteDrawer) {
                    menu.add((IAction)new HideTagLibAction((DrawerEditPart)sel.getFirstElement(), Messages.DesignerPaletteViewerProvider_Hide));
                }
                super.buildContextMenu(menu);
            }
        });
        viewer.addDragSourceListener((TransferDragSourceListener)new TemplateTransferDragSourceListener((EditPartViewer)viewer));
    }

    public PaletteViewer createPaletteViewer(Composite parent) {
        DesignerPaletteViewer pViewer = new DesignerPaletteViewer();
        pViewer.createControl(parent);
        this.configurePaletteViewer(pViewer);
        pViewer.setCustomizer(new DesignerPaletteCustomizer());
        this.hookPaletteViewer(pViewer);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, PDPlugin.getResourceString("DesignerPaletteViewerProvider.help.id"));
        return pViewer;
    }

    private static class HideTagLibAction
    extends Action {
        private DrawerEditPart tagLib;

        public HideTagLibAction(DrawerEditPart tagLibDrawer, String string) {
            super(string);
            this.tagLib = tagLibDrawer;
        }

        public void run() {
            TaglibPaletteDrawer pd = (TaglibPaletteDrawer)this.tagLib.getDrawer();
            pd.setVisible(false);
            DesignerPaletteCustomizationsHelper.hideTaglibDrawer(pd);
        }
    }
}

