/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.common.project.facet.ui.libprov.user.internal;

import java.io.File;
import java.util.List;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.internal.core.JavaModelManager;
import org.eclipse.jdt.internal.core.UserLibraryManager;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.jst.common.project.facet.core.libprov.user.internal.DownloadableLibrary;
import org.eclipse.jst.common.project.facet.ui.internal.FacetedProjectFrameworkJavaExtUiPlugin;
import org.eclipse.jst.common.project.facet.ui.libprov.user.internal.DownloadLibraryWizard;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wst.common.project.facet.ui.internal.util.GridLayoutUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DownloadLibraryWizardMainPage
extends WizardPage {
    private final DownloadLibraryWizard wizard;
    private final List<DownloadableLibrary> libraries;
    private TableViewer librariesTableViewer;
    private Table librariesTable;
    private Label libraryNameLabel;
    private Text libraryNameTextField;
    private Label downloadDestinationLabel;
    private Text downloadDestinationTextField;
    private Button downloadDestinationBrowseButton;

    public DownloadLibraryWizardMainPage(DownloadLibraryWizard wizard, List<DownloadableLibrary> libraries) {
        super("DownloadableLibrariesWizardMainPage");
        this.wizard = wizard;
        this.libraries = libraries;
        this.setTitle(Resources.pageTitle);
        this.setDescription(Resources.pageDescription);
        this.setImageDescriptor(FacetedProjectFrameworkJavaExtUiPlugin.getImageDescriptor("images/wizban/download-library.png"));
    }

    public DownloadableLibrary getSelectedLibrary() {
        IStructuredSelection sel = (IStructuredSelection)this.librariesTableViewer.getSelection();
        return (DownloadableLibrary)sel.getFirstElement();
    }

    public String getLibraryName() {
        return this.libraryNameTextField.getText().trim();
    }

    public String getDownloadDestination() {
        return this.downloadDestinationTextField.getText().trim();
    }

    private List<DownloadableLibrary> getLibraries() {
        return this.libraries;
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)GridLayoutUtil.gl((int)2));
        this.librariesTableViewer = new TableViewer(composite, 67584);
        this.librariesTable = this.librariesTableViewer.getTable();
        this.librariesTable.setLayoutData((Object)GridLayoutUtil.gdhspan((GridData)GridLayoutUtil.gdfill(), (int)2));
        this.librariesTable.setLinesVisible(false);
        this.librariesTable.setHeaderVisible(true);
        TableViewerColumn libraryNameViewerColumn = new TableViewerColumn(this.librariesTableViewer, 0);
        final TableColumn libraryNameColumn = libraryNameViewerColumn.getColumn();
        libraryNameColumn.setText(Resources.libraryNameColumnTitle);
        libraryNameColumn.setResizable(true);
        libraryNameColumn.setWidth(300);
        libraryNameViewerColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                DownloadableLibrary library = (DownloadableLibrary)element;
                return library.getName();
            }
        });
        TableViewerColumn downloadProviderViewerColumn = new TableViewerColumn(this.librariesTableViewer, 0);
        final TableColumn downloadProviderColumn = downloadProviderViewerColumn.getColumn();
        downloadProviderColumn.setText(Resources.downloadProviderColumnTitle);
        downloadProviderColumn.setResizable(true);
        downloadProviderColumn.setWidth(300);
        downloadProviderViewerColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                DownloadableLibrary library = (DownloadableLibrary)element;
                return library.getDownloadProvider();
            }
        });
        IStructuredContentProvider contentProvider = new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                return DownloadLibraryWizardMainPage.this.getLibraries().toArray();
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        };
        final ViewerSorter nameAscendingSorter = new ViewerSorter(){

            public int compare(Viewer viewer, Object lib1, Object lib2) {
                String name1 = ((DownloadableLibrary)lib1).getName();
                String name2 = ((DownloadableLibrary)lib2).getName();
                return name1.compareTo(name2);
            }
        };
        final ViewerSorter nameDescendingSorter = new ViewerSorter(){

            public int compare(Viewer viewer, Object lib1, Object lib2) {
                String name1 = ((DownloadableLibrary)lib1).getName();
                String name2 = ((DownloadableLibrary)lib2).getName();
                return name2.compareTo(name1);
            }
        };
        final ViewerSorter providerAscendingSorter = new ViewerSorter(){

            public int compare(Viewer viewer, Object lib1, Object lib2) {
                String provider1 = ((DownloadableLibrary)lib1).getDownloadProvider();
                String provider2 = ((DownloadableLibrary)lib2).getDownloadProvider();
                return provider1.compareTo(provider2);
            }
        };
        final ViewerSorter providerDescendingSorter = new ViewerSorter(){

            public int compare(Viewer viewer, Object lib1, Object lib2) {
                String provider1 = ((DownloadableLibrary)lib1).getDownloadProvider();
                String provider2 = ((DownloadableLibrary)lib2).getDownloadProvider();
                return provider2.compareTo(provider1);
            }
        };
        this.librariesTableViewer.setSorter(nameAscendingSorter);
        this.librariesTable.setSortColumn(libraryNameColumn);
        this.librariesTable.setSortDirection(128);
        libraryNameColumn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                TableViewer tableViewer = DownloadLibraryWizardMainPage.this.librariesTableViewer;
                Table table = tableViewer.getTable();
                if (tableViewer.getSorter() == nameAscendingSorter) {
                    tableViewer.setSorter(nameDescendingSorter);
                    table.setSortDirection(1024);
                } else {
                    tableViewer.setSorter(nameAscendingSorter);
                    table.setSortColumn(libraryNameColumn);
                    table.setSortDirection(128);
                }
            }
        });
        downloadProviderColumn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                TableViewer tableViewer = DownloadLibraryWizardMainPage.this.librariesTableViewer;
                Table table = tableViewer.getTable();
                if (tableViewer.getSorter() == providerAscendingSorter) {
                    tableViewer.setSorter(providerDescendingSorter);
                    table.setSortDirection(1024);
                } else {
                    tableViewer.setSorter(providerAscendingSorter);
                    table.setSortColumn(downloadProviderColumn);
                    table.setSortDirection(128);
                }
            }
        });
        this.librariesTableViewer.setContentProvider((IContentProvider)contentProvider);
        this.librariesTableViewer.setInput(new Object());
        this.librariesTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                DownloadLibraryWizardMainPage.this.handleLibrarySelectionChanged();
            }
        });
        ModifyListener modifyListener = new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                DownloadLibraryWizardMainPage.this.updateValidation();
            }
        };
        this.libraryNameLabel = new Label(composite, 0);
        this.libraryNameLabel.setLayoutData((Object)GridLayoutUtil.gd());
        this.libraryNameLabel.setText(Resources.localLibraryNameLabel);
        this.libraryNameTextField = new Text(composite, 2048);
        this.libraryNameTextField.setLayoutData((Object)GridLayoutUtil.gdhfill());
        this.libraryNameTextField.addModifyListener(modifyListener);
        this.downloadDestinationLabel = new Label(composite, 0);
        this.downloadDestinationLabel.setLayoutData((Object)GridLayoutUtil.gd());
        this.downloadDestinationLabel.setText(Resources.downloadDestinationLabel);
        Composite downloadDestinationComposite = new Composite(composite, 0);
        downloadDestinationComposite.setLayoutData((Object)GridLayoutUtil.gdhfill());
        downloadDestinationComposite.setLayout((Layout)GridLayoutUtil.gl((int)2, (int)0, (int)0));
        this.downloadDestinationTextField = new Text(downloadDestinationComposite, 2048);
        this.downloadDestinationTextField.setLayoutData((Object)GridLayoutUtil.gdhfill());
        this.downloadDestinationTextField.addModifyListener(modifyListener);
        this.downloadDestinationBrowseButton = new Button(downloadDestinationComposite, 8);
        this.downloadDestinationBrowseButton.setLayoutData((Object)GridLayoutUtil.gd());
        this.downloadDestinationBrowseButton.setText(Resources.browseButtonLabel);
        this.downloadDestinationBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                DownloadLibraryWizardMainPage.this.handleBrowseForDestination();
            }
        });
        this.setControl((Control)composite);
        this.updateValidation();
    }

    private void handleLibrarySelectionChanged() {
        DownloadableLibrary lib = this.getSelectedLibrary();
        if (lib == null) {
            this.libraryNameTextField.setText("");
            this.downloadDestinationTextField.setText("");
        } else {
            String name;
            String localLibraryName = null;
            int counter = -1;
            do {
                localLibraryName = lib.getName();
                if (++counter <= 0) continue;
                localLibraryName = String.valueOf(localLibraryName) + " (" + counter + ")";
            } while (DownloadLibraryWizardMainPage.isUserLibraryDefined(localLibraryName));
            this.libraryNameTextField.setText(localLibraryName);
            IWorkspace ws = ResourcesPlugin.getWorkspace();
            IPath baseDestPath = ws.getRoot().getLocation().append("libraries");
            IPath destPath = null;
            counter = -1;
            do {
                name = lib.getName();
                if (++counter <= 0) continue;
                name = String.valueOf(name) + " (" + counter + ")";
            } while ((destPath = baseDestPath.append(name)).toFile().exists());
            this.downloadDestinationTextField.setText(destPath.toOSString());
        }
        this.wizard.getLicensePage().setLibrary(lib);
        this.updateValidation();
        this.getContainer().updateButtons();
    }

    private void handleBrowseForDestination() {
        File initialLocation = new File(this.downloadDestinationTextField.getText());
        if (initialLocation.isAbsolute()) {
            while (initialLocation != null && !initialLocation.exists()) {
                initialLocation = initialLocation.getParentFile();
            }
        } else {
            initialLocation = null;
        }
        DirectoryDialog dlg = new DirectoryDialog(Display.getDefault().getActiveShell());
        dlg.setMessage(Resources.destinationFolderBrowseDialogMessage);
        dlg.setFilterPath(initialLocation.getPath());
        String result = dlg.open();
        if (result != null) {
            this.downloadDestinationTextField.setText(result);
        }
    }

    private void updateValidation() {
        boolean enabled;
        if (this.getSelectedLibrary() == null) {
            this.setMessage(null);
            this.setPageComplete(false);
            enabled = false;
        } else {
            enabled = true;
            String localLibraryName = this.getLibraryName();
            String destPath = this.getDownloadDestination();
            if (localLibraryName.length() == 0) {
                this.setMessage(Resources.nameMustBeSpecified, 3);
                this.setPageComplete(false);
            } else if (destPath.length() == 0) {
                this.setMessage(Resources.destinationFolderMustBeSpecified, 3);
                this.setPageComplete(false);
            } else if (DownloadLibraryWizardMainPage.isUserLibraryDefined(localLibraryName)) {
                this.setMessage(Resources.nameConflict, 2);
                this.setPageComplete(true);
            } else {
                File destFolder = new File(destPath);
                if (destFolder.exists()) {
                    this.setMessage(Resources.destinationFolderExists, 2);
                    this.setPageComplete(true);
                } else if (!destFolder.isAbsolute()) {
                    this.setMessage(Resources.destinationFolderPathMustBeAbsolute, 3);
                    this.setPageComplete(false);
                } else {
                    this.setMessage(null);
                    this.setPageComplete(true);
                }
            }
        }
        this.libraryNameLabel.setEnabled(enabled);
        this.libraryNameTextField.setEnabled(enabled);
        this.downloadDestinationLabel.setEnabled(enabled);
        this.downloadDestinationTextField.setEnabled(enabled);
        this.downloadDestinationBrowseButton.setEnabled(enabled);
    }

    private static boolean isUserLibraryDefined(String name) {
        UserLibraryManager userLibraryManager = JavaModelManager.getUserLibraryManager();
        return userLibraryManager.getUserLibrary(name) != null;
    }

    private static final class Resources
    extends NLS {
        public static String pageTitle;
        public static String pageDescription;
        public static String libraryNameColumnTitle;
        public static String downloadProviderColumnTitle;
        public static String localLibraryNameLabel;
        public static String downloadDestinationLabel;
        public static String nameMustBeSpecified;
        public static String nameConflict;
        public static String destinationFolderMustBeSpecified;
        public static String destinationFolderExists;
        public static String destinationFolderPathMustBeAbsolute;
        public static String destinationFolderBrowseDialogMessage;
        public static String browseButtonLabel;

        static {
            Resources.initializeMessages((String)DownloadLibraryWizardMainPage.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

