/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util;

import java.io.IOException;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.thread.AutoLock;

public abstract class IteratingCallback
implements Callback {
    private final AutoLock _lock = new AutoLock();
    private State _state;
    private boolean _iterate;

    protected IteratingCallback() {
        this._state = State.IDLE;
    }

    protected IteratingCallback(boolean needReset) {
        this._state = needReset ? State.SUCCEEDED : State.IDLE;
    }

    protected abstract Action process() throws Throwable;

    protected void onCompleteSuccess() {
    }

    protected void onCompleteFailure(Throwable cause) {
    }

    /*
     * Unable to fully structure code
     */
    public void iterate() {
        process = false;
        lock = this._lock.lock();
        try {
            switch (1.$SwitchMap$org$eclipse$jetty$util$IteratingCallback$State[this._state.ordinal()]) {
                case 1: 
                case 2: {
                    ** break;
lbl7:
                    // 1 sources

                    break;
                }
                case 3: {
                    this._state = State.PROCESSING;
                    process = true;
                    ** break;
lbl12:
                    // 1 sources

                    break;
                }
                case 4: {
                    this._iterate = true;
                    ** break;
lbl16:
                    // 1 sources

                    break;
                }
                case 5: 
                case 6: {
                    ** break;
lbl19:
                    // 1 sources

                    break;
                }
                default: {
                    throw new IllegalStateException(this.toString());
                }
            }
        }
        finally {
            if (lock != null) {
                lock.close();
            }
        }
        if (process) {
            this.processing();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void processing() {
        boolean onCompleteSuccess = false;
        block22: while (true) {
            Action action;
            try {
                action = this.process();
            }
            catch (Throwable x) {
                this.failed(x);
                break;
            }
            AutoLock lock = this._lock.lock();
            try {
                switch (this._state) {
                    case PROCESSING: {
                        switch (action) {
                            case IDLE: {
                                if (this._iterate) {
                                    this._iterate = false;
                                    this._state = State.PROCESSING;
                                    continue block22;
                                }
                                this._state = State.IDLE;
                                break block22;
                            }
                            case SCHEDULED: {
                                this._state = State.PENDING;
                                break block22;
                            }
                            case SUCCEEDED: {
                                this._iterate = false;
                                this._state = State.SUCCEEDED;
                                onCompleteSuccess = true;
                                break block22;
                            }
                            default: {
                                throw new IllegalStateException(String.format("%s[action=%s]", new Object[]{this, action}));
                            }
                        }
                    }
                    case CALLED: {
                        if (action != Action.SCHEDULED) {
                            throw new IllegalStateException(String.format("%s[action=%s]", new Object[]{this, action}));
                        }
                        this._state = State.PROCESSING;
                        continue block22;
                    }
                    case FAILED: 
                    case SUCCEEDED: 
                    case CLOSED: {
                        break block22;
                    }
                    default: {
                        throw new IllegalStateException(String.format("%s[action=%s]", new Object[]{this, action}));
                    }
                }
            }
            finally {
                if (lock == null) continue;
                lock.close();
                continue;
            }
            break;
        }
        if (onCompleteSuccess) {
            this.onCompleteSuccess();
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void succeeded() {
        process = false;
        lock = this._lock.lock();
        try {
            switch (1.$SwitchMap$org$eclipse$jetty$util$IteratingCallback$State[this._state.ordinal()]) {
                case 4: {
                    this._state = State.CALLED;
                    ** break;
lbl8:
                    // 1 sources

                    break;
                }
                case 1: {
                    this._state = State.PROCESSING;
                    process = true;
                    ** break;
lbl13:
                    // 1 sources

                    break;
                }
                case 5: 
                case 7: {
                    ** break;
lbl16:
                    // 1 sources

                    break;
                }
                default: {
                    throw new IllegalStateException(this.toString());
                }
            }
        }
        finally {
            if (lock != null) {
                lock.close();
            }
        }
        if (process) {
            this.processing();
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void failed(Throwable x) {
        failure = false;
        lock = this._lock.lock();
        try {
            switch (1.$SwitchMap$org$eclipse$jetty$util$IteratingCallback$State[this._state.ordinal()]) {
                case 2: 
                case 3: 
                case 5: 
                case 6: 
                case 7: {
                    ** break;
lbl7:
                    // 1 sources

                    break;
                }
                case 1: 
                case 4: {
                    this._state = State.FAILED;
                    failure = true;
                    ** break;
lbl12:
                    // 1 sources

                    break;
                }
                default: {
                    throw new IllegalStateException(this.toString());
                }
            }
        }
        finally {
            if (lock != null) {
                lock.close();
            }
        }
        if (failure) {
            this.onCompleteFailure(x);
        }
    }

    /*
     * Unable to fully structure code
     */
    public void close() {
        failure = null;
        lock = this._lock.lock();
        try {
            switch (1.$SwitchMap$org$eclipse$jetty$util$IteratingCallback$State[this._state.ordinal()]) {
                case 3: 
                case 5: 
                case 6: {
                    this._state = State.CLOSED;
                    ** break;
lbl8:
                    // 1 sources

                    break;
                }
                case 7: {
                    ** break;
lbl11:
                    // 1 sources

                    break;
                }
                default: {
                    failure = String.format("Close %s in state %s", new Object[]{this, this._state});
                    this._state = State.CLOSED;
                    break;
                }
            }
        }
        finally {
            if (lock != null) {
                lock.close();
            }
        }
        if (failure != null) {
            this.onCompleteFailure(new IOException(failure));
        }
    }

    boolean isIdle() {
        try (AutoLock lock = this._lock.lock();){
            boolean bl = this._state == State.IDLE;
            return bl;
        }
    }

    public boolean isClosed() {
        try (AutoLock lock = this._lock.lock();){
            boolean bl = this._state == State.CLOSED;
            return bl;
        }
    }

    public boolean isFailed() {
        try (AutoLock lock = this._lock.lock();){
            boolean bl = this._state == State.FAILED;
            return bl;
        }
    }

    public boolean isSucceeded() {
        try (AutoLock lock = this._lock.lock();){
            boolean bl = this._state == State.SUCCEEDED;
            return bl;
        }
    }

    public boolean reset() {
        try (AutoLock lock = this._lock.lock();){
            switch (this._state) {
                case IDLE: {
                    boolean bl = true;
                    return bl;
                }
                case FAILED: 
                case SUCCEEDED: {
                    this._iterate = false;
                    this._state = State.IDLE;
                    boolean bl = true;
                    return bl;
                }
            }
            boolean bl = false;
            return bl;
        }
    }

    public String toString() {
        return String.format("%s@%x[%s]", new Object[]{this.getClass().getSimpleName(), this.hashCode(), this._state});
    }

    protected static enum Action {
        IDLE,
        SCHEDULED,
        SUCCEEDED;

    }

    private static enum State {
        IDLE,
        PROCESSING,
        PENDING,
        CALLED,
        SUCCEEDED,
        FAILED,
        CLOSED;

    }
}

