/*******************************************************************************
 * Copyright (c) 2005, 2007 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/

package org.eclipse.jst.ejb.ui.internal.actions;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.jst.j2ee.ejb.EJBJar;
import org.eclipse.jst.j2ee.internal.actions.BaseAction;
import org.eclipse.jst.j2ee.internal.ejb.project.operations.ClientJARCreationConstants;



public abstract class AbstractClientJARAction extends BaseAction implements ClientJARCreationConstants {

	
	protected IProject getProject() {
		IProject project = null;
		Object element = selection.getFirstElement();
		
		if (element instanceof EJBJar) 
			project = ProjectUtilities.getProject((EJBJar) element);
		else if (element instanceof IProject)
			project = (IProject) element;
		else if (element instanceof IAdaptable)
			project = ((IAdaptable)element).getAdapter(IProject.class);
		
		return project;
	}
}
