/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.catalog.tests.internal;

import java.io.File;
import java.net.URL;
import java.util.List;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.wst.xml.catalog.tests.internal.AbstractCatalogTest;
import org.eclipse.wst.xml.catalog.tests.internal.CatalogTest;
import org.eclipse.wst.xml.catalog.tests.internal.TestPlugin;
import org.eclipse.wst.xml.core.internal.catalog.Catalog;
import org.eclipse.wst.xml.core.internal.catalog.provisional.ICatalog;
import org.eclipse.wst.xml.core.internal.catalog.provisional.ICatalogEntry;
import org.eclipse.wst.xml.core.internal.catalog.provisional.INextCatalog;

public class CatalogWriterTest
extends AbstractCatalogTest {
    @Override
    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public CatalogWriterTest(String name) {
        super(name);
    }

    public final void testWrite() throws Exception {
        String catalogFile = "/data/catalog1.xml";
        URL catalogUrl = TestPlugin.getDefault().getBundle().getEntry(catalogFile);
        CatalogWriterTest.assertNotNull((Object)catalogUrl);
        URL resolvedURL = FileLocator.resolve((URL)catalogUrl);
        Catalog testCatalog = (Catalog)this.getCatalog("catalog1", resolvedURL.toString());
        CatalogWriterTest.assertNotNull((Object)testCatalog);
        testCatalog.setBase(resolvedURL.toString());
        CatalogWriterTest.assertNotNull((Object)testCatalog);
        URL resultsFolder = TestPlugin.getDefault().getBundle().getEntry("/");
        Path path = new Path(FileLocator.resolve((URL)resultsFolder).getFile());
        String resultCatalogFile = path.append("/catalog1.xml").toFile().toURI().toString();
        testCatalog.setLocation(resultCatalogFile);
        testCatalog.save();
        Catalog catalog = (Catalog)this.getCatalog("catalog2", testCatalog.getLocation());
        CatalogWriterTest.assertNotNull((Object)catalog);
        CatalogWriterTest.assertEquals((int)3, (int)catalog.getCatalogEntries().length);
        List entries = CatalogTest.getCatalogEntries((ICatalog)catalog, 2);
        CatalogWriterTest.assertEquals((int)1, (int)entries.size());
        ICatalogEntry entry = (ICatalogEntry)entries.get(0);
        CatalogWriterTest.assertEquals((String)this.getFileLocation("data/Invoice/Invoice.dtd"), (String)entry.getURI());
        CatalogWriterTest.assertEquals((String)"InvoiceId_test", (String)entry.getKey());
        CatalogWriterTest.assertEquals((String)"http://webURL", (String)entry.getAttributeValue("webURL"));
        entries = CatalogTest.getCatalogEntries((ICatalog)catalog, 3);
        CatalogWriterTest.assertEquals((int)1, (int)entries.size());
        entry = (ICatalogEntry)entries.get(0);
        CatalogWriterTest.assertEquals((String)this.getFileLocation("data/Invoice/Invoice.dtd"), (String)entry.getURI());
        CatalogWriterTest.assertEquals((String)"Invoice.dtd", (String)entry.getKey());
        CatalogWriterTest.assertEquals((String)"yes", (String)entry.getAttributeValue("chached"));
        CatalogWriterTest.assertEquals((String)"value1", (String)entry.getAttributeValue("property"));
        entries = CatalogTest.getCatalogEntries((ICatalog)catalog, 4);
        CatalogWriterTest.assertEquals((int)1, (int)entries.size());
        entry = (ICatalogEntry)entries.get(0);
        CatalogWriterTest.assertEquals((String)this.getFileLocation("data/Invoice/Invoice.dtd"), (String)entry.getURI());
        CatalogWriterTest.assertEquals((String)"http://www.test.com/Invoice.dtd", (String)entry.getKey());
        CatalogWriterTest.assertEquals((String)"no", (String)entry.getAttributeValue("chached"));
        CatalogWriterTest.assertEquals((String)"value2", (String)entry.getAttributeValue("property"));
        INextCatalog[] nextCatalogEntries = catalog.getNextCatalogs();
        CatalogWriterTest.assertEquals((int)1, (int)nextCatalogEntries.length);
        INextCatalog nextCatalogEntry = nextCatalogEntries[0];
        CatalogWriterTest.assertNotNull((Object)nextCatalogEntry);
        CatalogWriterTest.assertEquals((String)"catalog2.xml", (String)nextCatalogEntry.getCatalogLocation());
    }

    public final void testBug235445() throws Exception {
        String catalogFile = "/data/deletemecatalog.xml";
        URL catalogUrl = TestPlugin.getDefault().getBundle().getEntry(catalogFile);
        CatalogWriterTest.assertNotNull((Object)catalogUrl);
        URL resolvedURL = FileLocator.resolve((URL)catalogUrl);
        Catalog testCatalog = (Catalog)this.getCatalog("deletemecatalog", resolvedURL.toString());
        CatalogWriterTest.assertNotNull((Object)testCatalog);
        testCatalog.setBase(resolvedURL.toString());
        CatalogWriterTest.assertNotNull((Object)testCatalog);
        URL resultsFolder = TestPlugin.getDefault().getBundle().getEntry("/");
        Path path = new Path(FileLocator.resolve((URL)resultsFolder).getFile());
        final File catalogIOFile = path.append("/deletemecatalog.xml").toFile();
        String resultCatalogFile = catalogIOFile.toURI().toString();
        testCatalog.setLocation(resultCatalogFile);
        testCatalog.save();
        IWorkspaceRunnable deleteOp = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                try {
                    catalogIOFile.delete();
                }
                catch (Exception exception) {
                    CatalogWriterTest.assertTrue((String)"exception thrown when trying to delete catalog", (boolean)false);
                }
            }
        };
        ResourcesPlugin.getWorkspace().run(deleteOp, null);
        CatalogWriterTest.assertFalse((String)"catalog file was not deleted", (boolean)catalogIOFile.exists());
    }

    public void testReadAndWriteComplexCatalog() throws Exception {
        String catalogFile = "/data/delegateAndRewrite/catalog11.xml";
        URL catalogUrl = TestPlugin.getDefault().getBundle().getEntry(catalogFile);
        CatalogWriterTest.assertNotNull((Object)catalogUrl);
        URL base = FileLocator.resolve((URL)catalogUrl);
        Catalog catalog = (Catalog)this.getCatalog("catalog11", base.toString());
        CatalogWriterTest.assertNotNull((Object)catalog);
        CatalogWriterTest.assertEquals((int)13, (int)catalog.getCatalogElements().length);
        URL resultsFolder = TestPlugin.getDefault().getBundle().getEntry("/");
        Path path = new Path(FileLocator.resolve((URL)resultsFolder).getFile());
        String resultCatalogFile = path.append("/catalog11-x.xml").toFile().toURI().toString();
        catalog.setLocation(resultCatalogFile);
        catalog.save();
        catalog = (Catalog)this.getCatalog("catalog2", catalog.getLocation());
        CatalogWriterTest.assertNotNull((Object)catalog);
        CatalogWriterTest.assertEquals((int)13, (int)catalog.getCatalogElements().length);
        CatalogWriterTest.assertEquals((int)2, (int)CatalogTest.getCatalogEntries((ICatalog)catalog, 2).size());
        CatalogWriterTest.assertEquals((int)2, (int)CatalogTest.getCatalogEntries((ICatalog)catalog, 3).size());
        CatalogWriterTest.assertEquals((int)1, (int)CatalogTest.getCatalogEntries((ICatalog)catalog, 4).size());
        INextCatalog[] nextCatalogEntries = catalog.getNextCatalogs();
        CatalogWriterTest.assertEquals((int)1, (int)nextCatalogEntries.length);
        INextCatalog nextCatalogEntry = nextCatalogEntries[0];
        CatalogWriterTest.assertNotNull((Object)nextCatalogEntry);
        CatalogWriterTest.assertEquals((String)"catalog.xml", (String)nextCatalogEntry.getCatalogLocation());
    }
}

